/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.abstracts;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import top.craft_hello.tpa.abstracts.Request;
import top.craft_hello.tpa.enums.CommandType;
import top.craft_hello.tpa.enums.PermissionType;
import top.craft_hello.tpa.enums.TimerType;
import top.craft_hello.tpa.exceptions.ErrorBlockedByTargetException;
import top.craft_hello.tpa.exceptions.ErrorCommandCooldownException;
import top.craft_hello.tpa.exceptions.ErrorCommandDisabledException;
import top.craft_hello.tpa.exceptions.ErrorConsoleRestrictedException;
import top.craft_hello.tpa.exceptions.ErrorPermissionDeniedException;
import top.craft_hello.tpa.exceptions.ErrorRequestPendingException;
import top.craft_hello.tpa.exceptions.ErrorSelfOperationException;
import top.craft_hello.tpa.exceptions.ErrorSyntaxTpaException;
import top.craft_hello.tpa.exceptions.ErrorTargetOfflineException;
import top.craft_hello.tpa.objects.LanguageConfig;
import top.craft_hello.tpa.objects.PlayerDataConfig;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.HandyRunnable;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.HandySchedulerUtil;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.PlayerSchedulerUtil;
import top.craft_hello.tpa.utils.LoadingConfigUtil;
import top.craft_hello.tpa.utils.SendMessageUtil;

public abstract class PlayerToPlayerRequest
extends Request {
    protected Player requestPlayer;
    protected String requestPlayerName;
    protected Player targetPlayer;
    protected String targetPlayerName;

    public PlayerToPlayerRequest(CommandSender requestObject, String[] args, CommandType commandType) {
        this.delay = LoadingConfigUtil.getConfig().getAcceptDelay();
        this.checkError(requestObject, args, commandType);
        this.requestPlayer = (Player)requestObject;
        this.targetPlayer = Bukkit.getPlayerExact((String)args[args.length - 1]);
    }

    protected void isMove(@NotNull Location lastLocation, @NotNull Player executor, @NotNull Player target) {
        if (executor.getLocation().getX() != lastLocation.getX() || executor.getLocation().getY() != lastLocation.getY() || executor.getLocation().getZ() != lastLocation.getZ()) {
            REQUEST_QUEUE.remove(executor);
            REQUEST_QUEUE.remove(target);
            this.timer.cancel();
            this.checkMoveTimer.cancel();
            this.countdownMessageTimer.cancel();
            if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
                LanguageConfig language = LanguageConfig.getLanguage((CommandSender)this.requestPlayer);
                String title = language.getFormatMessage("teleport.canceled.self", new String[0]);
                if (LoadingConfigUtil.getConfig().isEnableSound()) {
                    PlayerSchedulerUtil.playSound(this.requestPlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                }
                this.requestPlayer.sendTitle(title, "");
            }
            SendMessageUtil.move(executor, target);
        }
    }

    protected void setCheckMoveTimer(final @NotNull Location lastLocation, final @NotNull Player executor, final @NotNull Player target) {
        HandyRunnable checkMoveTimer;
        this.checkMoveTimer = checkMoveTimer = new HandyRunnable(){
            long sec;
            {
                this.sec = PlayerToPlayerRequest.this.delay < 0L ? 60L : PlayerToPlayerRequest.this.delay * 20L;
            }

            @Override
            public void run() {
                try {
                    PlayerToPlayerRequest.this.isMove(lastLocation, executor, target);
                    if (--this.sec < 0L) {
                        this.cancel();
                    }
                }
                catch (Exception ignored) {
                    this.cancel();
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(checkMoveTimer, 0L, 1L);
    }

    protected void teleport() {
        REQUEST_QUEUE.remove(this.targetPlayer);
        if (LoadingConfigUtil.getConfig().isEnableTeleportDelay((CommandSender)this.requestPlayer)) {
            this.checkMoveTimer.cancel();
        }
    }

    protected void checkError(CommandSender requestObject, String[] args, CommandType commandType) {
        PermissionType permissionType;
        String command = commandType == CommandType.TPA ? "tpa" : "tphere";
        PermissionType permissionType2 = permissionType = commandType == CommandType.TPA ? PermissionType.TPA : PermissionType.TP_HERE;
        if (!(requestObject instanceof Player)) {
            throw new ErrorConsoleRestrictedException(requestObject);
        }
        this.requestPlayer = (Player)requestObject;
        this.requestPlayerName = this.requestPlayer.getName();
        if (!LoadingConfigUtil.getConfig().isEnableCommand(commandType)) {
            throw new ErrorCommandDisabledException((CommandSender)this.requestPlayer);
        }
        if (!LoadingConfigUtil.getConfig().hasPermission((CommandSender)this.requestPlayer, permissionType)) {
            throw new ErrorPermissionDeniedException((CommandSender)this.requestPlayer);
        }
        if (args.length != 1) {
            throw new ErrorSyntaxTpaException((CommandSender)this.requestPlayer, command);
        }
        this.targetPlayerName = args[args.length - 1];
        this.targetPlayer = Bukkit.getPlayerExact((String)this.targetPlayerName);
        if (COMMAND_DELAY_QUEUE.containsKey(this.requestPlayer)) {
            throw new ErrorCommandCooldownException((CommandSender)this.requestPlayer, (String)COMMAND_DELAY_QUEUE.get(this.requestPlayer));
        }
        if (REQUEST_QUEUE.containsKey(this.requestPlayer) || REQUEST_QUEUE.containsKey(this.targetPlayer)) {
            throw new ErrorRequestPendingException((CommandSender)this.requestPlayer);
        }
        if (this.requestPlayer.equals((Object)this.targetPlayer)) {
            throw new ErrorSelfOperationException((CommandSender)this.requestPlayer);
        }
        if (Objects.isNull(this.targetPlayer) || !this.targetPlayer.isOnline()) {
            throw new ErrorTargetOfflineException((CommandSender)this.requestPlayer, this.targetPlayerName);
        }
        if (PlayerDataConfig.getPlayerData(this.targetPlayer).isDeny(this.requestPlayer.getUniqueId().toString())) {
            throw new ErrorBlockedByTargetException((CommandSender)this.requestPlayer);
        }
    }

    protected void setTimer(long delay, final TimerType timerType) {
        HandyRunnable timer;
        this.timer = timer = new HandyRunnable(){

            @Override
            public void run() {
                try {
                    switch (timerType) {
                        case TELEPORT: {
                            PlayerToPlayerRequest.this.teleport();
                            break;
                        }
                        case DENY: {
                            PlayerToPlayerRequest.this.timeOverDeny();
                        }
                    }
                }
                catch (Exception ignored) {
                    Request.REQUEST_QUEUE.remove(PlayerToPlayerRequest.this.targetPlayer);
                    this.cancel();
                }
            }
        };
        HandySchedulerUtil.runTaskLaterAsynchronously(timer, delay / 50L);
    }

    @Override
    public void tpaccept() {
        REQUEST_QUEUE.remove(this.targetPlayer);
        this.timer.cancel();
        this.delay = LoadingConfigUtil.getConfig().getTeleportDelay((CommandSender)this.requestPlayer);
    }

    protected void deny() {
        REQUEST_QUEUE.remove(this.targetPlayer);
        this.timer.cancel();
    }

    @Override
    public void tpdeny() {
        this.deny();
    }

    protected void timeOverDeny() {
        this.deny();
    }
}

