/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.abstracts;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import top.craft_hello.tpa.interfaces.RequestInterface;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.HandyRunnable;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.HandySchedulerUtil;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.PlayerSchedulerUtil;
import top.craft_hello.tpa.utils.LoadingConfigUtil;
import top.craft_hello.tpa.utils.SendMessageUtil;

public abstract class Request
implements RequestInterface {
    protected static Random random = new Random();
    protected HandyRunnable timer;
    protected HandyRunnable countdownMessageTimer;
    protected HandyRunnable checkMoveTimer;
    protected HandyRunnable useCommandTimer;
    protected long delay;
    protected Location location;
    protected static final Map<Player, Request> REQUEST_QUEUE = new HashMap<Player, Request>();
    protected static final Map<Player, String> COMMAND_DELAY_QUEUE = new HashMap<Player, String>();

    protected void setCountdownMessageTimer(final @NotNull Player player, final @NotNull String target) {
        HandyRunnable countdownMessageTimer;
        this.countdownMessageTimer = countdownMessageTimer = new HandyRunnable(){
            long sec;
            {
                this.sec = Request.this.delay;
            }

            @Override
            public void run() {
                try {
                    if (this.sec > 0L) {
                        SendMessageUtil.teleportCountdown(player, target, String.valueOf(this.sec));
                    }
                    if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
                        SendMessageUtil.titleCountdownMessage(player, target, String.valueOf(this.sec));
                        if (LoadingConfigUtil.getConfig().isEnableSound()) {
                            PlayerSchedulerUtil.playSound(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                        }
                    }
                    if (--this.sec < 0L) {
                        SendMessageUtil.titleCountdownOverMessage(player, target);
                        this.cancel();
                    }
                }
                catch (Exception ignored) {
                    this.cancel();
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(countdownMessageTimer, 0L, 20L);
    }

    protected void setCommandTimer(final Player player, final long commandDelay) {
        HandyRunnable useCommandTimer;
        if (commandDelay == 0L) {
            return;
        }
        this.useCommandTimer = useCommandTimer = new HandyRunnable(){
            long sec;
            {
                this.sec = commandDelay;
            }

            @Override
            public void run() {
                try {
                    COMMAND_DELAY_QUEUE.put(player, String.valueOf(--this.sec));
                    if (this.sec < 0L) {
                        COMMAND_DELAY_QUEUE.remove(player);
                        this.cancel();
                    }
                }
                catch (Exception ignored) {
                    COMMAND_DELAY_QUEUE.remove(player);
                    this.cancel();
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(useCommandTimer, 0L, 20L);
    }

    public static void teleport(Player player, Location location) {
        PlayerSchedulerUtil.syncTeleport((Entity)player, location);
    }

    public static Map<Player, Request> getRequestQueue() {
        return REQUEST_QUEUE;
    }

    public static void clearRequestQueue() {
        Set<Player> players = REQUEST_QUEUE.keySet();
        for (Player player : players) {
            REQUEST_QUEUE.remove(player);
        }
    }

    public static void clearCommandDelayQueue() {
        Set<Player> players = COMMAND_DELAY_QUEUE.keySet();
        for (Player player : players) {
            COMMAND_DELAY_QUEUE.remove(player);
        }
    }
}

