/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.enums;

import java.util.Objects;
import org.bukkit.command.CommandSender;

public enum PermissionType {
    DEFAULT,
    VIP,
    VIP_PLUS,
    MVP,
    MVP_PLUS,
    MVP_PLUS_PLUS,
    ADMIN,
    RELOAD,
    VERSION,
    WARP,
    SET_WARP,
    DEL_WARP,
    HOME,
    SPAWN,
    SET_SPAWN,
    DEL_SPAWN,
    TPA,
    TP_HERE,
    TP_ALL,
    TP_LOGOUT,
    RTP,
    DENYS,
    BACK;


    public static String getPermission(PermissionType permissionType) {
        String permission;
        switch (permissionType.ordinal()) {
            case 0: {
                permission = "tpa.default";
                break;
            }
            case 1: {
                permission = "tpa.vip";
                break;
            }
            case 2: {
                permission = "tpa.vip+";
                break;
            }
            case 3: {
                permission = "tpa.mvp";
                break;
            }
            case 4: {
                permission = "tpa.mvp+";
                break;
            }
            case 5: {
                permission = "tpa.mvp++";
                break;
            }
            case 7: {
                permission = "tpa.reload";
                break;
            }
            case 8: {
                permission = "tpa.version";
                break;
            }
            case 9: {
                permission = "tpa.warp";
                break;
            }
            case 10: {
                permission = "tpa.setwarp";
                break;
            }
            case 11: {
                permission = "tpa.delwarp";
                break;
            }
            case 12: {
                permission = "tpa.home";
                break;
            }
            case 13: {
                permission = "tpa.spawn";
                break;
            }
            case 14: {
                permission = "tpa.setspawn";
                break;
            }
            case 15: {
                permission = "tpa.delspawn";
                break;
            }
            case 16: {
                permission = "tpa.tpa";
                break;
            }
            case 17: {
                permission = "tpa.tphere";
                break;
            }
            case 18: {
                permission = "tpa.tpall";
                break;
            }
            case 19: {
                permission = "tpa.tplogout";
                break;
            }
            case 20: {
                permission = "tpa.rtp";
                break;
            }
            case 21: {
                permission = "tpa.denys";
                break;
            }
            case 22: {
                permission = "tpa.back";
                break;
            }
            default: {
                permission = "tpa.admin";
            }
        }
        return permission;
    }

    public static boolean hasPermission(CommandSender sender, PermissionType ... permissionTypes) {
        if (!Objects.isNull(sender)) {
            for (PermissionType permissionType : permissionTypes) {
                if (sender.hasPermission(PermissionType.getPermission(permissionType))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

