/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.objects;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import top.craft_hello.tpa.abstracts.Configuration;
import top.craft_hello.tpa.enums.CommandType;
import top.craft_hello.tpa.enums.PermissionType;
import top.craft_hello.tpa.utils.SendMessageUtil;
import top.craft_hello.tpa.utils.VersionUtil;

public class Config
extends Configuration {
    private static volatile Config instance;
    private String defaultLanguageStr;
    private Boolean isOldServer;
    private boolean debug;
    private boolean updateCheck;
    private boolean forceSpawn;
    private boolean enableTitleMessage;
    private boolean enableSound;
    private boolean nonTpaOrTphereDisableCheck;
    private int acceptDelay;
    private boolean enableTeleportDelay;
    private boolean enableCommandDelay;
    private final Map<PermissionType, Integer> TELEPORT_DELAYS = new HashMap<PermissionType, Integer>();
    private final Map<PermissionType, Integer> COMMAND_DELAYS = new HashMap<PermissionType, Integer>();
    private final Map<CommandType, Boolean> ENABLE_COMMANDS = new HashMap<CommandType, Boolean>();
    private final Map<PermissionType, Boolean> ENABLE_PERMISSIONS = new HashMap<PermissionType, Boolean>();
    private List<String> rtpDisableWorlds;
    private int rtpLimitX;
    private int rtpLimitZ;
    private final Map<PermissionType, Integer> HOME_AMOUNTS = new HashMap<PermissionType, Integer>();

    private Config() {
        this.configurationFile = new File(PLUGIN.getDataFolder(), "config.yml");
        this.loadConfiguration(false);
        this.loadConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config getInstance() {
        if (!Objects.isNull(instance)) return instance;
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            if (!Objects.isNull(instance)) return instance;
            instance = new Config();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void loadConfiguration() {
        if (updateConfiguration) {
            this.updateConfiguration();
        }
        this.defaultLanguageStr = this.configuration.getString("language");
        if (Objects.isNull(this.defaultLanguageStr)) {
            this.defaultLanguageStr = "zh_CN";
        }
        this.defaultLanguageStr = Config.formatLangStr(this.defaultLanguageStr);
        this.isOldServer = this.isOldServer();
        this.debug = this.configuration.getBoolean("debug");
        this.updateCheck = this.configuration.getBoolean("update_check");
        this.forceSpawn = this.configuration.getBoolean("force_spawn");
        this.enableTitleMessage = this.isOldServer == false && this.configuration.getBoolean("enable_title_message");
        this.enableSound = this.isOldServer == false && this.configuration.getBoolean("enable_sound");
        this.acceptDelay = this.configuration.getInt("delay.accept");
        if (this.acceptDelay < 3) {
            this.acceptDelay = 3;
        }
        this.enableTeleportDelay = this.configuration.getBoolean("delay.enable_teleport");
        this.enableCommandDelay = this.configuration.getBoolean("delay.enable_command");
        this.nonTpaOrTphereDisableCheck = this.configuration.getBoolean("delay.non_tpa_or_tphere_disable_check");
        this.TELEPORT_DELAYS.put(PermissionType.DEFAULT, this.configuration.getInt("delay.default.teleport"));
        this.COMMAND_DELAYS.put(PermissionType.DEFAULT, this.configuration.getInt("delay.default.command"));
        this.TELEPORT_DELAYS.put(PermissionType.VIP, this.configuration.getInt("delay.vip.teleport"));
        this.COMMAND_DELAYS.put(PermissionType.VIP, this.configuration.getInt("delay.vip.command"));
        this.TELEPORT_DELAYS.put(PermissionType.VIP_PLUS, this.configuration.getInt("delay.vip+.teleport"));
        this.COMMAND_DELAYS.put(PermissionType.VIP_PLUS, this.configuration.getInt("delay.vip+.command"));
        this.TELEPORT_DELAYS.put(PermissionType.MVP, this.configuration.getInt("delay.mvp.teleport"));
        this.COMMAND_DELAYS.put(PermissionType.MVP, this.configuration.getInt("delay.mvp.command"));
        this.TELEPORT_DELAYS.put(PermissionType.MVP_PLUS, this.configuration.getInt("delay.mvp+.teleport"));
        this.COMMAND_DELAYS.put(PermissionType.MVP_PLUS, this.configuration.getInt("delay.mvp+.command"));
        this.TELEPORT_DELAYS.put(PermissionType.MVP_PLUS_PLUS, this.configuration.getInt("delay.mvp++.teleport"));
        this.COMMAND_DELAYS.put(PermissionType.MVP_PLUS_PLUS, this.configuration.getInt("delay.mvp++.command"));
        this.TELEPORT_DELAYS.put(PermissionType.ADMIN, this.configuration.getInt("delay.admin.teleport"));
        this.COMMAND_DELAYS.put(PermissionType.ADMIN, this.configuration.getInt("delay.admin.command"));
        this.ENABLE_COMMANDS.put(CommandType.TPA, this.configuration.getBoolean("tpa.enable"));
        this.ENABLE_PERMISSIONS.put(PermissionType.TPA, this.configuration.getBoolean("tpa.permission"));
        this.ENABLE_COMMANDS.put(CommandType.TP_HERE, this.configuration.getBoolean("tphere.enable"));
        this.ENABLE_PERMISSIONS.put(PermissionType.TP_HERE, this.configuration.getBoolean("tphere.permission"));
        this.ENABLE_PERMISSIONS.put(PermissionType.DENYS, this.configuration.getBoolean("denys.permission"));
        this.ENABLE_COMMANDS.put(CommandType.RTP, this.configuration.getBoolean("rtp.enable"));
        this.ENABLE_PERMISSIONS.put(PermissionType.RTP, this.configuration.getBoolean("rtp.permission"));
        this.ENABLE_COMMANDS.put(CommandType.WARP, this.configuration.getBoolean("warp.enable"));
        this.ENABLE_PERMISSIONS.put(PermissionType.WARP, this.configuration.getBoolean("warp.permission"));
        this.ENABLE_COMMANDS.put(CommandType.HOME, this.configuration.getBoolean("home.enable"));
        this.ENABLE_PERMISSIONS.put(PermissionType.HOME, this.configuration.getBoolean("home.permission"));
        this.ENABLE_COMMANDS.put(CommandType.SPAWN, this.configuration.getBoolean("spawn.enable"));
        this.ENABLE_PERMISSIONS.put(PermissionType.SPAWN, this.configuration.getBoolean("spawn.permission"));
        this.ENABLE_COMMANDS.put(CommandType.BACK, this.configuration.getBoolean("back.enable"));
        this.ENABLE_PERMISSIONS.put(PermissionType.BACK, this.configuration.getBoolean("back.permission"));
        this.rtpDisableWorlds = this.configuration.getStringList("rtp.disable_worlds");
        this.rtpLimitX = this.configuration.getInt("rtp.limit.x");
        this.rtpLimitZ = this.configuration.getInt("rtp.limit.z");
        this.HOME_AMOUNTS.put(PermissionType.DEFAULT, this.configuration.getInt("home.amount.default"));
        this.HOME_AMOUNTS.put(PermissionType.VIP, this.configuration.getInt("home.amount.vip"));
        this.HOME_AMOUNTS.put(PermissionType.VIP_PLUS, this.configuration.getInt("home.amount.vip+"));
        this.HOME_AMOUNTS.put(PermissionType.MVP, this.configuration.getInt("home.amount.mvp"));
        this.HOME_AMOUNTS.put(PermissionType.MVP_PLUS, this.configuration.getInt("home.amount.mvp+"));
        this.HOME_AMOUNTS.put(PermissionType.MVP_PLUS_PLUS, this.configuration.getInt("home.amount.mvp++"));
        this.HOME_AMOUNTS.put(PermissionType.ADMIN, this.configuration.getInt("home.amount.admin"));
    }

    public boolean isOldServer() {
        if (!Objects.isNull(this.isOldServer)) {
            return this.isOldServer;
        }
        return VersionUtil.versionComparison(SERVER_VERSION, "1.12");
    }

    private void updateConfiguration() {
        this.defaultLanguageStr = this.configuration.getString("lang");
        if (Objects.isNull(this.defaultLanguageStr)) {
            this.defaultLanguageStr = "zh_CN";
        }
        this.defaultLanguageStr = Config.formatLangStr(this.defaultLanguageStr);
        SendMessageUtil.configVersionUpdate((CommandSender)Bukkit.getConsoleSender());
        this.isOldServer = this.isOldServer();
        this.updateCheck = this.configuration.getBoolean("update_check");
        this.forceSpawn = this.configuration.getBoolean("force_spawn");
        this.enableTitleMessage = this.isOldServer == false && this.configuration.getBoolean("enable_title_message");
        this.enableSound = this.isOldServer == false && this.configuration.getBoolean("enable_playsound");
        this.acceptDelay = this.configuration.getInt("accept_delay");
        if (this.acceptDelay < 3) {
            this.acceptDelay = 3;
        }
        this.TELEPORT_DELAYS.put(PermissionType.DEFAULT, this.configuration.getInt("teleport_delay"));
        this.ENABLE_COMMANDS.put(CommandType.TPA, this.configuration.getBoolean("enable_command.tpa"));
        this.ENABLE_PERMISSIONS.put(PermissionType.TPA, this.configuration.getBoolean("enable_permission.tpa"));
        this.ENABLE_COMMANDS.put(CommandType.TP_HERE, this.configuration.getBoolean("enable_command.tphere"));
        this.ENABLE_PERMISSIONS.put(PermissionType.TP_HERE, this.configuration.getBoolean("enable_permission.tphere"));
        this.ENABLE_PERMISSIONS.put(PermissionType.DENYS, this.configuration.getBoolean("enable_permission.denys"));
        this.ENABLE_COMMANDS.put(CommandType.WARP, this.configuration.getBoolean("enable_command.warp"));
        this.ENABLE_PERMISSIONS.put(PermissionType.WARP, this.configuration.getBoolean("enable_permission.warp"));
        this.ENABLE_COMMANDS.put(CommandType.HOME, this.configuration.getBoolean("enable_command.home"));
        this.ENABLE_PERMISSIONS.put(PermissionType.HOME, this.configuration.getBoolean("enable_permission.home"));
        this.ENABLE_COMMANDS.put(CommandType.SPAWN, this.configuration.getBoolean("enable_command.spawn"));
        this.ENABLE_PERMISSIONS.put(PermissionType.SPAWN, this.configuration.getBoolean("enable_permission.spawn"));
        this.ENABLE_COMMANDS.put(CommandType.BACK, this.configuration.getBoolean("enable_command.back"));
        this.ENABLE_PERMISSIONS.put(PermissionType.BACK, this.configuration.getBoolean("enable_permission.back"));
        this.HOME_AMOUNTS.put(PermissionType.DEFAULT, this.configuration.getInt("home_amount.default"));
        this.HOME_AMOUNTS.put(PermissionType.VIP, this.configuration.getInt("home_amount.vip"));
        this.HOME_AMOUNTS.put(PermissionType.VIP_PLUS, this.configuration.getInt("home_amount.svip"));
        this.HOME_AMOUNTS.put(PermissionType.ADMIN, this.configuration.getInt("home_amount.admin"));
        switch (configVersion) {
            case "3.2.3": 
            case "3.2.2": 
            case "3.2.1": 
            case "3.2.0": {
                this.configurationFile.renameTo(new File(PLUGIN.getDataFolder(), "backup/" + configVersion + "/" + this.configurationFile.getName()));
                this.configuration.set("version", (Object)VERSION);
                Config.offUpdateConfiguration();
                break;
            }
            case "3.1.3": 
            case "3.1.2": 
            case "3.1.1": 
            case "3.1.0": 
            case "3.0.0": {
                ConfigurationSection keySection;
                this.configurationFile.renameTo(new File(PLUGIN.getDataFolder(), "backup/" + configVersion + "/" + this.configurationFile.getName()));
                this.loadConfiguration(true);
                this.configuration.set("language", (Object)this.defaultLanguageStr);
                this.configuration.set("update_check", (Object)this.updateCheck);
                if (!configVersion.equals("3.0.0")) {
                    this.configuration.set("force_spawn", (Object)this.forceSpawn);
                    this.configuration.set("enable_title_message", (Object)this.enableTitleMessage);
                    this.configuration.set("enable_sound", (Object)this.enableSound);
                }
                if (Objects.isNull(keySection = this.configuration.getConfigurationSection("delay"))) {
                    keySection = this.configuration.createSection("delay");
                }
                keySection.set("accept", (Object)this.acceptDelay);
                ConfigurationSection keySection2 = keySection.getConfigurationSection("default");
                if (Objects.isNull(keySection2)) {
                    keySection2 = keySection.createSection("default");
                }
                keySection2.set("teleport", (Object)this.TELEPORT_DELAYS.get((Object)PermissionType.DEFAULT));
                keySection = this.configuration.getConfigurationSection("tpa");
                if (Objects.isNull(keySection)) {
                    keySection = this.configuration.createSection("tpa");
                }
                keySection.set("enable", (Object)this.ENABLE_COMMANDS.get((Object)CommandType.TPA));
                keySection.set("permission", (Object)this.ENABLE_PERMISSIONS.get((Object)PermissionType.TPA));
                keySection = this.configuration.getConfigurationSection("tphere");
                if (Objects.isNull(keySection)) {
                    keySection = this.configuration.createSection("tphere");
                }
                keySection.set("enable", (Object)this.ENABLE_COMMANDS.get((Object)CommandType.TP_HERE));
                keySection.set("permission", (Object)this.ENABLE_PERMISSIONS.get((Object)PermissionType.TP_HERE));
                keySection = this.configuration.getConfigurationSection("denys");
                if (Objects.isNull(keySection)) {
                    keySection = this.configuration.createSection("denys");
                }
                keySection.set("permission", (Object)this.ENABLE_PERMISSIONS.get((Object)PermissionType.DENYS));
                keySection = this.configuration.getConfigurationSection("warp");
                if (Objects.isNull(keySection)) {
                    keySection = this.configuration.createSection("warp");
                }
                keySection.set("enable", (Object)this.ENABLE_COMMANDS.get((Object)CommandType.WARP));
                keySection.set("permission", (Object)this.ENABLE_PERMISSIONS.get((Object)PermissionType.WARP));
                keySection = this.configuration.getConfigurationSection("home");
                if (Objects.isNull(keySection)) {
                    keySection = this.configuration.createSection("home");
                }
                keySection.set("enable", (Object)this.ENABLE_COMMANDS.get((Object)CommandType.HOME));
                keySection.set("permission", (Object)this.ENABLE_PERMISSIONS.get((Object)PermissionType.HOME));
                keySection = this.configuration.getConfigurationSection("spawn");
                if (Objects.isNull(keySection)) {
                    keySection = this.configuration.createSection("spawn");
                }
                keySection.set("enable", (Object)this.ENABLE_COMMANDS.get((Object)CommandType.SPAWN));
                keySection.set("permission", (Object)this.ENABLE_PERMISSIONS.get((Object)PermissionType.SPAWN));
                keySection = this.configuration.getConfigurationSection("back");
                if (Objects.isNull(keySection)) {
                    keySection = this.configuration.createSection("back");
                }
                keySection.set("enable", (Object)this.ENABLE_COMMANDS.get((Object)CommandType.BACK));
                keySection.set("permission", (Object)this.ENABLE_PERMISSIONS.get((Object)PermissionType.BACK));
                keySection = this.configuration.getConfigurationSection("home");
                if (Objects.isNull(keySection)) {
                    keySection = this.configuration.createSection("home");
                }
                if (Objects.isNull(keySection2 = keySection.getConfigurationSection("amount"))) {
                    keySection2 = keySection.createSection("amount");
                }
                keySection2.set("default", (Object)this.HOME_AMOUNTS.get((Object)PermissionType.DEFAULT));
                keySection2.set("vip", (Object)this.HOME_AMOUNTS.get((Object)PermissionType.VIP));
                keySection2.set("vip+", (Object)this.HOME_AMOUNTS.get((Object)PermissionType.VIP_PLUS));
                keySection2.set("admin", (Object)this.HOME_AMOUNTS.get((Object)PermissionType.ADMIN));
                break;
            }
            case "2.0.0": 
            case "1.3": 
            case "1.2": 
            case "1.1": {
                this.configurationFile.renameTo(new File(PLUGIN.getDataFolder(), "backup/" + configVersion + this.configurationFile.getName()));
                this.loadConfiguration(true);
                this.configuration.set("language", (Object)this.defaultLanguageStr);
                ConfigurationSection keySection = this.configuration.getConfigurationSection("delay");
                if (Objects.isNull(keySection)) {
                    keySection = this.configuration.createSection("delay");
                }
                keySection.set("accept", (Object)this.acceptDelay);
                ConfigurationSection keySection2 = keySection.getConfigurationSection("default");
                if (Objects.isNull(keySection2)) {
                    keySection2 = keySection.createSection("default");
                }
                keySection2.set("teleport", (Object)this.TELEPORT_DELAYS.get((Object)PermissionType.DEFAULT));
                break;
            }
            case "1.0": {
                this.configurationFile.renameTo(new File(PLUGIN.getDataFolder(), "backup/" + configVersion + this.configurationFile.getName()));
                this.loadConfiguration(true);
                this.configuration.set("language", (Object)this.defaultLanguageStr);
                break;
            }
            default: {
                this.configuration.set("version", (Object)VERSION);
                Config.offUpdateConfiguration();
            }
        }
        this.saveConfiguration(null);
    }

    @Override
    public void reloadConfiguration() {
        this.loadConfiguration(false);
        this.loadConfiguration();
    }

    public String getDefaultLanguageStr() {
        if (Objects.isNull(this.defaultLanguageStr) || !new File(PLUGIN.getDataFolder(), "language/" + this.defaultLanguageStr + ".yml").exists()) {
            this.defaultLanguageStr = "zh_CN";
        }
        return this.defaultLanguageStr;
    }

    public boolean isUpdateCheck() {
        return this.updateCheck;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isForceSpawn() {
        return this.forceSpawn;
    }

    public boolean isEnableCommand(CommandType ... commandTypes) {
        for (CommandType commandType : commandTypes) {
            if (this.ENABLE_COMMANDS.containsKey((Object)commandType) && !this.ENABLE_COMMANDS.get((Object)commandType).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isEnablePermission(PermissionType permissionType) {
        if (this.ENABLE_PERMISSIONS.containsKey((Object)permissionType)) {
            return this.ENABLE_PERMISSIONS.get((Object)permissionType);
        }
        return true;
    }

    public boolean isEnableTitleMessage() {
        return this.enableTitleMessage;
    }

    public boolean isEnableSound() {
        return this.isEnableTitleMessage() && this.enableSound;
    }

    public boolean hasPermission(CommandSender sender, PermissionType permissionType) {
        return !this.isEnablePermission(permissionType) || PermissionType.hasPermission(sender, permissionType) || PermissionType.hasPermission(sender, PermissionType.ADMIN);
    }

    public int getAcceptDelay() {
        return this.acceptDelay;
    }

    public int getTeleportDelay(CommandSender sender) {
        int teleportDelay = this.TELEPORT_DELAYS.get((Object)PermissionType.DEFAULT);
        if (this.hasPermission(sender, PermissionType.VIP)) {
            teleportDelay = this.TELEPORT_DELAYS.get((Object)PermissionType.VIP);
        }
        if (this.hasPermission(sender, PermissionType.VIP_PLUS)) {
            teleportDelay = this.TELEPORT_DELAYS.get((Object)PermissionType.VIP_PLUS);
        }
        if (this.hasPermission(sender, PermissionType.MVP)) {
            teleportDelay = this.TELEPORT_DELAYS.get((Object)PermissionType.MVP);
        }
        if (this.hasPermission(sender, PermissionType.MVP_PLUS)) {
            teleportDelay = this.TELEPORT_DELAYS.get((Object)PermissionType.MVP_PLUS);
        }
        if (this.hasPermission(sender, PermissionType.MVP_PLUS_PLUS)) {
            teleportDelay = this.TELEPORT_DELAYS.get((Object)PermissionType.MVP_PLUS_PLUS);
        }
        if (this.hasPermission(sender, PermissionType.ADMIN)) {
            teleportDelay = this.TELEPORT_DELAYS.get((Object)PermissionType.ADMIN);
        }
        return Math.max(teleportDelay, 0);
    }

    public int getCommandDelay(CommandSender sender) {
        int commandDelay = this.COMMAND_DELAYS.get((Object)PermissionType.DEFAULT);
        if (this.hasPermission(sender, PermissionType.VIP)) {
            commandDelay = this.COMMAND_DELAYS.get((Object)PermissionType.VIP);
        }
        if (this.hasPermission(sender, PermissionType.VIP_PLUS)) {
            commandDelay = this.COMMAND_DELAYS.get((Object)PermissionType.VIP_PLUS);
        }
        if (this.hasPermission(sender, PermissionType.MVP)) {
            commandDelay = this.COMMAND_DELAYS.get((Object)PermissionType.MVP);
        }
        if (this.hasPermission(sender, PermissionType.MVP_PLUS)) {
            commandDelay = this.COMMAND_DELAYS.get((Object)PermissionType.MVP_PLUS);
        }
        if (this.hasPermission(sender, PermissionType.MVP_PLUS_PLUS)) {
            commandDelay = this.COMMAND_DELAYS.get((Object)PermissionType.MVP_PLUS_PLUS);
        }
        if (this.hasPermission(sender, PermissionType.ADMIN)) {
            commandDelay = this.COMMAND_DELAYS.get((Object)PermissionType.ADMIN);
        }
        return Math.max(commandDelay, 0);
    }

    public boolean isEnableTeleportDelay(CommandSender sender) {
        return this.enableTeleportDelay && !sender.hasPermission("tpa.nodelay") && this.getTeleportDelay(sender) != 0;
    }

    public boolean isEnableCommandDelay(CommandSender sender) {
        return this.enableCommandDelay && !sender.hasPermission("tpa.nodelay") && this.getCommandDelay(sender) != 0;
    }

    public boolean isNonTpaOrTphereDisableCheck() {
        return this.nonTpaOrTphereDisableCheck;
    }

    public int getHomeAmountMax(PermissionType permissionType) {
        return this.HOME_AMOUNTS.get((Object)permissionType);
    }

    public boolean isRtpDisableWorld(World world) {
        for (String worldName : this.rtpDisableWorlds) {
            if (!worldName.equalsIgnoreCase(world.getName())) continue;
            return true;
        }
        return false;
    }

    public int getRtpLimitX() {
        return this.rtpLimitX;
    }

    public int getRtpLimitZ() {
        return this.rtpLimitZ;
    }
}

