/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.objects;

import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import top.craft_hello.tpa.abstracts.Configuration;
import top.craft_hello.tpa.enums.ClickEventType;
import top.craft_hello.tpa.enums.HoverEventType;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.PlayerSchedulerUtil;
import top.craft_hello.tpa.utils.VersionUtil;

public final class JsonMessage {
    private String jsonCommand;
    private String text;
    private String value;
    private final String[] colorCodes = new String[]{"&0", "&1", "&2", "&3", "&4", "&5", "&6", "&7", "&8", "&9", "&a", "&b", "&c", "&d", "&e", "&f"};
    private final String[] colors = new String[]{",\"color\":\"black\"", ",\"color\":\"dark_blue\"", ",\"color\":\"dark_green\"", ",\"color\":\"dark_aqua\"", ",\"color\":\"dark_red\"", ",\"color\":\"dark_purple\"", ",\"color\":\"gold\"", ",\"color\":\"gray\"", ",\"color\":\"dark_gray\"", ",\"color\":\"blue\"", ",\"color\":\"green\"", ",\"color\":\"aqua\"", ",\"color\":\"red\"", ",\"color\":\"light_purple\"", ",\"color\":\"yellow\"", ",\"color\":\"white\""};
    private final String[] formatCodes = new String[]{"&k", "&l", "&m", "&n", "&o"};
    private final String[] formats = new String[]{",\"obfuscated\":true", ",\"bold\":true", ",\"strikethrough\":true", ",\"underlined\":true", ",\"italic\":true"};

    public JsonMessage(CommandSender target, String text) {
        this.text = this.formatText(text);
        this.jsonCommand = "tellraw " + target.getName() + " [{\"text\":\"" + this.text;
    }

    public JsonMessage addText() {
        this.addText(" \"");
        return this;
    }

    public JsonMessage addText(String text) {
        this.text = this.formatText(text);
        this.jsonCommand = this.jsonCommand + "},{\"text\":\"" + this.text;
        return this;
    }

    public JsonMessage addInsertion(String value) {
        this.value = value;
        this.jsonCommand = this.jsonCommand + ",\"insertion\":\"" + this.value + "\"";
        return this;
    }

    public JsonMessage addClickEvent(@NotNull ClickEventType clickEventType, String value) {
        this.value = value;
        switch (clickEventType) {
            case OPEN_URL: {
                this.jsonCommand = this.jsonCommand + ",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + this.value + "\"}";
                break;
            }
            case OPEN_FILE: {
                this.jsonCommand = this.jsonCommand + ",\"clickEvent\":{\"action\":\"open_file\",\"value\":\"" + this.value + "\"}";
                break;
            }
            case RUN_COMMAND: {
                this.jsonCommand = this.jsonCommand + ",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + this.value + "\"}";
                break;
            }
            case SUGGEST_COMMAND: {
                this.jsonCommand = this.jsonCommand + ",\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"" + this.value + "\"}";
                break;
            }
            case COPY_TO_CLIPBOARD: {
                this.jsonCommand = this.jsonCommand + ",\"clickEvent\":{\"action\":\"copy_to_clipboard\",\"value\":\"" + this.value + "\"}";
                break;
            }
        }
        return this;
    }

    public JsonMessage addHoverEvent(@NotNull HoverEventType hoverEventType, String value) {
        this.value = value;
        switch (hoverEventType) {
            case SHOW_TEXT: {
                this.jsonCommand = this.jsonCommand + ",\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"" + this.value + "\"}";
                break;
            }
            case SHOW_ITEM: {
                this.jsonCommand = this.jsonCommand + ",\"hoverEvent\":{\"action\":\"show_item\",\"value\":\"" + this.value + "\"}";
                break;
            }
            case SHOW_ENTITY: {
                this.jsonCommand = this.jsonCommand + ",\"hoverEvent\":{\"action\":\"show_entity\",\"value\":\"" + this.value + "\"}";
                break;
            }
        }
        return this;
    }

    private String formatText(@NotNull String value) {
        int index = 0;
        for (String formatCode : this.formatCodes) {
            if (value.contains(formatCode)) {
                value = value.replace(formatCode, "") + "\"" + this.formats[index];
            }
            ++index;
        }
        index = 0;
        for (String colorCode : this.colorCodes) {
            if (value.contains(colorCode)) {
                value = value.replace(colorCode, "") + this.colors[index];
                break;
            }
            ++index;
        }
        return value;
    }

    public void sendMessage() {
        String newString = this.toString();
        if (!VersionUtil.versionComparison(Configuration.getServerVersion(), "1.21.5")) {
            newString = newString.replaceAll("Event", "_event").replaceAll("value\":\"/", "command\":\"/");
        }
        PlayerSchedulerUtil.syncDispatchCommand(newString);
    }

    public String toString() {
        return this.jsonCommand + "}]";
    }
}

