/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.objects;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import top.craft_hello.tpa.abstracts.Configuration;
import top.craft_hello.tpa.objects.PlayerDataConfig;
import top.craft_hello.tpa.utils.LoadingConfigUtil;

public class LanguageConfig
extends Configuration {
    private static final Map<String, LanguageConfig> LANGUAGES = new HashMap<String, LanguageConfig>();

    public LanguageConfig(String languageStr) {
        this(new File(PLUGIN.getDataFolder(), "language/" + languageStr + ".yml"));
    }

    public LanguageConfig(File configurationFile) {
        if (Objects.isNull(configurationFile)) {
            return;
        }
        this.configurationFile = configurationFile;
        String fileName = configurationFile.getName().replace(".yml", "");
        if (!fileName.matches("^[a-zA-Z]{2}_[a-zA-Z]{2}$")) {
            return;
        }
        this.languageStr = LanguageConfig.formatLangStr(fileName);
        if (LanguageConfig.containsLanguage(this.languageStr)) {
            return;
        }
        this.loadConfiguration(false);
        if (LANGUAGES.containsKey(this.languageStr)) {
            return;
        }
        this.loadConfiguration();
        LANGUAGES.put(this.languageStr, this);
    }

    private void loadConfiguration() {
        if (updateConfiguration) {
            this.updateConfiguration();
        }
    }

    private void updateConfiguration() {
        switch (configVersion) {
            case "3.2.2": 
            case "3.2.1": 
            case "3.2.0": {
                File backupFolder = new File(PLUGIN.getDataFolder(), "backup/" + configVersion + "/language");
                if (!backupFolder.exists()) {
                    backupFolder.mkdirs();
                }
                try {
                    Files.move(this.configurationFile.getParentFile().toPath(), backupFolder.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception exception) {}
                break;
            }
            case "3.1.3": 
            case "3.1.2": 
            case "3.1.1": 
            case "3.1.0": 
            case "3.0.0": 
            case "2.0.0": 
            case "1.3": 
            case "1.2": 
            case "1.1": 
            case "1.0": {
                File oldLanguageFolder;
                File backupFolder = new File(PLUGIN.getDataFolder(), "backup/" + configVersion + "/lang/");
                if (!backupFolder.exists()) {
                    backupFolder.mkdirs();
                }
                if (!(oldLanguageFolder = new File(PLUGIN.getDataFolder(), "lang/")).exists()) break;
                try {
                    Files.move(oldLanguageFolder.toPath(), backupFolder.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private String formatText(@NotNull String text) {
        return text.replaceAll("&", "\u00a7");
    }

    private String formatText(@NotNull String text, String ... vars) {
        if (vars.length == 1) {
            if (Objects.isNull(vars[vars.length - 1])) {
                return this.formatText(text);
            }
            return this.formatText(text).replaceAll("<target>", vars[vars.length - 1]).replaceAll("<command>", vars[vars.length - 1]).replaceAll("<message>", vars[vars.length - 1]).replaceAll("<max_home_amount>", vars[vars.length - 1]).replaceAll("<seconds>", vars[vars.length - 1]);
        }
        if (vars.length == 2) {
            if (Objects.isNull(vars[vars.length - 2])) {
                vars[vars.length - 2] = "null";
            }
            if (Objects.isNull(vars[vars.length - 1])) {
                vars[vars.length - 1] = "null";
            }
            return this.formatText(text).replaceAll("<target>", vars[vars.length - 2]).replaceAll("<seconds>", vars[vars.length - 1]);
        }
        return this.formatText(text);
    }

    @Override
    public void reloadConfiguration() {
        this.loadConfiguration(false);
        this.loadConfiguration();
    }

    public static void reloadAllLanguage() {
        for (String langStr : LanguageConfig.getLanguageTextList()) {
            LANGUAGES.remove(langStr);
        }
        LanguageConfig.loadAllLanguage();
    }

    @Override
    protected void loadConfiguration(boolean isReplace) {
        if (isReplace || !this.configurationFile.exists()) {
            try {
                PLUGIN.saveResource("language/" + this.configurationFile.getName(), isReplace);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.configurationFile.exists()) {
                String langStr1 = this.configurationFile.getName().substring(0, 2);
                for (String langStr : LANGUAGES.keySet()) {
                    if (!langStr.substring(0, 2).equals(langStr1)) continue;
                    LANGUAGES.put(LanguageConfig.formatLangStr(this.configurationFile.getName().replace(".yml", "")), LANGUAGES.get(langStr));
                    return;
                }
                this.configurationFile = new File(PLUGIN.getDataFolder(), "language/" + LoadingConfigUtil.getConfig().getDefaultLanguageStr() + ".yml");
                PLUGIN.saveResource("language/" + this.configurationFile.getName(), isReplace);
                if (!this.configurationFile.exists()) {
                    this.configurationFile = new File(PLUGIN.getDataFolder(), "language/zh_CN.yml");
                    PLUGIN.saveResource("language/" + this.configurationFile.getName(), isReplace);
                }
            }
        }
        try {
            InputStreamReader reader = new InputStreamReader(Files.newInputStream(this.configurationFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            this.configuration = YamlConfiguration.loadConfiguration((Reader)reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadAllLanguage() {
        LanguageConfig.loadAllDefaultLanguage();
        File langFolder = new File(PLUGIN.getDataFolder(), "/language");
        File[] files = langFolder.listFiles();
        if (!Objects.isNull(files)) {
            for (File file : files) {
                new LanguageConfig(file);
            }
        }
    }

    private static void loadAllDefaultLanguage() {
        File languageFile = new File(PLUGIN.getDataFolder(), "language/zh_CN.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/zh_CN.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/zh_HK.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/zh_HK.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/zh_TW.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/zh_TW.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/en_US.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/en_US.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/ru_RU.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/ru_RU.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/fr_FR.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/fr_FR.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/de_DE.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/de_DE.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/ja_JP.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/ja_JP.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/ko_KR.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/ko_KR.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/pt_PT.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/pt_PT.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/es_ES.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/es_ES.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/it_IT.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/it_IT.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/no_NO.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/no_NO.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/tr_TR.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/tr_TR.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/sl_SL.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/sl_SL.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/sv_SE.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/sv_SE.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/fi_FI.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/fi_FI.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/da_DK.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/da_DK.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/he_IL.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/he_IL.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/nl_NL.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/nl_NL.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/el_GR.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/el_GR.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/hu_HU.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/hu_HU.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/cs_CZ.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/cs_CZ.yml", false);
        }
        new LanguageConfig(languageFile);
        languageFile = new File(PLUGIN.getDataFolder(), "language/pl_PL.yml");
        if (!languageFile.exists()) {
            PLUGIN.saveResource("language/pl_PL.yml", false);
        }
        new LanguageConfig(languageFile);
    }

    public static LanguageConfig getLanguage() {
        return LanguageConfig.getLanguage(LoadingConfigUtil.getConfig().getDefaultLanguageStr());
    }

    public static LanguageConfig getLanguage(String languageStr) {
        if (!LanguageConfig.containsLanguage(languageStr = LanguageConfig.formatLangStr(languageStr))) {
            new LanguageConfig(new File(PLUGIN.getDataFolder(), "language/" + languageStr + ".yml"));
            if (!LanguageConfig.containsLanguage(languageStr)) {
                return LanguageConfig.getLanguage();
            }
        }
        return LANGUAGES.get(languageStr);
    }

    public static LanguageConfig getLanguage(CommandSender sender) {
        String languageStr = null;
        if (sender instanceof OfflinePlayer) {
            OfflinePlayer offlinePlayer = (OfflinePlayer)sender;
            PlayerDataConfig playerDataConfig = PlayerDataConfig.getPlayerData(offlinePlayer);
            languageStr = playerDataConfig.getLanguageStr();
        }
        return LanguageConfig.getLanguage(languageStr);
    }

    public static List<String> getLanguageTextList() {
        return new ArrayList<String>(LANGUAGES.keySet());
    }

    public static boolean containsLanguage(String languageStr) {
        return LANGUAGES.containsKey(languageStr);
    }

    public String getPrefix() {
        return this.getPrefix((CommandSender)Bukkit.getConsoleSender());
    }

    public String getPrefix(CommandSender sender) {
        return sender instanceof Player ? this.getMessage("prefix") : this.getMessage("console_prefix");
    }

    public String getMessage(String messageIndex) {
        if (Objects.isNull(messageIndex)) {
            return "null";
        }
        String message = this.configuration.getString(messageIndex);
        return Objects.isNull(message) ? "null" : message;
    }

    public String getFormatMessage(String messageIndex, String ... vars) {
        return this.formatText(this.getMessage(messageIndex), vars);
    }

    public String getPrefixMessage(String messageIndex) {
        return this.getPrefix() + this.getMessage(messageIndex);
    }

    public String getPrefixMessage(CommandSender sender, String messageIndex) {
        return this.getPrefix(sender) + this.getMessage(messageIndex);
    }

    public String getFormatPrefixMessage(String messageIndex, String ... vars) {
        return this.formatText(this.getPrefixMessage(messageIndex), vars);
    }

    public String getFormatPrefixMessage(CommandSender sender, String messageIndex, String ... vars) {
        return this.formatText(this.getPrefixMessage(sender, messageIndex), vars);
    }
}

