/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.objects;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import top.craft_hello.tpa.abstracts.Configuration;
import top.craft_hello.tpa.abstracts.ErrorException;
import top.craft_hello.tpa.enums.PermissionType;
import top.craft_hello.tpa.exceptions.ErrorDefaultHomeAlreadySetException;
import top.craft_hello.tpa.exceptions.ErrorHomeNotFoundException;
import top.craft_hello.tpa.exceptions.ErrorLastLocationMissingException;
import top.craft_hello.tpa.exceptions.ErrorLogoutLocationMissingException;
import top.craft_hello.tpa.exceptions.ErrorNoDefaultHomeException;
import top.craft_hello.tpa.exceptions.ErrorNoHomesSetException;
import top.craft_hello.tpa.exceptions.ErrorNotBlacklistedException;
import top.craft_hello.tpa.exceptions.ErrorNotBlockedException;
import top.craft_hello.tpa.exceptions.ErrorTargetOfflineException;
import top.craft_hello.tpa.exceptions.HomeMaxLimitErrorException;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.HandyRunnable;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.HandySchedulerUtil;
import top.craft_hello.tpa.utils.LoadingConfigUtil;
import top.craft_hello.tpa.utils.SendMessageUtil;

public class PlayerDataConfig
extends Configuration {
    private static final Map<UUID, PlayerDataConfig> PLAYER_DATAS = new HashMap<UUID, PlayerDataConfig>();
    private Player player;
    private String playerName;
    private String defaultHomeName;
    private boolean setlang;
    private final Map<String, Location> HOMES = new HashMap<String, Location>();
    private List<String> denyList = new ArrayList<String>();
    private UUID playerUUID;
    private Location lastLocation;
    private Location logoutLocation;

    public PlayerDataConfig(UUID playerUUID) {
        this(new File(PLUGIN.getDataFolder(), "playerdata/" + playerUUID.toString() + ".yml"));
    }

    public PlayerDataConfig(String playerName) {
        this(new File(PLUGIN.getDataFolder(), "playerdata/" + Bukkit.getOfflinePlayer((String)playerName).getUniqueId() + ".yml"), playerName);
    }

    public PlayerDataConfig(File configurationFile) {
        this(configurationFile, null);
    }

    public PlayerDataConfig(File configurationFile, String playerName) {
        this.playerName = playerName;
        if (Objects.isNull(configurationFile)) {
            return;
        }
        this.configurationFile = configurationFile;
        String fileName = configurationFile.getName().replace(".yml", "");
        if (!fileName.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")) {
            return;
        }
        this.playerUUID = UUID.fromString(fileName);
        if (PlayerDataConfig.containsPlayerData(this.playerUUID)) {
            return;
        }
        this.loadConfiguration(false);
        if (Objects.isNull(this.configuration)) {
            return;
        }
        if (updateConfiguration) {
            this.updateConfiguration();
            return;
        }
        this.loadConfiguration();
        PLAYER_DATAS.put(this.playerUUID, this);
    }

    @Override
    protected void loadConfiguration(boolean isReplace) {
        if (isReplace || !this.configurationFile.exists()) {
            ErrorException.tryCreateConfiguration((CommandSender)Bukkit.getConsoleSender(), this.configurationFile);
            this.configuration = YamlConfiguration.loadConfiguration((File)this.configurationFile);
            this.configuration.set("player_name", (Object)Bukkit.getOfflinePlayer((UUID)this.playerUUID).getName());
            this.configuration.set("language", (Object)LoadingConfigUtil.getConfig().getDefaultLanguageStr());
            this.configuration.set("setlang", (Object)false);
            this.saveConfiguration(null);
        }
        this.configuration = YamlConfiguration.loadConfiguration((File)this.configurationFile);
    }

    private void loadConfiguration() {
        HandyRunnable loadPlayerTimer = new HandyRunnable(){
            long sec = 200L;

            @Override
            public void run() {
                try {
                    PlayerDataConfig.this.player = Bukkit.getPlayer((UUID)PlayerDataConfig.this.playerUUID);
                    if (!Objects.isNull(PlayerDataConfig.this.player)) {
                        this.cancel();
                    }
                    if (--this.sec < 0L) {
                        this.cancel();
                    }
                }
                catch (Exception ignored) {
                    this.cancel();
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(loadPlayerTimer, 0L, 1L);
        this.playerName = this.configuration.getString("player_name");
        this.languageStr = this.configuration.getString("language");
        this.defaultHomeName = this.configuration.getString("default_home");
        this.setlang = this.configuration.getBoolean("setlang");
        Set homeSet = this.configuration.getKeys(true);
        for (String homeName : homeSet) {
            Location location;
            String homeName2;
            if (!homeName.contains("homes.") || (homeName2 = homeName.substring(homeName.indexOf(".") + 1)).contains(".") || Objects.isNull(location = this.loadLocation(homeName))) continue;
            this.HOMES.put(homeName2, location);
        }
        this.denyList = this.configuration.getStringList("deny_list");
        Location location = this.loadLocation("last_location");
        if (!Objects.isNull(location)) {
            this.lastLocation = location;
        }
        if (!Objects.isNull(location = this.loadLocation("logout_location"))) {
            this.logoutLocation = location;
        }
    }

    private void updateConfiguration() {
        switch (configVersion) {
            case "3.1.3": 
            case "3.1.2": 
            case "3.1.1": 
            case "3.1.0": {
                this.configurationFile.renameTo(new File(PLUGIN.getDataFolder(), "backup/" + configVersion + "/playerdata/" + this.configurationFile.getName()));
                this.configuration.set("language", (Object)this.configuration.getString("lang"));
                this.configuration.set("lang", null);
                this.configuration.set("home_amount", null);
                this.configuration.set("denys_amount", null);
                if (this.configuration.contains("denys")) {
                    Set denysSet = this.configuration.getKeys(true);
                    for (String deny : denysSet) {
                        String playerUUID;
                        if (!deny.contains("denys.") || (playerUUID = deny.substring(deny.indexOf(".") + 1)).contains(".")) continue;
                        this.denyList.add(playerUUID);
                    }
                    this.configuration.set("deny_list", this.denyList);
                }
                this.configuration.set("denys", null);
                break;
            }
            case "3.0.0": {
                YamlConfiguration oldLastLocation;
                this.configuration.set("lang", null);
                this.configuration.set("language", (Object)LoadingConfigUtil.getConfig().getDefaultLanguageStr());
                File homeFile = new File(PLUGIN.getDataFolder(), "home.yml");
                File oldHomeFile = new File(PLUGIN.getDataFolder(), "backup/" + configVersion + "/" + homeFile.getName());
                if (homeFile.exists()) {
                    homeFile.renameTo(oldHomeFile);
                    homeFile.delete();
                }
                if (oldHomeFile.exists()) {
                    YamlConfiguration oldHomes = YamlConfiguration.loadConfiguration((File)oldHomeFile);
                    Set homeSet = oldHomes.getKeys(true);
                    for (String string : homeSet) {
                        Location location;
                        String homeName2;
                        if (!string.contains(this.playerName + ".") || (homeName2 = string.substring(string.indexOf(".") + 1)).contains(".") || Objects.isNull(location = oldHomes.getLocation(this.playerName + "." + homeName2))) continue;
                        if (Objects.isNull(this.defaultHomeName)) {
                            this.configuration.set("default_home", (Object)homeName2);
                        }
                        this.HOMES.put(homeName2, location);
                        this.loadLocation(string);
                    }
                    if (this.HOMES.isEmpty()) {
                        return;
                    }
                    for (Map.Entry entry : this.HOMES.entrySet()) {
                        this.setLocation("homes." + (String)entry.getKey(), (Location)entry.getValue());
                    }
                }
                File lastLocationFile = new File(PLUGIN.getDataFolder(), "last_location.yml");
                File oldLastLocationFile = new File(PLUGIN.getDataFolder(), "backup/" + configVersion + "/" + lastLocationFile.getName());
                if (lastLocationFile.exists()) {
                    lastLocationFile.renameTo(oldLastLocationFile);
                    lastLocationFile.delete();
                }
                if (!oldLastLocationFile.exists() || !(oldLastLocation = YamlConfiguration.loadConfiguration((File)oldLastLocationFile)).contains(this.playerName)) break;
                this.lastLocation = oldLastLocation.getLocation(this.playerName);
                if (Objects.isNull(this.lastLocation)) break;
                this.setLocation("last_location", this.lastLocation);
                break;
            }
            default: {
                return;
            }
        }
        this.saveConfiguration(null);
    }

    @Override
    public void reloadConfiguration() {
        this.loadConfiguration(false);
        this.loadConfiguration();
    }

    public static void reloadAllPlayerData() {
        for (String playerUUID : PlayerDataConfig.getPlayerUUIDList()) {
            PLAYER_DATAS.get(UUID.fromString(playerUUID)).reloadConfiguration();
        }
    }

    public static void loadAllPlayerData() {
        File oldLastLocationFile;
        File oldHomeFile = new File(PLUGIN.getDataFolder(), "home.yml");
        if (oldHomeFile.exists()) {
            YamlConfiguration oldHome = YamlConfiguration.loadConfiguration((File)oldHomeFile);
            Set playerNames = oldHome.getKeys(false);
            for (String playerName : playerNames) {
                PlayerDataConfig.getPlayerData(playerName);
            }
        }
        if ((oldLastLocationFile = new File(PLUGIN.getDataFolder(), "last_location.yml")).exists()) {
            YamlConfiguration oldLastLocation = YamlConfiguration.loadConfiguration((File)oldLastLocationFile);
            Set playerNames = oldLastLocation.getKeys(false);
            for (String playerName : playerNames) {
                PlayerDataConfig.getPlayerData(playerName);
            }
        }
        Configuration.offUpdateConfiguration();
        File playerDataFolder = new File(PLUGIN.getDataFolder(), "/playerdata");
        File[] files = playerDataFolder.listFiles();
        if (!Objects.isNull(files)) {
            for (File file : files) {
                new PlayerDataConfig(file);
            }
        }
    }

    public static PlayerDataConfig getPlayerData(UUID playerUUID) {
        if (!PlayerDataConfig.containsPlayerData(playerUUID)) {
            new PlayerDataConfig(playerUUID);
        }
        return PLAYER_DATAS.get(playerUUID);
    }

    public static PlayerDataConfig getPlayerData(Player player) {
        UUID playerUUID = player.getUniqueId();
        return PlayerDataConfig.getPlayerData(playerUUID);
    }

    public static PlayerDataConfig getPlayerData(OfflinePlayer offlinePlayer) {
        UUID playerUUID = offlinePlayer.getUniqueId();
        return PlayerDataConfig.getPlayerData(playerUUID);
    }

    public static PlayerDataConfig getPlayerData(String playerName) {
        UUID playerUUID = Bukkit.getPlayerUniqueId((String)playerName);
        if (!PlayerDataConfig.containsPlayerData(playerUUID)) {
            new PlayerDataConfig(playerName);
        }
        return PLAYER_DATAS.get(playerUUID);
    }

    public static List<String> getPlayerUUIDList() {
        ArrayList<String> playerUUIDList = new ArrayList<String>();
        for (Map.Entry<UUID, PlayerDataConfig> langMap : PLAYER_DATAS.entrySet()) {
            playerUUIDList.add(langMap.getKey().toString());
        }
        return playerUUIDList;
    }

    public static boolean containsPlayerData(UUID playerUUID) {
        return PLAYER_DATAS.containsKey(playerUUID);
    }

    public static void removePlayerData(UUID playerUUID) {
        PLAYER_DATAS.remove(playerUUID);
    }

    public static void removePlayerData(Player player) {
        UUID playerUUID = player.getUniqueId();
        PlayerDataConfig.removePlayerData(playerUUID);
    }

    public static void removePlayerData(OfflinePlayer offlinePlayer) {
        UUID playerUUID = offlinePlayer.getUniqueId();
        PlayerDataConfig.removePlayerData(playerUUID);
    }

    public void updatePlayerName(String playerName) {
        if (!this.playerName.equals(playerName)) {
            return;
        }
        this.configuration.set("playerName", (Object)playerName);
        this.saveConfiguration(null);
        this.reloadConfiguration();
    }

    public String getLanguageStr() {
        return this.languageStr;
    }

    public boolean containsDefaultHome() {
        return !Objects.isNull(this.defaultHomeName);
    }

    public String getDefaultHomeName() {
        return this.defaultHomeName;
    }

    public boolean equalsDefaultHomeName(String homeName) {
        return !Objects.isNull(this.defaultHomeName) && this.defaultHomeName.equalsIgnoreCase(homeName);
    }

    public boolean containsHomeLocation(String homeName) {
        return this.HOMES.containsKey(homeName);
    }

    public PermissionType getPermissionType(Player player) {
        if (player.hasPermission("tpa.admin")) {
            return PermissionType.ADMIN;
        }
        if (player.hasPermission("tpa.mvp++")) {
            return PermissionType.MVP_PLUS_PLUS;
        }
        if (player.hasPermission("tpa.mvp+")) {
            return PermissionType.MVP_PLUS;
        }
        if (player.hasPermission("tpa.mvp")) {
            return PermissionType.MVP;
        }
        if (player.hasPermission("tpa.vip+")) {
            return PermissionType.VIP_PLUS;
        }
        if (player.hasPermission("tpa.vip")) {
            return PermissionType.VIP;
        }
        return PermissionType.DEFAULT;
    }

    public void checkHomeAmountIsMax() {
        if (Objects.isNull(this.player) || !this.player.isOnline()) {
            throw new ErrorTargetOfflineException(null, "null");
        }
        PermissionType permissionType = this.getPermissionType(this.player);
        int homeAmount = this.HOMES.size();
        int maxHomeAmount = LoadingConfigUtil.getConfig().getHomeAmountMax(permissionType);
        if (maxHomeAmount < 1) {
            return;
        }
        if (homeAmount >= maxHomeAmount) {
            throw new HomeMaxLimitErrorException((CommandSender)this.player, maxHomeAmount);
        }
    }

    public Location getHomeLocation() {
        if (Objects.isNull(this.defaultHomeName)) {
            throw new ErrorNoDefaultHomeException((CommandSender)this.player);
        }
        return this.getHomeLocation(this.defaultHomeName);
    }

    public Location getHomeLocation(String homeName) {
        if (!this.containsHomeLocation(homeName)) {
            throw new ErrorHomeNotFoundException((CommandSender)this.player, homeName);
        }
        return this.HOMES.get(homeName);
    }

    public boolean containsLastLocation() {
        return !Objects.isNull(this.lastLocation);
    }

    public Location getLastLocation() {
        if (!this.containsLastLocation()) {
            throw new ErrorLastLocationMissingException((CommandSender)this.player);
        }
        return this.lastLocation;
    }

    public boolean containsLogoutLocation() {
        return !Objects.isNull(this.logoutLocation);
    }

    public Location getLogoutLocation(Player executor) {
        if (!this.containsLogoutLocation()) {
            throw new ErrorLogoutLocationMissingException((CommandSender)executor);
        }
        return this.logoutLocation;
    }

    public boolean isDeny(String playerUUID) {
        return this.denyList.contains(playerUUID);
    }

    public void checkIsNoDeny(String playerUUID, Player executor) {
        if (!this.isDeny(playerUUID)) {
            throw new ErrorNotBlacklistedException((CommandSender)executor);
        }
    }

    public List<String> getDenyList(CommandSender sender) {
        if (this.denyList.isEmpty()) {
            throw new ErrorNotBlockedException(sender);
        }
        return this.denyList;
    }

    public void addDeny(String playerUUID) {
        if (this.isDeny(playerUUID)) {
            return;
        }
        this.denyList.add(playerUUID);
        this.configuration.set("deny_list", this.denyList);
        this.saveConfiguration(null);
    }

    public void delDeny(String playerUUID) {
        if (!this.isDeny(playerUUID)) {
            return;
        }
        this.denyList.remove(playerUUID);
        this.configuration.set("deny_list", this.denyList);
        if (this.denyList.isEmpty()) {
            this.configuration.set("deny_list", null);
        }
        this.saveConfiguration(null);
    }

    public boolean equalsLanguageStr(String languageStr) {
        if (Objects.isNull(languageStr) || Objects.isNull(this.languageStr)) {
            return false;
        }
        return this.languageStr.equalsIgnoreCase(languageStr);
    }

    public boolean isSetlang() {
        return this.setlang;
    }

    public void setSetlang(boolean setlang) {
        this.setlang = setlang;
        this.configuration.set("setlang", (Object)setlang);
        this.saveConfiguration(null);
    }

    public void setLanguage(String languageStr) {
        if (Objects.isNull(languageStr) || this.equalsLanguageStr(languageStr)) {
            return;
        }
        this.languageStr = PlayerDataConfig.formatLangStr(languageStr);
        this.configuration.set("language", (Object)this.languageStr);
        this.saveConfiguration(null);
        SendMessageUtil.setLangCommandSuccess(this.player, this.languageStr);
    }

    public void setDefaultHomeName(String homeName, boolean force) {
        if (!force) {
            if (Objects.isNull(homeName) || !this.containsHomeLocation(homeName)) {
                throw new ErrorHomeNotFoundException((CommandSender)this.player, homeName);
            }
            if (homeName.equalsIgnoreCase(this.defaultHomeName)) {
                throw new ErrorDefaultHomeAlreadySetException((CommandSender)this.player, homeName);
            }
        }
        this.defaultHomeName = homeName;
        this.configuration.set("default_home", (Object)this.defaultHomeName);
        SendMessageUtil.setDefaultHomeSuccess(this.player, homeName);
    }

    public void setHomeLocation(Location location) {
        String defaultHomeName = "default";
        if (this.containsDefaultHome()) {
            defaultHomeName = this.defaultHomeName;
        }
        if (!this.containsHomeLocation(defaultHomeName)) {
            this.checkHomeAmountIsMax();
            this.setDefaultHomeName(defaultHomeName, true);
        }
        this.HOMES.put(defaultHomeName, location);
        this.setLocation("homes." + defaultHomeName, location);
        this.saveConfiguration(null);
        SendMessageUtil.setHomeSuccess(this.player, defaultHomeName);
    }

    public void setHomeLocation(String homeName, Location location) {
        if (Objects.isNull(homeName) || Objects.isNull(location)) {
            return;
        }
        if (!this.containsHomeLocation(homeName)) {
            this.checkHomeAmountIsMax();
        }
        if (Objects.isNull(this.defaultHomeName)) {
            this.defaultHomeName = homeName;
            this.setDefaultHomeName(this.defaultHomeName, true);
        }
        this.HOMES.put(homeName, location);
        this.setLocation("homes." + homeName, location);
        this.saveConfiguration(null);
        SendMessageUtil.setHomeSuccess(this.player, homeName);
    }

    public void delHomeLocation(String homeName) {
        if (this.containsHomeLocation(homeName)) {
            this.HOMES.remove(homeName);
            this.defaultHomeName = null;
            this.configuration.set("homes." + homeName, null);
            if (this.HOMES.isEmpty()) {
                this.configuration.set("homes", null);
                this.configuration.set("default_home", null);
            } else {
                for (Map.Entry<String, Location> homeMap : this.HOMES.entrySet()) {
                    if (!Objects.isNull(this.defaultHomeName)) continue;
                    this.defaultHomeName = homeMap.getKey();
                    this.configuration.set("default_home", (Object)this.defaultHomeName);
                    break;
                }
            }
            this.saveConfiguration(null);
            SendMessageUtil.delHomeSuccess(this.player, homeName);
            return;
        }
        throw new ErrorHomeNotFoundException((CommandSender)this.player, homeName);
    }

    public void setLastLocation(Location location) {
        if (Objects.isNull(location)) {
            return;
        }
        this.lastLocation = location;
        this.setLocation("last_location", location);
        this.saveConfiguration(null);
    }

    public void setLogoutLocation(Location location) {
        if (Objects.isNull(location)) {
            return;
        }
        this.logoutLocation = location;
        this.setLocation("logout_location", location);
        this.saveConfiguration(null);
    }

    public List<String> getHomeNameList(CommandSender sender) {
        if (this.HOMES.isEmpty()) {
            throw new ErrorNoHomesSetException(sender);
        }
        ArrayList<String> homeNameList = new ArrayList<String>();
        for (Map.Entry<String, Location> homeMap : this.HOMES.entrySet()) {
            homeNameList.add(homeMap.getKey());
        }
        return homeNameList;
    }

    public List<String> getHomeNameList() {
        return this.getHomeNameList((CommandSender)this.player);
    }
}

