/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.objects;

import java.io.File;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import top.craft_hello.tpa.abstracts.Configuration;
import top.craft_hello.tpa.exceptions.ErrorSpawnNotSetException;

public class SpawnConfig
extends Configuration {
    private static volatile SpawnConfig instance;
    private Location location;

    private SpawnConfig() {
        this.configurationFile = new File(PLUGIN.getDataFolder(), "spawn.yml");
        this.loadConfiguration(false);
        this.loadConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpawnConfig getInstance() {
        if (!Objects.isNull(instance)) return instance;
        Class<SpawnConfig> clazz = SpawnConfig.class;
        synchronized (SpawnConfig.class) {
            if (!Objects.isNull(instance)) return instance;
            instance = new SpawnConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void loadConfiguration() {
        if (updateConfiguration) {
            this.updateConfiguration();
        }
        this.location = this.loadLocation("spawn");
    }

    private void updateConfiguration() {
        if (configVersion.equals("3.0.0")) {
            this.location = this.configuration.getLocation("spawn");
            if (Objects.isNull(this.location)) {
                return;
            }
            this.configurationFile.renameTo(new File(PLUGIN.getDataFolder(), "backup/" + configVersion + "/" + this.configurationFile.getName()));
            this.loadConfiguration(true);
            this.setLocation("spawn", this.location);
            this.saveConfiguration(null);
        }
    }

    @Override
    public void reloadConfiguration() {
        this.loadConfiguration(false);
        this.loadConfiguration();
    }

    public boolean containsSpawnLocation() {
        return !Objects.isNull(this.location);
    }

    public Location getSpawnLocation(CommandSender sender) {
        if (!this.containsSpawnLocation()) {
            throw new ErrorSpawnNotSetException(sender);
        }
        return this.location;
    }

    public void setSpawnLocation(Location location) {
        if (Objects.isNull(location)) {
            return;
        }
        this.location = location;
        this.setLocation("spawn", location);
        this.saveConfiguration(null);
    }

    public void delSpawnLocation() {
        if (this.containsSpawnLocation()) {
            this.location = null;
            this.configuration.set("spawn", null);
            this.saveConfiguration(null);
        }
    }
}

