/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.objects;

import java.util.Objects;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import top.craft_hello.tpa.abstracts.PlayerToPlayerRequest;
import top.craft_hello.tpa.enums.CommandType;
import top.craft_hello.tpa.enums.TimerType;
import top.craft_hello.tpa.exceptions.ErrorTargetOfflineException;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.PlayerSchedulerUtil;
import top.craft_hello.tpa.utils.LoadingConfigUtil;
import top.craft_hello.tpa.utils.SendMessageUtil;

public class TpaRequest
extends PlayerToPlayerRequest {
    public TpaRequest(CommandSender requestObject, String[] args) {
        super(requestObject, args, CommandType.TPA);
        this.setTimer(this.delay < 0L ? 30000L : this.delay * 1000L, TimerType.DENY);
        REQUEST_QUEUE.put(this.targetPlayer, this);
        SendMessageUtil.requestTeleportToTarget(this.requestPlayer, this.targetPlayer, String.valueOf(this.delay < 0L ? 30L : this.delay));
    }

    @Override
    protected void teleport() {
        super.teleport();
        this.checkError();
        if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
            SendMessageUtil.titleCountdownOverMessage(this.requestPlayer, this.targetPlayerName);
            if (LoadingConfigUtil.getConfig().isEnableSound()) {
                PlayerSchedulerUtil.playSound(this.requestPlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
        }
        SendMessageUtil.youTeleportedToMessage(this.requestPlayer, this.targetPlayerName);
        TpaRequest.teleport(this.requestPlayer, this.targetPlayer.getLocation());
        if (LoadingConfigUtil.getConfig().isEnableCommandDelay((CommandSender)this.requestPlayer)) {
            this.setCommandTimer(this.requestPlayer, LoadingConfigUtil.getConfig().getCommandDelay((CommandSender)this.requestPlayer));
        }
    }

    public void checkError() {
        if (Objects.isNull(this.requestPlayer) || !this.requestPlayer.isOnline()) {
            throw new ErrorTargetOfflineException((CommandSender)this.requestPlayer, "null");
        }
        if (Objects.isNull(this.targetPlayer) || !this.targetPlayer.isOnline()) {
            throw new ErrorTargetOfflineException((CommandSender)this.requestPlayer, this.targetPlayerName);
        }
    }

    @Override
    public void tpaccept() {
        super.tpaccept();
        this.checkError();
        SendMessageUtil.acceptMessage(this.requestPlayer, this.targetPlayer);
        if (!LoadingConfigUtil.getConfig().isEnableTeleportDelay((CommandSender)this.requestPlayer)) {
            this.teleport();
            return;
        }
        this.setCheckMoveTimer(this.requestPlayer.getLocation(), this.requestPlayer, this.targetPlayer);
        this.setCountdownMessageTimer(this.requestPlayer, this.targetPlayerName);
        this.setTimer(this.delay < 0L ? 3000L : this.delay * 1000L, TimerType.TELEPORT);
    }

    @Override
    public void tpdeny() {
        super.tpdeny();
        SendMessageUtil.denyMessage(this.requestPlayer, this.targetPlayer);
    }

    @Override
    protected void timeOverDeny() {
        super.timeOverDeny();
        SendMessageUtil.timeOverDeny(this.requestPlayer, this.targetPlayer);
    }
}

