/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.objects;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import top.craft_hello.tpa.abstracts.Configuration;
import top.craft_hello.tpa.exceptions.ErrorWarpNotFoundException;

public class WarpConfig
extends Configuration {
    private static volatile WarpConfig instance;
    private static final Map<String, Location> LOCATIONS;

    private WarpConfig() {
        this.configurationFile = new File(PLUGIN.getDataFolder(), "warp.yml");
        this.loadConfiguration(false);
        this.loadConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WarpConfig getInstance() {
        if (!Objects.isNull(instance)) return instance;
        Class<WarpConfig> clazz = WarpConfig.class;
        synchronized (WarpConfig.class) {
            if (!Objects.isNull(instance)) return instance;
            instance = new WarpConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void loadConfiguration() {
        if (updateConfiguration) {
            this.updateConfiguration();
        }
        for (String warpName : this.configuration.getKeys(false)) {
            Location location = this.loadLocation(warpName);
            if (Objects.isNull(location)) continue;
            LOCATIONS.put(warpName, location);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateConfiguration() {
        void var3_9;
        String string = configVersion;
        int n = -1;
        switch (string.hashCode()) {
            case 48517559: {
                if (!string.equals("3.0.0")) break;
                boolean bl = false;
                break;
            }
            case 47594038: {
                if (!string.equals("2.0.0")) break;
                boolean bl = true;
                break;
            }
            case 48566: {
                if (!string.equals("1.3")) break;
                int n2 = 2;
                break;
            }
            case 48565: {
                if (!string.equals("1.2")) break;
                int n3 = 3;
                break;
            }
            case 48564: {
                if (!string.equals("1.1")) break;
                int n4 = 4;
                break;
            }
            case 48563: {
                if (!string.equals("1.0")) break;
                int n5 = 5;
            }
        }
        switch (var3_9) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                Set warpNames = this.configuration.getKeys(false);
                if (warpNames.isEmpty()) {
                    return;
                }
                for (String warpName : warpNames) {
                    LOCATIONS.put(warpName, this.configuration.getLocation(warpName));
                }
                this.configurationFile.renameTo(new File(PLUGIN.getDataFolder(), "backup/" + configVersion + "/" + this.configurationFile.getName()));
                break;
            }
            case 4: 
            case 5: {
                File resLocFile = new File(PLUGIN.getDataFolder(), "res_loc.yml");
                if (resLocFile.exists()) {
                    return;
                }
                YamlConfiguration resLoc = YamlConfiguration.loadConfiguration((File)resLocFile);
                Set warpNames = resLoc.getKeys(false);
                if (warpNames.isEmpty()) {
                    resLocFile.renameTo(new File(PLUGIN.getDataFolder(), "backup/" + configVersion + "/" + resLocFile.getName()));
                    resLocFile.delete();
                    return;
                }
                for (String warpName : warpNames) {
                    LOCATIONS.put(warpName, this.configuration.getLocation(warpName));
                }
                resLocFile.renameTo(new File(PLUGIN.getDataFolder(), "backup/" + configVersion + "/" + resLocFile.getName()));
                resLocFile.delete();
                break;
            }
            default: {
                return;
            }
        }
        this.loadConfiguration(true);
        if (LOCATIONS.isEmpty()) {
            return;
        }
        for (Map.Entry entry : LOCATIONS.entrySet()) {
            this.setLocation((String)entry.getKey(), (Location)entry.getValue());
        }
        this.saveConfiguration(null);
    }

    @Override
    public void reloadConfiguration() {
        this.loadConfiguration(false);
        this.loadConfiguration();
    }

    public boolean containsWarpLocation(String warpName) {
        return LOCATIONS.containsKey(warpName);
    }

    public List<String> getWarpNameList() {
        ArrayList<String> locationNameList = new ArrayList<String>();
        for (Map.Entry<String, Location> locationMap : LOCATIONS.entrySet()) {
            locationNameList.add(locationMap.getKey());
        }
        return locationNameList;
    }

    public Location getWarpLocation(CommandSender sender, String warpName) {
        if (!this.containsWarpLocation(warpName)) {
            throw new ErrorWarpNotFoundException(sender, warpName);
        }
        return LOCATIONS.get(warpName);
    }

    public void setWarpLocation(String warpName, Location location) {
        if (Objects.isNull(location)) {
            return;
        }
        LOCATIONS.put(warpName, location);
        this.setLocation(warpName, location);
        this.saveConfiguration(null);
    }

    public void delWarpLocation(String warpName) {
        if (this.containsWarpLocation(warpName)) {
            LOCATIONS.remove(warpName);
            this.configuration.set(warpName, null);
            this.saveConfiguration(null);
        }
    }

    static {
        LOCATIONS = new HashMap<String, Location>();
    }
}

