/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.tabcompleters;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.craft_hello.tpa.objects.PlayerDataConfig;
import top.craft_hello.tpa.utils.LoadingConfigUtil;

public class DenysTabCompleter
implements TabCompleter {
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 0) {
            return list;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 1) {
                list.add("add");
                list.add("remove");
                list.add(" ");
                return list;
            }
            if (args.length == 2) {
                List<String> denyList;
                PlayerDataConfig playerDataConfig;
                String subCommand;
                block16: {
                    subCommand = args[args.length - 2];
                    playerDataConfig = PlayerDataConfig.getPlayerData(player);
                    try {
                        denyList = playerDataConfig.getDenyList(null);
                    }
                    catch (Exception exception) {
                        denyList = new ArrayList<String>();
                        if (!LoadingConfigUtil.getConfig().isDebug()) break block16;
                        exception.printStackTrace();
                    }
                }
                switch (subCommand) {
                    case "add": {
                        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                            if (playerDataConfig.isDeny(offlinePlayer.getUniqueId().toString())) continue;
                            list.add(offlinePlayer.getName());
                        }
                        list.remove(sender.getName());
                        break;
                    }
                    case "remove": {
                        for (String playerUUID : denyList) {
                            list.add(Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerUUID)).getName());
                        }
                        break;
                    }
                }
            }
        }
        return list;
    }
}

