/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.tabcompleters;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.craft_hello.tpa.objects.LanguageConfig;
import top.craft_hello.tpa.objects.WarpConfig;
import top.craft_hello.tpa.utils.LoadingConfigUtil;

public class TpAllTabCompleter
implements TabCompleter {
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        List<String> list = new ArrayList<String>();
        if (args.length == 0 || args.length == 1 && "spawn".equalsIgnoreCase(args[args.length - 1])) {
            return list;
        }
        if (args.length == 1) {
            list.add("player");
            list.add("spawn");
            list.add("warp");
            list.add(" ");
            return list;
        }
        if (args.length == 2) {
            String subCommand = args[args.length - 2].toLowerCase();
            LanguageConfig language = LanguageConfig.getLanguage(sender);
            switch (subCommand) {
                case "player": {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        list.add(player.getName());
                    }
                    if (list.isEmpty()) {
                        list.add(language.getMessage("not_online_players"));
                    }
                    return list;
                }
                case "warp": {
                    WarpConfig warp = LoadingConfigUtil.getWarpConfig();
                    list = warp.getWarpNameList();
                    if (list.isEmpty()) {
                        list.add(language.getMessage("not_warps"));
                    }
                    return list;
                }
            }
        }
        return list;
    }
}

