/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import top.craft_hello.tpa.abstracts.Request;
import top.craft_hello.tpa.enums.CommandType;
import top.craft_hello.tpa.enums.PermissionType;
import top.craft_hello.tpa.exceptions.ErrorAlreadyBlacklistedException;
import top.craft_hello.tpa.exceptions.ErrorCommandDisabledException;
import top.craft_hello.tpa.exceptions.ErrorConsoleRestrictedException;
import top.craft_hello.tpa.exceptions.ErrorNoOnlinePlayersException;
import top.craft_hello.tpa.exceptions.ErrorNoPendingRequestException;
import top.craft_hello.tpa.exceptions.ErrorPermissionDeniedException;
import top.craft_hello.tpa.exceptions.ErrorRuntimeException;
import top.craft_hello.tpa.exceptions.ErrorSelfOperationException;
import top.craft_hello.tpa.exceptions.ErrorSyntaxGenericException;
import top.craft_hello.tpa.exceptions.ErrorSyntaxHomeException;
import top.craft_hello.tpa.exceptions.ErrorSyntaxTpAllException;
import top.craft_hello.tpa.exceptions.ErrorSyntaxTpaException;
import top.craft_hello.tpa.exceptions.ErrorSyntaxWarpException;
import top.craft_hello.tpa.exceptions.ErrorTargetOfflineException;
import top.craft_hello.tpa.exceptions.ErrorWarpNotFoundException;
import top.craft_hello.tpa.objects.BackRequest;
import top.craft_hello.tpa.objects.Config;
import top.craft_hello.tpa.objects.HomeRequest;
import top.craft_hello.tpa.objects.LanguageConfig;
import top.craft_hello.tpa.objects.PlayerDataConfig;
import top.craft_hello.tpa.objects.RtpRequest;
import top.craft_hello.tpa.objects.SpawnRequest;
import top.craft_hello.tpa.objects.TpaRequest;
import top.craft_hello.tpa.objects.TphereRequest;
import top.craft_hello.tpa.objects.WarpConfig;
import top.craft_hello.tpa.objects.WarpRequest;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.PlayerSchedulerUtil;
import top.craft_hello.tpa.utils.LoadingConfigUtil;
import top.craft_hello.tpa.utils.SendMessageUtil;
import top.craft_hello.tpa.utils.VersionUtil;

public class ErrorCheckUtil {
    public static void executeCommand(CommandSender sender, String[] args, String command) {
        block118: {
            Map<Player, Request> REQUEST_QUEUE = Request.getRequestQueue();
            CommandType commandType = CommandType.getCommandType(command);
            Config config = LoadingConfigUtil.getConfig();
            try {
                switch (commandType) {
                    case TPA: {
                        new TpaRequest(sender, args);
                        break;
                    }
                    case TP_HERE: {
                        new TphereRequest(sender, args);
                        break;
                    }
                    case RTP: {
                        new RtpRequest(sender, args);
                        break;
                    }
                    case TP_ALL: {
                        if (!config.isEnableCommand(commandType)) {
                            throw new ErrorCommandDisabledException(sender);
                        }
                        if (!config.hasPermission(sender, PermissionType.TP_ALL)) {
                            throw new ErrorPermissionDeniedException(sender);
                        }
                        ArrayList onlinePlayers = new ArrayList(Bukkit.getOnlinePlayers());
                        if (args.length == 0) {
                            if (!(sender instanceof Player)) {
                                throw new ErrorConsoleRestrictedException(sender);
                            }
                            Player executorPlayer = (Player)sender;
                            String executorPlayerName = executorPlayer.getName();
                            onlinePlayers.remove(executorPlayer);
                            if (onlinePlayers.isEmpty()) {
                                throw new ErrorNoOnlinePlayersException((CommandSender)executorPlayer);
                            }
                            Location location = executorPlayer.getLocation();
                            for (Player onlinePlayer : onlinePlayers) {
                                Request.teleport(onlinePlayer, location);
                                if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
                                    SendMessageUtil.titleCountdownOverMessage(onlinePlayer, executorPlayerName);
                                    if (LoadingConfigUtil.getConfig().isEnableSound()) {
                                        PlayerSchedulerUtil.playSound(onlinePlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                                    }
                                }
                                SendMessageUtil.adminTpYouToMessage(onlinePlayer, executorPlayerName);
                            }
                            SendMessageUtil.tpAllCommandSuccess((CommandSender)executorPlayer, executorPlayerName);
                            return;
                        }
                        if (args.length == 1 && args[args.length - 1].equals("spawn")) {
                            Location location = LoadingConfigUtil.getSpawnConfig().getSpawnLocation(sender);
                            for (Player onlinePlayer : onlinePlayers) {
                                Request.teleport(onlinePlayer, location);
                                if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
                                    SendMessageUtil.titleCountdownOverMessage(onlinePlayer, "spawn");
                                    if (LoadingConfigUtil.getConfig().isEnableSound()) {
                                        PlayerSchedulerUtil.playSound(onlinePlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                                    }
                                }
                                SendMessageUtil.adminTpYouToMessage(onlinePlayer, LanguageConfig.getLanguage((CommandSender)onlinePlayer).getMessage("spawn"));
                            }
                            SendMessageUtil.tpAllCommandSuccess(sender, LanguageConfig.getLanguage(sender).getMessage("spawn"));
                            return;
                        }
                        if (args.length == 2 && !Objects.isNull(args[args.length - 2])) {
                            switch (args[args.length - 2].toLowerCase()) {
                                case "player": {
                                    String targetPlayerName = args[args.length - 1];
                                    Player targetPlayer = Bukkit.getPlayerExact((String)targetPlayerName);
                                    if (Objects.isNull(targetPlayer) || !targetPlayer.isOnline()) {
                                        throw new ErrorTargetOfflineException(sender, targetPlayerName);
                                    }
                                    Location location = targetPlayer.getLocation();
                                    onlinePlayers.remove(targetPlayer);
                                    for (Player onlinePlayer : onlinePlayers) {
                                        Request.teleport(onlinePlayer, location);
                                        if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
                                            SendMessageUtil.titleCountdownOverMessage(onlinePlayer, targetPlayerName);
                                            if (LoadingConfigUtil.getConfig().isEnableSound()) {
                                                PlayerSchedulerUtil.playSound(onlinePlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                                            }
                                        }
                                        SendMessageUtil.adminTpYouToMessage(onlinePlayer, targetPlayerName);
                                    }
                                    SendMessageUtil.tpAllCommandSuccess(sender, targetPlayerName);
                                    SendMessageUtil.adminTpAllPlayerToYouMessage(targetPlayer);
                                    return;
                                }
                                case "warp": {
                                    String targetName = args[args.length - 1];
                                    Location location = LoadingConfigUtil.getWarpConfig().getWarpLocation(sender, targetName);
                                    for (Player onlinePlayer : onlinePlayers) {
                                        Request.teleport(onlinePlayer, location);
                                        if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
                                            SendMessageUtil.titleCountdownOverMessage(onlinePlayer, targetName);
                                            if (LoadingConfigUtil.getConfig().isEnableSound()) {
                                                PlayerSchedulerUtil.playSound(onlinePlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                                            }
                                        }
                                        SendMessageUtil.adminTpYouToMessage(onlinePlayer, targetName);
                                    }
                                    SendMessageUtil.tpAllCommandSuccess(sender, targetName);
                                    return;
                                }
                            }
                        }
                        throw new ErrorSyntaxTpAllException(sender, command);
                    }
                    case TP_LOGOUT: {
                        if (!(sender instanceof Player)) {
                            throw new ErrorConsoleRestrictedException(sender);
                        }
                        Player executorPlayer = (Player)sender;
                        if (!config.isEnableCommand(commandType)) {
                            throw new ErrorCommandDisabledException((CommandSender)executorPlayer);
                        }
                        if (!config.hasPermission((CommandSender)executorPlayer, PermissionType.TP_LOGOUT)) {
                            throw new ErrorPermissionDeniedException((CommandSender)executorPlayer);
                        }
                        if (args.length != 1) {
                            throw new ErrorSyntaxTpaException((CommandSender)executorPlayer, command);
                        }
                        String targetPlayerName = args[args.length - 1];
                        Location location = PlayerDataConfig.getPlayerData(Bukkit.getOfflinePlayer((String)targetPlayerName)).getLogoutLocation(executorPlayer);
                        Request.teleport(executorPlayer, location);
                        if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
                            SendMessageUtil.titleCountdownOverMessage(executorPlayer, targetPlayerName);
                            if (LoadingConfigUtil.getConfig().isEnableSound()) {
                                PlayerSchedulerUtil.playSound(executorPlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                            }
                        }
                        SendMessageUtil.tpLogoutCommandSuccess(executorPlayer, targetPlayerName);
                        break;
                    }
                    case TP_ACCEPT: {
                        if (!(sender instanceof Player)) {
                            throw new ErrorConsoleRestrictedException(sender);
                        }
                        Player executorPlayer = (Player)sender;
                        if (!config.isEnableCommand(CommandType.TPA, CommandType.TP_HERE)) {
                            throw new ErrorCommandDisabledException((CommandSender)executorPlayer);
                        }
                        if (!REQUEST_QUEUE.containsKey(executorPlayer)) {
                            throw new ErrorNoPendingRequestException((CommandSender)executorPlayer);
                        }
                        Request request = REQUEST_QUEUE.get(executorPlayer);
                        request.tpaccept();
                        break;
                    }
                    case TP_DENY: {
                        if (!(sender instanceof Player)) {
                            throw new ErrorConsoleRestrictedException(sender);
                        }
                        Player executorPlayer = (Player)sender;
                        if (!config.isEnableCommand(CommandType.TPA, CommandType.TP_HERE)) {
                            throw new ErrorCommandDisabledException((CommandSender)executorPlayer);
                        }
                        if (!REQUEST_QUEUE.containsKey(executorPlayer)) {
                            throw new ErrorNoPendingRequestException((CommandSender)executorPlayer);
                        }
                        Request request = REQUEST_QUEUE.get(executorPlayer);
                        request.tpdeny();
                        break;
                    }
                    case DENYS: {
                        if (!(sender instanceof Player)) {
                            throw new ErrorConsoleRestrictedException(sender);
                        }
                        Player executorPlayer = (Player)sender;
                        if (!config.isEnableCommand(CommandType.TPA, CommandType.TP_HERE)) {
                            throw new ErrorCommandDisabledException((CommandSender)executorPlayer);
                        }
                        if (!config.hasPermission((CommandSender)executorPlayer, PermissionType.DENYS)) {
                            throw new ErrorPermissionDeniedException((CommandSender)executorPlayer);
                        }
                        PlayerDataConfig playerDataConfig = PlayerDataConfig.getPlayerData(executorPlayer);
                        if (args.length == 0) {
                            SendMessageUtil.denysMessage(executorPlayer, playerDataConfig.getDenyList((CommandSender)executorPlayer));
                            return;
                        }
                        if (args.length == 2) {
                            String targetPlayerName = args[args.length - 1];
                            OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetPlayerName);
                            String targetUUID = target.getUniqueId().toString();
                            switch (args[args.length - 2].toLowerCase()) {
                                case "add": {
                                    if (executorPlayer.getUniqueId().equals(target.getUniqueId())) {
                                        throw new ErrorSelfOperationException((CommandSender)executorPlayer);
                                    }
                                    if (playerDataConfig.isDeny(targetUUID)) {
                                        throw new ErrorAlreadyBlacklistedException((CommandSender)executorPlayer);
                                    }
                                    if (REQUEST_QUEUE.containsKey(executorPlayer)) {
                                        PlayerSchedulerUtil.performCommand(executorPlayer, "tpdeny");
                                    }
                                    playerDataConfig.addDeny(targetUUID);
                                    SendMessageUtil.addDenysSuccess(executorPlayer, targetPlayerName);
                                    return;
                                }
                                case "remove": {
                                    playerDataConfig.checkIsNoDeny(targetUUID, executorPlayer);
                                    playerDataConfig.delDeny(targetUUID);
                                    SendMessageUtil.removeDenySuccess(executorPlayer, targetPlayerName);
                                    return;
                                }
                            }
                        }
                        throw new ErrorSyntaxGenericException((CommandSender)executorPlayer, command);
                    }
                    case WARP: {
                        if (args.length == 0) {
                            List<String> warpNameList = LoadingConfigUtil.getWarpConfig().getWarpNameList();
                            SendMessageUtil.warpListMessage(sender, warpNameList);
                            return;
                        }
                        new WarpRequest(sender, args);
                        break;
                    }
                    case SET_WARP: {
                        if (!(sender instanceof Player)) {
                            throw new ErrorConsoleRestrictedException(sender);
                        }
                        Player executorPlayer = (Player)sender;
                        if (!config.isEnableCommand(CommandType.WARP)) {
                            throw new ErrorCommandDisabledException((CommandSender)executorPlayer);
                        }
                        if (!config.hasPermission((CommandSender)executorPlayer, PermissionType.SET_WARP)) {
                            throw new ErrorPermissionDeniedException((CommandSender)executorPlayer);
                        }
                        Location location = executorPlayer.getLocation();
                        if (args.length != 1) {
                            throw new ErrorSyntaxWarpException((CommandSender)executorPlayer, command);
                        }
                        String targetName = args[args.length - 1];
                        LoadingConfigUtil.getWarpConfig().setWarpLocation(targetName, location);
                        SendMessageUtil.setWarpSuccess(executorPlayer, targetName);
                        break;
                    }
                    case DEL_WARP: {
                        String targetName;
                        if (!config.isEnableCommand(CommandType.WARP)) {
                            throw new ErrorCommandDisabledException(sender);
                        }
                        if (!config.hasPermission(sender, PermissionType.DEL_WARP)) {
                            throw new ErrorPermissionDeniedException(sender);
                        }
                        if (args.length != 1) {
                            throw new ErrorSyntaxWarpException(sender, command);
                        }
                        WarpConfig warp = LoadingConfigUtil.getWarpConfig();
                        if (!warp.containsWarpLocation(targetName = args[args.length - 1])) {
                            throw new ErrorWarpNotFoundException(sender, targetName);
                        }
                        warp.delWarpLocation(targetName);
                        SendMessageUtil.delWarpSuccess(sender, targetName);
                        break;
                    }
                    case HOME: {
                        new HomeRequest(sender, args);
                        break;
                    }
                    case HOMES: {
                        if (!(sender instanceof Player)) {
                            throw new ErrorConsoleRestrictedException(sender);
                        }
                        Player executorPlayer = (Player)sender;
                        if (!config.isEnableCommand(CommandType.HOME)) {
                            throw new ErrorCommandDisabledException((CommandSender)executorPlayer);
                        }
                        if (!config.hasPermission((CommandSender)executorPlayer, PermissionType.HOME)) {
                            throw new ErrorPermissionDeniedException((CommandSender)executorPlayer);
                        }
                        PlayerDataConfig playerDataConfig = PlayerDataConfig.getPlayerData(executorPlayer);
                        List<String> homeNameList = playerDataConfig.getHomeNameList();
                        SendMessageUtil.homeListMessage(executorPlayer, homeNameList);
                        break;
                    }
                    case SET_HOME: {
                        if (!(sender instanceof Player)) {
                            throw new ErrorConsoleRestrictedException(sender);
                        }
                        Player executorPlayer = (Player)sender;
                        if (!config.isEnableCommand(CommandType.HOME)) {
                            throw new ErrorCommandDisabledException((CommandSender)executorPlayer);
                        }
                        if (!config.hasPermission((CommandSender)executorPlayer, PermissionType.HOME)) {
                            throw new ErrorPermissionDeniedException((CommandSender)executorPlayer);
                        }
                        if (args.length > 1) {
                            throw new ErrorSyntaxHomeException((CommandSender)executorPlayer, command);
                        }
                        Location location = executorPlayer.getLocation();
                        PlayerDataConfig playerDataConfig = PlayerDataConfig.getPlayerData(executorPlayer);
                        if (args.length == 0) {
                            playerDataConfig.setHomeLocation(location);
                            return;
                        }
                        String targetName = args[args.length - 1];
                        playerDataConfig.setHomeLocation(targetName, location);
                        break;
                    }
                    case SET_DEFAULT_HOME: {
                        if (!(sender instanceof Player)) {
                            throw new ErrorConsoleRestrictedException(sender);
                        }
                        Player executorPlayer = (Player)sender;
                        if (!config.isEnableCommand(CommandType.HOME)) {
                            throw new ErrorCommandDisabledException((CommandSender)executorPlayer);
                        }
                        if (!config.hasPermission((CommandSender)executorPlayer, PermissionType.HOME)) {
                            throw new ErrorPermissionDeniedException((CommandSender)executorPlayer);
                        }
                        if (args.length != 1) {
                            throw new ErrorSyntaxHomeException((CommandSender)executorPlayer, command);
                        }
                        String targetName = args[args.length - 1];
                        PlayerDataConfig playerDataConfig = PlayerDataConfig.getPlayerData(executorPlayer);
                        playerDataConfig.setDefaultHomeName(targetName, false);
                        break;
                    }
                    case DEL_HOME: {
                        if (!(sender instanceof Player)) {
                            throw new ErrorConsoleRestrictedException(sender);
                        }
                        Player executorPlayer = (Player)sender;
                        if (!config.isEnableCommand(CommandType.HOME)) {
                            throw new ErrorCommandDisabledException((CommandSender)executorPlayer);
                        }
                        if (!config.hasPermission((CommandSender)executorPlayer, PermissionType.HOME)) {
                            throw new ErrorPermissionDeniedException((CommandSender)executorPlayer);
                        }
                        if (args.length != 1) {
                            throw new ErrorSyntaxHomeException((CommandSender)executorPlayer, command);
                        }
                        String targetName = args[args.length - 1];
                        PlayerDataConfig playerDataConfig = PlayerDataConfig.getPlayerData(executorPlayer);
                        playerDataConfig.delHomeLocation(targetName);
                        break;
                    }
                    case SPAWN: {
                        new SpawnRequest(sender, args);
                        break;
                    }
                    case SET_SPAWN: {
                        if (!(sender instanceof Player)) {
                            throw new ErrorConsoleRestrictedException(sender);
                        }
                        Player executorPlayer = (Player)sender;
                        if (!config.isEnableCommand(CommandType.SPAWN)) {
                            throw new ErrorCommandDisabledException((CommandSender)executorPlayer);
                        }
                        if (!config.hasPermission((CommandSender)executorPlayer, PermissionType.SET_SPAWN)) {
                            throw new ErrorPermissionDeniedException((CommandSender)executorPlayer);
                        }
                        Location location = executorPlayer.getLocation();
                        LoadingConfigUtil.getSpawnConfig().setSpawnLocation(location);
                        World world = executorPlayer.getWorld();
                        world.setSpawnLocation((int)location.getX(), location.getBlockY(), location.getBlockZ());
                        Bukkit.setSpawnRadius((int)0);
                        SendMessageUtil.setSpawnSuccess(executorPlayer);
                        break;
                    }
                    case DEL_SPAWN: {
                        if (!config.isEnableCommand(CommandType.SPAWN)) {
                            throw new ErrorCommandDisabledException(sender);
                        }
                        if (!config.hasPermission(sender, PermissionType.DEL_SPAWN)) {
                            throw new ErrorPermissionDeniedException(sender);
                        }
                        LoadingConfigUtil.getSpawnConfig().delSpawnLocation();
                        SendMessageUtil.delSpawnSuccess(sender);
                        break;
                    }
                    case BACK: {
                        new BackRequest(sender, args);
                        break;
                    }
                    case SET_LANG: {
                        if (!(sender instanceof Player)) {
                            throw new ErrorConsoleRestrictedException(sender);
                        }
                        Player executorPlayer = (Player)sender;
                        String languageStr = args[args.length - 1];
                        PlayerDataConfig playerDataConfig = PlayerDataConfig.getPlayerData(executorPlayer);
                        if ("clear".equalsIgnoreCase(languageStr)) {
                            playerDataConfig.setSetlang(false);
                            playerDataConfig.setLanguage(LoadingConfigUtil.getConfig().isOldServer() ? LoadingConfigUtil.getConfig().getDefaultLanguageStr() : executorPlayer.getLocale());
                            return;
                        }
                        playerDataConfig.setLanguage(languageStr);
                        playerDataConfig.setSetlang(true);
                        break;
                    }
                    case VERSION: {
                        if (!config.isEnableCommand(commandType)) {
                            throw new ErrorCommandDisabledException(sender);
                        }
                        if (!config.hasPermission(sender, PermissionType.VERSION)) {
                            throw new ErrorPermissionDeniedException(sender);
                        }
                        VersionUtil.updateCheck(sender);
                        break;
                    }
                    case RELOAD: {
                        if (!config.hasPermission(sender, PermissionType.RELOAD)) {
                            throw new ErrorPermissionDeniedException(sender);
                        }
                        LoadingConfigUtil.reloadALLConfig(sender);
                        break;
                    }
                    default: {
                        throw new ErrorRuntimeException(sender, "\u5728 utils.ErrorCheckUtil 46 \u884c\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u8005\uff08https://github.com/WarSkyGod/TPA/issues\uff09");
                    }
                }
            }
            catch (Exception exception) {
                if (!config.isDebug()) break block118;
                exception.printStackTrace();
            }
        }
    }
}

