/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.utils;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import top.craft_hello.tpa.abstracts.Configuration;
import top.craft_hello.tpa.abstracts.Request;
import top.craft_hello.tpa.objects.Config;
import top.craft_hello.tpa.objects.LanguageConfig;
import top.craft_hello.tpa.objects.PlayerDataConfig;
import top.craft_hello.tpa.objects.SpawnConfig;
import top.craft_hello.tpa.objects.WarpConfig;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.HandySchedulerUtil;
import top.craft_hello.tpa.utils.SendMessageUtil;

public class LoadingConfigUtil {
    private static Plugin plugin;
    private static Config config;
    private static WarpConfig warpConfig;
    private static SpawnConfig spawnConfig;

    public static void init(Plugin plugin) {
        LoadingConfigUtil.plugin = plugin;
        Configuration.configVersionCheck();
        LanguageConfig.loadAllLanguage();
        config = Config.getInstance();
        warpConfig = WarpConfig.getInstance();
        spawnConfig = SpawnConfig.getInstance();
        PlayerDataConfig.loadAllPlayerData();
        if (config.isDebug()) {
            Bukkit.getServer().getLogger().warning("[TPA] " + LanguageConfig.getLanguage().getMessage("system.debug_warning"));
        }
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static Config getConfig() {
        return config;
    }

    public static WarpConfig getWarpConfig() {
        return warpConfig;
    }

    public static SpawnConfig getSpawnConfig() {
        return spawnConfig;
    }

    public static void reloadALLConfig(CommandSender sender) {
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            HandySchedulerUtil.cancelTask();
            Request.clearRequestQueue();
            Request.clearCommandDelayQueue();
            LanguageConfig.reloadAllLanguage();
            config.reloadConfiguration();
            warpConfig.reloadConfiguration();
            spawnConfig.reloadConfiguration();
            PlayerDataConfig.reloadAllPlayerData();
            SendMessageUtil.configReloaded(sender);
            if (config.isDebug()) {
                Bukkit.getServer().getLogger().warning("[TPA] " + LanguageConfig.getLanguage().getMessage("system.debug_warning"));
            }
        });
    }
}

