/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import top.craft_hello.tpa.enums.ClickEventType;
import top.craft_hello.tpa.enums.CommandType;
import top.craft_hello.tpa.enums.HoverEventType;
import top.craft_hello.tpa.enums.PermissionType;
import top.craft_hello.tpa.objects.Config;
import top.craft_hello.tpa.objects.JsonMessage;
import top.craft_hello.tpa.objects.LanguageConfig;
import top.craft_hello.tpa.objects.PlayerDataConfig;
import top.craft_hello.tpa.utils.LoadingConfigUtil;

public class SendMessageUtil {
    public static void sendMessage(CommandSender sender, String message) {
        if (!Objects.isNull(sender)) {
            sender.sendMessage(message);
        }
    }

    public static void configVersionUpdate(CommandSender sender) {
        SendMessageUtil.sendMessage(sender, LanguageConfig.getLanguage(sender).getFormatPrefixMessage(sender, "system.config_migrated", new String[0]));
    }

    public static void configVersionUpdateSuccess(CommandSender sender) {
        SendMessageUtil.sendMessage(sender, LanguageConfig.getLanguage(sender).getFormatPrefixMessage(sender, "system.config_migrated_success", new String[0]));
    }

    public static void checkUpdate(CommandSender sender) {
        SendMessageUtil.sendMessage(sender, LanguageConfig.getLanguage(sender).getFormatPrefixMessage(sender, "update.checking", new String[0]));
    }

    public static void pluginUpdateMessage(CommandSender sender, String latestVersion) {
        SendMessageUtil.sendMessage(sender, LanguageConfig.getLanguage(sender).getFormatPrefixMessage(sender, "update.available", latestVersion));
    }

    public static void pluginLatestVersion(CommandSender sender) {
        SendMessageUtil.sendMessage(sender, LanguageConfig.getLanguage(sender).getFormatPrefixMessage(sender, "update.latest", new String[0]));
    }

    public static void pluginLoaded(CommandSender sender, String pluginVersion) {
        SendMessageUtil.sendMessage(sender, LanguageConfig.getLanguage().getFormatPrefixMessage("system.plugin_loaded", pluginVersion));
    }

    public static void pluginUnLoaded(CommandSender sender) {
        SendMessageUtil.sendMessage(sender, LanguageConfig.getLanguage().getFormatPrefixMessage("system.plugin_unloaded", new String[0]));
    }

    public static void configReloaded(CommandSender sender) {
        SendMessageUtil.sendMessage((CommandSender)Bukkit.getConsoleSender(), LanguageConfig.getLanguage().getFormatPrefixMessage("system.config_reloaded", new String[0]));
        if (sender instanceof Player) {
            SendMessageUtil.sendMessage(sender, LanguageConfig.getLanguage(sender).getFormatPrefixMessage(sender, "system.config_reloaded", new String[0]));
        }
    }

    public static void requestTeleportToTarget(Player executor, Player target, String delay) {
        String executorName = Objects.isNull(executor) || !executor.isOnline() ? "null" : executor.getName();
        String targetName = Objects.isNull(target) || !target.isOnline() ? "null" : target.getName();
        SendMessageUtil.sendMessage((CommandSender)target, LanguageConfig.getLanguage((CommandSender)target).getFormatPrefixMessage((CommandSender)target, "request.to_here", executorName, delay));
        SendMessageUtil.acceptOrDeny(target, executorName);
        SendMessageUtil.successSentRequest(executor, targetName, delay);
    }

    public static void requestTargetTeleportToHere(Player executor, Player target, String delay) {
        String executorName = Objects.isNull(executor) || !executor.isOnline() ? "null" : executor.getName();
        String targetName = Objects.isNull(target) || !target.isOnline() ? "null" : target.getName();
        SendMessageUtil.sendMessage((CommandSender)target, LanguageConfig.getLanguage((CommandSender)target).getFormatPrefixMessage((CommandSender)target, "request.to_target", executorName, delay));
        SendMessageUtil.acceptOrDeny(target, executorName);
        SendMessageUtil.successSentRequest(executor, targetName, delay);
    }

    public static void listMessage(Player executor, List<String> targetNames, String command, boolean teleportButton, boolean settingButton, boolean settingDefaultHomeButton, boolean deleteButton, boolean removeDenysButton) {
        String teleportCommand = "/" + command + " ";
        String settingCommand = "/set" + command + " ";
        String settingDefaultHomeCommand = "/setdefault" + command + " ";
        String deleteCommand = "/del" + command + " ";
        String removeDenysCommand = "/" + command + " remove ";
        LanguageConfig language = LanguageConfig.getLanguage((CommandSender)executor);
        for (String targetName : targetNames) {
            JsonMessage jsonMessage = new JsonMessage((CommandSender)executor, language.getPrefix((CommandSender)executor));
            jsonMessage.addText("&6&l" + targetName);
            jsonMessage.sendMessage();
            jsonMessage = new JsonMessage((CommandSender)executor, language.getPrefix((CommandSender)executor));
            if (teleportButton) {
                jsonMessage.addText(language.getMessage("teleport_button")).addInsertion(teleportCommand + targetName).addClickEvent(ClickEventType.RUN_COMMAND, teleportCommand + targetName).addHoverEvent(HoverEventType.SHOW_TEXT, language.getFormatMessage("teleport_click_hint", new String[0]));
            }
            if (settingButton) {
                jsonMessage.addText(language.getMessage("location_set_button")).addInsertion(settingCommand + targetName).addClickEvent(ClickEventType.RUN_COMMAND, settingCommand + targetName).addHoverEvent(HoverEventType.SHOW_TEXT, language.getFormatMessage("set_location_hint", new String[0]));
            }
            if (settingDefaultHomeButton && command.equals("home") && !PlayerDataConfig.getPlayerData(executor).equalsDefaultHomeName(targetName)) {
                jsonMessage.addText(language.getMessage("default_home_set_button")).addInsertion(settingDefaultHomeCommand + targetName).addClickEvent(ClickEventType.RUN_COMMAND, settingDefaultHomeCommand + targetName).addHoverEvent(HoverEventType.SHOW_TEXT, language.getFormatMessage("set_default_home_hint", new String[0]));
            }
            if (deleteButton) {
                jsonMessage.addText(language.getMessage("delete_button")).addInsertion(deleteCommand + targetName).addClickEvent(ClickEventType.RUN_COMMAND, deleteCommand + targetName).addHoverEvent(HoverEventType.SHOW_TEXT, language.getFormatMessage("delete_click_hint", new String[0]));
            }
            if (removeDenysButton) {
                jsonMessage.addText(language.getMessage("blacklist.remove_button")).addInsertion(removeDenysCommand + targetName).addClickEvent(ClickEventType.RUN_COMMAND, removeDenysCommand + targetName).addHoverEvent(HoverEventType.SHOW_TEXT, language.getFormatMessage("blacklist.remove_hint", new String[0]));
            }
            jsonMessage.sendMessage();
        }
    }

    public static void denysMessage(Player executor, List<String> denyList) {
        ArrayList<String> denyNameList = new ArrayList<String>();
        for (String playerUUID : denyList) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerUUID));
            denyNameList.add(offlinePlayer.getName());
        }
        Config config = LoadingConfigUtil.getConfig();
        boolean removeDenysButton = config.isEnableCommand(CommandType.TPA, CommandType.TP_HERE) && config.hasPermission((CommandSender)executor, PermissionType.DENYS);
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "blacklist.list_header", new String[0]));
        SendMessageUtil.listMessage(executor, denyNameList, "denys", false, false, false, false, removeDenysButton);
    }

    public static void warpListMessage(CommandSender sender, List<String> warpList) {
        if (warpList.isEmpty()) {
            SendMessageUtil.sendMessage(sender, LanguageConfig.getLanguage(sender).getFormatPrefixMessage(sender, "error.no_warps_set", new String[0]));
            return;
        }
        SendMessageUtil.sendMessage(sender, LanguageConfig.getLanguage(sender).getFormatPrefixMessage(sender, "warp.list_header", new String[0]));
        if (!(sender instanceof Player)) {
            StringBuilder warps = new StringBuilder();
            int count = 0;
            for (String warp : warpList) {
                if (++count > 1) {
                    warps.append("\u00a7e\u00a7l, ");
                }
                warps.append("\u00a7a\u00a7l").append(warp);
            }
            SendMessageUtil.sendMessage(sender, LanguageConfig.getLanguage().getPrefix() + warps);
            return;
        }
        Config config = LoadingConfigUtil.getConfig();
        Player executor = (Player)sender;
        boolean settingButton = config.hasPermission((CommandSender)executor, PermissionType.SET_WARP);
        boolean deleteButton = config.hasPermission((CommandSender)executor, PermissionType.DEL_WARP);
        SendMessageUtil.listMessage(executor, warpList, "warp", true, settingButton, false, deleteButton, false);
    }

    public static void homeListMessage(Player executor, List<String> homeNameList) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "home.list_header", new String[0]));
        SendMessageUtil.listMessage(executor, homeNameList, "home", true, true, true, true, false);
    }

    public static void acceptOrDeny(Player target, String executorName) {
        Config config = LoadingConfigUtil.getConfig();
        LanguageConfig language = LanguageConfig.getLanguage((CommandSender)target);
        JsonMessage jsonMessage = new JsonMessage((CommandSender)target, language.getPrefix((CommandSender)target)).addText(language.getMessage("accept_button")).addInsertion("/tpaccept").addClickEvent(ClickEventType.RUN_COMMAND, "/tpaccept").addHoverEvent(HoverEventType.SHOW_TEXT, language.getFormatMessage("accept_click_hint", new String[0])).addText().addText().addText(language.getMessage("deny_button")).addInsertion("/tpdeny").addClickEvent(ClickEventType.RUN_COMMAND, "/tpdeny").addHoverEvent(HoverEventType.SHOW_TEXT, language.getFormatMessage("deny_click_hint", new String[0]));
        if ((config.isEnableCommand(CommandType.TPA) || config.isEnableCommand(CommandType.TP_HERE)) && config.hasPermission((CommandSender)target, PermissionType.DENYS)) {
            jsonMessage.addText().addText().addText(language.getMessage("blacklist.add_button")).addInsertion("/denys add " + executorName).addClickEvent(ClickEventType.RUN_COMMAND, "/denys add " + executorName).addHoverEvent(HoverEventType.SHOW_TEXT, language.getFormatMessage("blacklist.add_hint", new String[0]));
        }
        jsonMessage.sendMessage();
    }

    public static void successSentRequest(Player executor, String target, String delay) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "request.sent_success", target));
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "request.timeout_notice", delay));
    }

    public static void acceptMessage(Player executor, Player target) {
        String executorName = Objects.isNull(executor) ? "null" : executor.getName();
        String targetName = Objects.isNull(target) ? "null" : target.getName();
        SendMessageUtil.sendMessage((CommandSender)target, LanguageConfig.getLanguage((CommandSender)target).getFormatPrefixMessage((CommandSender)target, "teleport.accept.self", executorName));
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "teleport.accept.target", targetName));
    }

    public static void denyMessage(Player executor, Player target) {
        String executorName = Objects.isNull(executor) ? "null" : executor.getName();
        String targetName = Objects.isNull(target) ? "null" : target.getName();
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "teleport.deny.self", targetName));
        SendMessageUtil.sendMessage((CommandSender)target, LanguageConfig.getLanguage((CommandSender)target).getFormatPrefixMessage((CommandSender)target, "teleport.deny.target", executorName));
    }

    public static void titleCountdownMessage(Player executor, String ... vars) {
        String target = vars[vars.length - 2];
        LanguageConfig language = LanguageConfig.getLanguage((CommandSender)executor);
        if ("last_location".equals(target) || "rtp_name".equals(target) || "spawn_name".equals(target)) {
            vars[vars.length - 2] = language.getMessage(target);
        }
        String title = language.getFormatMessage("teleport.countdown", vars);
        String subTitle = language.getFormatMessage("teleport.cancel_on_move", new String[0]);
        executor.sendTitle(title, subTitle);
    }

    public static void titleCountdownOverMessage(Player executor, String target) {
        LanguageConfig language = LanguageConfig.getLanguage((CommandSender)executor);
        if ("last_location".equals(target) || "rtp_name".equals(target) || "spawn_name".equals(target)) {
            target = language.getMessage(target);
        }
        Bukkit.getConsoleSender().sendMessage(target);
        String title = language.getFormatMessage("teleport.generic_success", target);
        try {
            executor.sendTitle(title, "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void teleportCountdown(Player executor, String target, String delay) {
        LanguageConfig language = LanguageConfig.getLanguage((CommandSender)executor);
        if ("last_location".equals(target) || "rtp_name".equals(target) || "spawn_name".equals(target)) {
            target = language.getMessage(target);
        }
        SendMessageUtil.sendMessage((CommandSender)executor, language.getFormatPrefixMessage((CommandSender)executor, "teleport.countdown", target, delay));
        SendMessageUtil.sendMessage((CommandSender)executor, language.getFormatPrefixMessage((CommandSender)executor, "teleport.cancel_on_move", new String[0]));
    }

    public static void titleGenerateRandomLocationMessage(Player executor) {
        String title = LanguageConfig.getLanguage((CommandSender)executor).getFormatMessage("rtp.generating", new String[0]);
        executor.sendTitle(title, "");
    }

    public static void generateRandomLocationMessage(Player executor) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "rtp.generating", new String[0]));
    }

    public static void youTeleportedToMessage(Player executor, String target) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "teleport.generic_success", target));
    }

    public static void move(Player executor, Player target) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "teleport.canceled.self", new String[0]));
        if (executor != target) {
            SendMessageUtil.sendMessage((CommandSender)target, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "teleport.canceled.target", new String[0]));
        }
    }

    public static void timeOverDeny(Player executor, Player target) {
        String executorName = Objects.isNull(executor) ? "null" : executor.getName();
        String targetName = Objects.isNull(target) ? "null" : target.getName();
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "request.expired_to", targetName));
        SendMessageUtil.sendMessage((CommandSender)target, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "request.expired_from", executorName));
    }

    public static void adminTpYouToMessage(Player executor, String targetName) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "teleport.tpall.to_target", targetName));
    }

    public static void adminTpAllPlayerToYouMessage(Player executor) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "teleport.tpall.to_self", new String[0]));
    }

    public static void tpAllCommandSuccess(CommandSender sender, String targetName) {
        SendMessageUtil.sendMessage(sender, LanguageConfig.getLanguage(sender).getFormatPrefixMessage(sender, "teleport.tpall.success", targetName));
    }

    public static void tpToWarpMessage(Player executor, String warpName) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "warp.teleport_success", warpName));
    }

    public static void setWarpSuccess(Player executor, String warpName) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "warp.set_success", warpName));
    }

    public static void delWarpSuccess(CommandSender sender, String warpName) {
        SendMessageUtil.sendMessage(sender, LanguageConfig.getLanguage(sender).getFormatPrefixMessage(sender, "warp.delete_success", warpName));
    }

    public static void addDenysSuccess(Player executor, String targetName) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "blacklist.add_success", targetName));
    }

    public static void removeDenySuccess(Player executor, String targetName) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "blacklist.remove_success", targetName));
    }

    public static void setHomeSuccess(Player executor, String homeName) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "home.set_success", homeName));
    }

    public static void setDefaultHomeSuccess(Player executor, String homeName) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "home.default_set_success", homeName));
    }

    public static void delHomeSuccess(Player executor, String homeName) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "home.delete_success", homeName));
    }

    public static void tpToHomeMessage(Player executor, String homeName) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "home.teleport_success", homeName));
    }

    public static void backSpawnSuccessMessage(Player executor) {
        LanguageConfig language = LanguageConfig.getLanguage((CommandSender)executor);
        SendMessageUtil.sendMessage((CommandSender)executor, language.getFormatPrefixMessage((CommandSender)executor, "spawn.teleport_success", language.getMessage("spawn_name")));
    }

    public static void setSpawnSuccess(Player executor) {
        LanguageConfig language = LanguageConfig.getLanguage((CommandSender)executor);
        SendMessageUtil.sendMessage((CommandSender)executor, language.getFormatPrefixMessage((CommandSender)executor, "spawn.set_success", new String[0]));
    }

    public static void delSpawnSuccess(CommandSender sender) {
        LanguageConfig language = LanguageConfig.getLanguage(sender);
        SendMessageUtil.sendMessage(sender, language.getFormatPrefixMessage(sender, "spawn.delete_success", new String[0]));
    }

    public static void rtpSuccessMessage(Player executor) {
        LanguageConfig language = LanguageConfig.getLanguage((CommandSender)executor);
        SendMessageUtil.sendMessage((CommandSender)executor, language.getFormatPrefixMessage((CommandSender)executor, "rtp.success", new String[0]));
    }

    public static void backLastLocationSuccessMessage(Player executor) {
        LanguageConfig language = LanguageConfig.getLanguage((CommandSender)executor);
        SendMessageUtil.sendMessage((CommandSender)executor, language.getFormatPrefixMessage((CommandSender)executor, "back.teleport_success", language.getMessage("last_location")));
    }

    public static void tpLogoutCommandSuccess(Player executor, String targetName) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "teleport.logout_location", targetName));
    }

    public static void setLangCommandSuccess(Player executor, String target) {
        SendMessageUtil.sendMessage((CommandSender)executor, LanguageConfig.getLanguage((CommandSender)executor).getFormatPrefixMessage((CommandSender)executor, "lang.set_success", target));
    }
}

