/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.craft_hello.tpa.exceptions.UpdateFailedException;
import top.craft_hello.tpa.utils.SendMessageUtil;

public class VersionUtil {
    private static String pluginName;
    private static String pluginVersion;

    public static void init(Plugin plugin) {
        PluginDescriptionFile description = plugin.getDescription();
        pluginName = description.getName();
        pluginVersion = description.getVersion();
    }

    @Nullable
    public static String readFirstLine(URL url) throws IOException {
        if (Objects.isNull(url)) {
            throw new NullPointerException();
        }
        InputStream is = url.openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        return br.readLine();
    }

    public static void updateCheck(CommandSender sender) {
        String latestVersion1;
        SendMessageUtil.checkUpdate(sender);
        try {
            String urlStringPart1 = "https://warskygod.github.io/";
            String urlStringPart2 = pluginName;
            String urlStringPart3 = "/latest.html";
            latestVersion1 = VersionUtil.readFirstLine(new URL(urlStringPart1 + urlStringPart2 + urlStringPart3));
        }
        catch (Throwable var5) {
            throw new UpdateFailedException(sender);
        }
        String latestVersion = latestVersion1;
        if (VersionUtil.versionComparison(pluginVersion, latestVersion)) {
            SendMessageUtil.pluginUpdateMessage(sender, latestVersion);
            return;
        }
        SendMessageUtil.pluginLatestVersion(sender);
    }

    public static String getPluginVersion() {
        return pluginVersion;
    }

    public static int getPluginBigVersion(@NotNull String version) {
        String[] versions = version.split("\\.");
        return Integer.parseInt(versions.length >= 1 ? versions[0] : "0");
    }

    public static int getPluginMiddleVersion(@NotNull String version) {
        String[] versions = version.split("\\.");
        return Integer.parseInt(versions.length >= 2 ? versions[1] : "0");
    }

    public static int getPluginSmallVersion(@NotNull String version) {
        String[] versions = version.split("\\.");
        return Integer.parseInt(versions.length == 3 ? versions[2] : "0");
    }

    public static boolean versionComparison(String version1, String version2) {
        int version1Big = VersionUtil.getPluginBigVersion(version1);
        int version1Middle = VersionUtil.getPluginMiddleVersion(version1);
        int version1Small = VersionUtil.getPluginSmallVersion(version1);
        int version2Big = VersionUtil.getPluginBigVersion(version2);
        int version2Middle = VersionUtil.getPluginMiddleVersion(version2);
        int version2Small = VersionUtil.getPluginSmallVersion(version2);
        return VersionUtil.isOlderThan(version1Big, version1Middle, version1Small, version2Big, version2Middle, version2Small);
    }

    public static boolean isOlderThan(int currentBig, int currentMiddle, int currentSmall, int big, int middle, int small) {
        if (currentBig > big) {
            return false;
        }
        if (currentBig < big) {
            return true;
        }
        if (currentMiddle > middle) {
            return false;
        }
        if (currentMiddle < middle) {
            return true;
        }
        return currentSmall < small;
    }
}

