/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.whimcraft.common.init;

import com.xinyihl.whimcraft.Configurations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Loader;

public enum Mixins {
    PatternEncoder("PatternEncoder", false, () -> Configurations.AEMOD_CONFIG.patternEncoder, "ae2fc", "appliedenergistics2"),
    CellTotalTypes("CellTotalTypes", false, null, "appliedenergistics2", "mekeng", "nae2"),
    IgnoreParallel("IgnoreParallel", true, () -> Configurations.MMCE_CONFIG.isIgnoreParallel, "appliedenergistics2", "modularmachinery"),
    PerkLevelManager("PerkLevelManager", true, null, "astralsorcery"),
    ManaRecipeWrapper("ManaRecipeWrapper", true, () -> Configurations.BOTANIA_CONFIG.showMana, "botania"),
    LinkFlowerPool("LinkFlowerPool", true, () -> Configurations.BOTANIA_CONFIG.linkFlowerToPool, "botania"),
    FixItemIngredientsCrash("FixItemIngredientsCrash", true, null, "extrautils2"),
    RainbowGenerator("RainbowGenerator", true, null, "extrautils2"),
    GuguMEAspectBus("GuguMEAspectBus", true, null, "gugu-utils", "modularmachinery", "appliedenergistics2", "thaumcraft"),
    MmceMEAspectBus("MmceMEAspectBus", true, null, "modularmachinery", "appliedenergistics2", "thaumcraft"),
    FurnaceXp("FurnaceXp", true, () -> Configurations.IC2_CONFIG.changeXPOrb, "ic2"),
    MmceMain("MmceMain", true, null, "modularmachinery"),
    MobUtilsXpSupport("MobUtilsXpSupport", true, () -> Configurations.MOBUTILS_CONFIG.otherXpSupport, "mob_grinding_utils"),
    ModTweakerApplyAction("ModTweakerApplyAction", true, () -> Configurations.MODTWMOD_CONFIG.loadCompleteMixinEnable, "modtweaker"),
    AuraChunkUpdate("AuraChunkUpdate", true, () -> !Configurations.NATURE_CONFIG.auraChunkUpdateEnable, "naturesaura"),
    FixTileMelterCrash("FixTileMelterCrash", true, null, "tcomplement"),
    EntityMobFarmDrop("EntityMobFarmDrop", true, null, "tinymobfarm"),
    PassKeyToSearchInAeGui("PassKeyToSearchInAeGui", true, () -> Configurations.AEMOD_CONFIG.searchInGui, "appliedenergistics2"),
    RecipeTransferOrder("RecipeTransferOrder", true, () -> Configurations.GENERAL_CONFIG.JeiTransferOrderEnable, "appliedenergistics2", "modularmachinery");

    final String mixinName;
    final String[] modId;
    final boolean needAllLoad;
    final Supplier<Boolean> otherConfig;

    private Mixins(String mixinName, boolean needAllLoad, Supplier<Boolean> otherConfig, String ... modId) {
        this.mixinName = mixinName;
        this.otherConfig = otherConfig;
        this.needAllLoad = needAllLoad;
        this.modId = modId;
    }

    public static List<String> getMixinConfigs() {
        ArrayList<String> mixinConfigs = new ArrayList<String>();
        Arrays.stream(Mixins.values()).forEach(value -> {
            if (value.needAllLoad) {
                if (Arrays.stream(value.modId).allMatch(Loader::isModLoaded) && (value.otherConfig == null || value.otherConfig.get().booleanValue())) {
                    mixinConfigs.add("mixins/mixin.whimcraft." + value.mixinName + ".json");
                }
            } else if (value.otherConfig == null || value.otherConfig.get().booleanValue()) {
                mixinConfigs.addAll(Arrays.stream(value.modId).filter(Loader::isModLoaded).map(id -> "mixins/mixin.whimcraft." + value.mixinName + "." + id + ".json").collect(Collectors.toList()));
            }
        });
        return mixinConfigs;
    }
}

