/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.whimcraft.common.integration.adapter.tc6;

import com.xinyihl.whimcraft.Configurations;
import com.xinyihl.whimcraft.common.integration.adapter.tc6.AspectRequirementUtil;
import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementIngredientArray;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.InfusionRecipe;

public class AdapterTC6InfusionMatrix
extends RecipeAdapter {
    public AdapterTC6InfusionMatrix() {
        super(new ResourceLocation("thaumcraft", "whimcraft_infusion_matrix"));
    }

    @Nonnull
    public Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, List<ComponentRequirement<?, ?>> additionalRequirements, Map<Class<?>, List<IEventHandler<RecipeEvent>>> eventHandlers, List<String> recipeTooltips) {
        ArrayList<MachineRecipe> machineRecipeList = new ArrayList<MachineRecipe>();
        ThaumcraftApi.getCraftingRecipes().forEach((recipeName, tcRecipe) -> {
            if (!(tcRecipe instanceof InfusionRecipe)) {
                return;
            }
            InfusionRecipe recipe = (InfusionRecipe)tcRecipe;
            if (recipe.getRecipeInput() == null) {
                return;
            }
            if (recipe.recipeOutput == null) {
                return;
            }
            int inAmount = Math.round(RecipeModifier.applyModifiers((Collection)modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.INPUT, (float)1.0f, (boolean)false));
            if (inAmount <= 0) {
                return;
            }
            int inDuration = Math.round(RecipeModifier.applyModifiers((Collection)modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_DURATION, (IOType)IOType.INPUT, (float)(recipe.instability == 0 ? (float)Configurations.ADAPTER_CONFIG.infusionMatrixTime : (float)(recipe.instability * Configurations.ADAPTER_CONFIG.infusionMatrixTimeMul)), (boolean)false));
            if (inDuration <= 0) {
                return;
            }
            MachineRecipe machineRecipe = this.createRecipeShell(new ResourceLocation("thaumcraft", "whimcraft_auto_infusion" + this.incId), owningMachineName, inDuration, this.incId, false);
            ItemStack[] inputMain = recipe.getRecipeInput().func_193365_a();
            List inputMainList = Arrays.stream(inputMain).map(itemStack -> new ChancedIngredientStack(ItemUtils.copyStackWithSize((ItemStack)itemStack, (int)inAmount))).collect(Collectors.toList());
            if (!inputMainList.isEmpty()) {
                machineRecipe.addRequirement((ComponentRequirement)new RequirementIngredientArray(inputMainList));
            }
            recipe.getComponents().stream().map(ingredient -> Arrays.stream(ingredient.func_193365_a()).map(ChancedIngredientStack::new).collect(Collectors.toList())).filter(stackList -> !stackList.isEmpty()).map(RequirementIngredientArray::new).forEach(arg_0 -> ((MachineRecipe)machineRecipe).addRequirement(arg_0));
            recipe.getAspects().aspects.forEach((aspect, amount) -> {
                int inAmounta = Math.round(RecipeModifier.applyModifiers((Collection)modifiers, AspectRequirementUtil.getRequirementType(), (IOType)IOType.INPUT, (float)amount.intValue(), (boolean)false));
                if (inAmounta <= 0) {
                    return;
                }
                machineRecipe.addRequirement(AspectRequirementUtil.getRequirement(IOType.INPUT, inAmounta, aspect));
            });
            boolean type = true;
            Object output = recipe.recipeOutput;
            if (output != null) {
                if (output instanceof ItemStack) {
                    int outAmount = Math.round(RecipeModifier.applyModifiers((Collection)modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.OUTPUT, (float)((ItemStack)output).func_190916_E(), (boolean)false));
                    if (outAmount > 0) {
                        machineRecipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize((ItemStack)((ItemStack)output), (int)outAmount)));
                        type = false;
                    }
                } else {
                    Object[] objects = (Object[])output;
                    for (ItemStack stack : recipe.getRecipeInput().func_193365_a()) {
                        if (stack == null || stack.func_190926_b()) continue;
                        ItemStack copied = stack.func_77946_l();
                        copied.func_77983_a((String)objects[0], (NBTBase)objects[1]);
                        machineRecipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.OUTPUT, copied));
                        type = false;
                    }
                }
            }
            if (type) {
                return;
            }
            machineRecipeList.add(machineRecipe);
            ++this.incId;
        });
        return machineRecipeList;
    }
}

