/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.whimcraft.common.integration.adapter.tc6;

import com.google.gson.Gson;
import com.xinyihl.whimcraft.Configurations;
import com.xinyihl.whimcraft.common.integration.adapter.jei.WhimcraftJeiPlugin;
import com.xinyihl.whimcraft.common.integration.adapter.tc6.AspectCache;
import com.xinyihl.whimcraft.common.integration.adapter.tc6.AspectRequirementUtil;
import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.aspects.AspectList;

public class AdapterTC6Smelter
extends RecipeAdapter {
    private static final Logger log = LogManager.getLogger(AdapterTC6Smelter.class);
    private static final Map<ItemStack, AspectList> itemAspectList = new HashMap<ItemStack, AspectList>();
    private static final Gson GSON = new Gson();

    public AdapterTC6Smelter() {
        super(new ResourceLocation("thaumcraft", "whimcraft_smelter"));
    }

    @Nonnull
    public Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, List<ComponentRequirement<?, ?>> additionalRequirements, Map<Class<?>, List<IEventHandler<RecipeEvent>>> eventHandlers, List<String> recipeTooltips) {
        File file = new File(WhimcraftJeiPlugin.ASPECT_PATH);
        ArrayList<MachineRecipe> machineRecipeList = new ArrayList<MachineRecipe>();
        this.optimizedMethod(file);
        if (!itemAspectList.isEmpty()) {
            itemAspectList.forEach((itemStack, aspectList) -> {
                if (itemStack.func_190926_b()) {
                    return;
                }
                int inDuration = Math.round(RecipeModifier.applyModifiers((Collection)modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_DURATION, (IOType)IOType.INPUT, (float)Configurations.ADAPTER_CONFIG.smelterTime, (boolean)false));
                if (inDuration <= 0) {
                    return;
                }
                MachineRecipe machineRecipe = this.createRecipeShell(new ResourceLocation("thaumcraft", "whimcraft_auto_smelter" + this.incId), owningMachineName, inDuration, this.incId, false);
                int inAmount = Math.round(RecipeModifier.applyModifiers((Collection)modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.INPUT, (float)itemStack.func_190916_E(), (boolean)false));
                if (inAmount <= 0) {
                    return;
                }
                itemStack.func_190920_e(inAmount);
                machineRecipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.INPUT, itemStack));
                aspectList.aspects.forEach((aspect, integer) -> {
                    int outAmount = Math.round(RecipeModifier.applyModifiers((Collection)modifiers, AspectRequirementUtil.getRequirementType(), (IOType)IOType.OUTPUT, (float)integer.intValue(), (boolean)false));
                    if (outAmount <= 0) {
                        return;
                    }
                    machineRecipe.addRequirement(AspectRequirementUtil.getRequirement(IOType.OUTPUT, outAmount, aspect));
                });
                machineRecipeList.add(machineRecipe);
                ++this.incId;
            });
        }
        return machineRecipeList;
    }

    private void optimizedMethod(File file) {
        if (!file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(file);){
            AspectCache[] aspectCaches;
            for (AspectCache aspectCache : aspectCaches = (AspectCache[])GSON.fromJson((Reader)reader, AspectCache[].class)) {
                this.processAspectCache(aspectCache);
            }
        }
        catch (IOException e) {
            log.warn("Failed to load aspect caches from file");
        }
    }

    private void processAspectCache(AspectCache aspectCache) {
        AspectList aspectList = new AspectList();
        aspectList.readFromNBT(this.safeParseNBT(aspectCache.aspects));
        itemAspectList.put(new ItemStack(this.safeParseNBT(aspectCache.item)), aspectList);
    }

    private NBTTagCompound safeParseNBT(String json) {
        try {
            return JsonToNBT.func_180713_a((String)json);
        }
        catch (NBTException e) {
            return new NBTTagCompound();
        }
    }
}

