/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.whimcraft.common.integration.crafttweaker;

import com.mojang.authlib.GameProfile;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IWorld;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.whimcraft.WhimCraftUtils")
public class WhimCraftUtils {
    private static final GameProfile GAME_PROFILE = new GameProfile(UUID.fromString("7E1D8024-D2EF-4077-AD6F-636F16F43BB6"), "[WhimCraft]");
    private static Method getLootTable;

    @ZenMethod
    public static IItemStack[] getDrops(IEntity ientity, boolean isPlayer, int luck) {
        FakePlayer killer;
        ResourceLocation lootTableLocation;
        Entity entity = CraftTweakerMC.getEntity((IEntity)ientity);
        if (entity.field_70170_p.field_72995_K || !(entity instanceof EntityLiving)) {
            return null;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        WorldServer worldServer = (WorldServer)entityliving.field_70170_p;
        if (getLootTable == null) {
            getLootTable = ObfuscationReflectionHelper.findMethod(EntityLiving.class, (String)"getLootTable", ResourceLocation.class, (Class[])new Class[0]);
        }
        try {
            lootTableLocation = (ResourceLocation)getLootTable.invoke((Object)entityliving, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (lootTableLocation == null) {
            return null;
        }
        LootTableManager lootTableManager = worldServer.func_184146_ak();
        LootTable lootTable = lootTableManager.func_186521_a(lootTableLocation);
        LootContext.Builder contextBuilder = new LootContext.Builder(worldServer).func_186469_a((float)luck);
        if (isPlayer && (killer = FakePlayerFactory.get((WorldServer)worldServer, (GameProfile)GAME_PROFILE)) != null) {
            contextBuilder.func_186470_a((EntityPlayer)killer);
        }
        LootContext context = contextBuilder.func_186471_a();
        List drops = lootTable.func_186462_a(entityliving.func_70681_au(), context);
        return CraftTweakerMC.getIItemStacks((ItemStack[])drops.toArray(new ItemStack[0]));
    }

    @ZenMethod
    public static IItemStack[] getDrops(IWorld iworld, String location, boolean isPlayer, int luck) {
        World world = CraftTweakerMC.getWorld((IWorld)iworld);
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return null;
        }
        WorldServer worldServer = (WorldServer)world;
        ResourceLocation lootTableLocation = new ResourceLocation(location);
        LootTableManager lootTableManager = worldServer.func_184146_ak();
        LootTable lootTable = lootTableManager.func_186521_a(lootTableLocation);
        LootContext.Builder contextBuilder = new LootContext.Builder(worldServer).func_186469_a((float)luck);
        if (isPlayer) {
            FakePlayer killer = FakePlayerFactory.get((WorldServer)worldServer, (GameProfile)GAME_PROFILE);
            contextBuilder.func_186470_a((EntityPlayer)killer);
        }
        LootContext context = contextBuilder.func_186471_a();
        List drops = lootTable.func_186462_a(worldServer.field_73012_v, context);
        return CraftTweakerMC.getIItemStacks((ItemStack[])drops.toArray(new ItemStack[0]));
    }
}

