/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.whimcraft.common.mixins.appliedenergistics2;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.crafting.MECraftingInventory;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import com.xinyihl.whimcraft.common.api.IMEPatternIgnoreParallel;
import github.kasuminova.mmce.common.tile.MEPatternProvider;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={CraftingCPUCluster.class}, remap=false)
public abstract class CraftingCPUClusterTwoMixin {
    @Shadow
    private long lastTime;
    @Shadow
    private int remainingOperations;
    @Unique
    private boolean r$isMEPatternProvider = false;
    @Unique
    private boolean r$IgnoreParallel = false;
    @Unique
    private long r$craftingFrequency = 0L;

    @Shadow
    protected abstract void postChange(IAEItemStack var1, IActionSource var2);

    @Shadow
    protected abstract void postCraftingStatusChange(IAEItemStack var1);

    @Redirect(method={"executeCrafting"}, at=@At(value="INVOKE", target="Ljava/util/Map$Entry;getKey()Ljava/lang/Object;"))
    private Object getKeyR(Map.Entry<ICraftingPatternDetails, AccessorTaskProgress> instance) {
        ICraftingPatternDetails key = instance.getKey();
        long max = 0L;
        for (IAEItemStack stack : key.getCondensedInputs()) {
            long size = stack.getStackSize();
            if (size <= max) continue;
            max = size;
        }
        this.r$craftingFrequency = instance.getValue().getValue();
        if (max * this.r$craftingFrequency > Integer.MAX_VALUE) {
            this.r$craftingFrequency = Integer.MAX_VALUE / max;
        }
        return key;
    }

    @Redirect(method={"executeCrafting"}, at=@At(value="INVOKE", target="Lappeng/api/networking/crafting/ICraftingMedium;isBusy()Z"))
    private boolean isBusyR(ICraftingMedium instance) {
        IMEPatternIgnoreParallel mep;
        if (instance instanceof IMEPatternIgnoreParallel && ((mep = (IMEPatternIgnoreParallel)instance).getWorkMode() == MEPatternProvider.WorkModeSetting.DEFAULT || mep.getWorkMode() == MEPatternProvider.WorkModeSetting.ENHANCED_BLOCKING_MODE)) {
            this.r$isMEPatternProvider = true;
            if (mep.r$isIgnoreParallel()) {
                this.r$IgnoreParallel = true;
            } else {
                this.r$IgnoreParallel = false;
                this.r$craftingFrequency = Math.min((long)this.remainingOperations, this.r$craftingFrequency);
            }
        }
        return instance.isBusy();
    }

    @Redirect(method={"executeCrafting"}, at=@At(value="INVOKE", target="Lappeng/api/networking/energy/IEnergyGrid;extractAEPower(DLappeng/api/config/Actionable;Lappeng/api/config/PowerMultiplier;)D"))
    private double extractAEPowerR(IEnergyGrid eg, double v, Actionable actionable, PowerMultiplier powerMultiplier) {
        if (this.r$isMEPatternProvider) {
            double sum = v * (double)this.r$craftingFrequency;
            double o = eg.extractAEPower(sum, Actionable.SIMULATE, powerMultiplier);
            if (o < sum - 0.01) {
                long s;
                this.r$craftingFrequency = s = (long)(o / sum * (double)this.r$craftingFrequency);
                if (s < 1L) {
                    return eg.extractAEPower(v, actionable, powerMultiplier);
                }
                return eg.extractAEPower(v * (double)s, Actionable.SIMULATE, powerMultiplier);
            }
            return o;
        }
        return eg.extractAEPower(v, actionable, powerMultiplier);
    }

    @Redirect(method={"executeCrafting"}, at=@At(value="INVOKE", target="Lappeng/crafting/MECraftingInventory;extractItems(Lappeng/api/storage/data/IAEItemStack;Lappeng/api/config/Actionable;Lappeng/api/networking/security/IActionSource;)Lappeng/api/storage/data/IAEItemStack;"))
    private IAEItemStack extractItemsR(MECraftingInventory instance, IAEItemStack request, Actionable mode, IActionSource src) {
        if (this.r$isMEPatternProvider) {
            IAEItemStack i = (IAEItemStack)request.copy().setStackSize(request.getStackSize() * this.r$craftingFrequency);
            return instance.extractItems(i, mode, src);
        }
        return instance.extractItems(request, mode, src);
    }

    @Redirect(method={"executeCrafting"}, at=@At(value="INVOKE", target="Lappeng/me/cluster/implementations/CraftingCPUCluster;postChange(Lappeng/api/storage/data/IAEItemStack;Lappeng/api/networking/security/IActionSource;)V", ordinal=1))
    private void postChangeR1(CraftingCPUCluster instance, IAEItemStack receiver, IActionSource single) {
        if (this.r$isMEPatternProvider) {
            IAEItemStack i = (IAEItemStack)receiver.copy().setStackSize(receiver.getStackSize() * this.r$craftingFrequency);
            this.postChange(i, single);
        } else {
            this.postChange(receiver, single);
        }
    }

    @Redirect(method={"executeCrafting"}, at=@At(value="INVOKE", target="Lappeng/me/cluster/implementations/CraftingCPUCluster;postChange(Lappeng/api/storage/data/IAEItemStack;Lappeng/api/networking/security/IActionSource;)V", ordinal=2))
    private void postChangeR2(CraftingCPUCluster instance, IAEItemStack receiver, IActionSource single) {
        if (this.r$isMEPatternProvider) {
            IAEItemStack i = (IAEItemStack)receiver.copy().setStackSize(receiver.getStackSize() * this.r$craftingFrequency);
            this.postChange(i, single);
        } else {
            this.postChange(receiver, single);
        }
    }

    @Redirect(method={"executeCrafting"}, at=@At(value="INVOKE", target="Lappeng/api/storage/data/IItemList;add(Lappeng/api/storage/data/IAEStack;)V", ordinal=0))
    private void addR(IItemList<IAEItemStack> instance, IAEStack<IAEItemStack> iaeStack) {
        if (!this.r$isMEPatternProvider) {
            instance.add((IAEStack)((IAEItemStack)iaeStack));
        } else {
            iaeStack.setStackSize(iaeStack.getStackSize() * this.r$craftingFrequency);
            instance.add((IAEStack)((IAEItemStack)iaeStack));
        }
    }

    @Redirect(method={"executeCrafting"}, at=@At(value="INVOKE", target="Lappeng/me/cluster/implementations/CraftingCPUCluster;postCraftingStatusChange(Lappeng/api/storage/data/IAEItemStack;)V", ordinal=0))
    private void postCraftingStatusChangeR(CraftingCPUCluster instance, IAEItemStack iaeStack) {
        if (!this.r$isMEPatternProvider) {
            this.postCraftingStatusChange(iaeStack);
        } else {
            iaeStack.setStackSize(iaeStack.getStackSize() * this.r$craftingFrequency);
            this.postCraftingStatusChange(iaeStack);
        }
    }

    @Redirect(method={"executeCrafting"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getCount()I", remap=true))
    private int getCountR(ItemStack instance) {
        int out = instance.func_190916_E();
        if (!this.r$isMEPatternProvider) {
            return out;
        }
        return out / (int)this.r$craftingFrequency;
    }

    @Redirect(method={"executeCrafting"}, at=@At(value="INVOKE", target="Ljava/util/Map$Entry;getValue()Ljava/lang/Object;", ordinal=2))
    private Object getValueR(Map.Entry<ICraftingPatternDetails, AccessorTaskProgress> instance) {
        if (this.r$isMEPatternProvider) {
            if (!this.r$IgnoreParallel) {
                this.remainingOperations -= (int)(this.r$craftingFrequency - 1L);
            }
            AccessorTaskProgress value = instance.getValue();
            value.setValue(value.getValue() - (this.r$craftingFrequency - 1L));
            return value;
        }
        return instance.getValue();
    }

    @Mixin(targets={"appeng.me.cluster.implementations.CraftingCPUCluster$TaskProgress"}, remap=false)
    public static interface AccessorTaskProgress {
        @Accessor
        public long getValue();

        @Accessor
        public void setValue(long var1);
    }
}

