/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.whimcraft.common.mixins.modtweaker;

import com.blamejared.ModTweaker;
import com.xinyihl.whimcraft.Configurations;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModTweaker.class}, remap=false)
public abstract class ModTweakerMixin {
    @Final
    @Shadow
    public static List<IAction> LATE_REMOVALS;
    @Final
    @Shadow
    public static List<IAction> LATE_ADDITIONS;

    @Inject(method={"preInit"}, at={@At(value="HEAD")})
    public void injectPreInit(FMLPreInitializationEvent e, CallbackInfo ci) {
        if ("preinit".equals(Configurations.MODTWMOD_CONFIG.loadComplete)) {
            this.whimCraft$apply();
        }
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    public void injectInit(FMLInitializationEvent e, CallbackInfo ci) {
        if ("init".equals(Configurations.MODTWMOD_CONFIG.loadComplete)) {
            this.whimCraft$apply();
        }
    }

    @Inject(method={"postInit"}, at={@At(value="HEAD")})
    public void injectPostInit(FMLPostInitializationEvent e, CallbackInfo ci) {
        if ("postinit".equals(Configurations.MODTWMOD_CONFIG.loadComplete)) {
            this.whimCraft$apply();
        }
    }

    @Unique
    public void whimCraft$apply() {
        List<String> needChange = Arrays.asList(Configurations.MODTWMOD_CONFIG.classList);
        ArrayList<IAction> A = new ArrayList<IAction>();
        ArrayList<IAction> R = new ArrayList<IAction>();
        try {
            for (IAction action : LATE_REMOVALS) {
                if (!needChange.contains(action.getClass().getName())) continue;
                action.apply();
                A.add(action);
            }
            for (IAction action : LATE_ADDITIONS) {
                if (!needChange.contains(action.getClass().getName())) continue;
                action.apply();
                R.add(action);
            }
        }
        catch (Exception e) {
            CraftTweakerAPI.logError((String)"Error while applying actions", (Throwable)e);
        }
        LATE_REMOVALS.removeAll(A);
        LATE_ADDITIONS.removeAll(R);
    }
}

