/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.whimcraft.common.title.base;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import com.xinyihl.whimcraft.common.title.base.TitleMeBase;
import github.kasuminova.mmce.common.util.Sides;
import hellfirepvp.modularmachinery.client.ClientProxy;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.tiles.base.ColorableMachineTile;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.EssentiaStack;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.api.storage.IEssentiaStorageChannel;
import thaumicenergistics.integration.appeng.AEEssentiaStack;
import thaumicenergistics.integration.appeng.grid.GridUtil;
import thaumicenergistics.util.AEUtil;

public abstract class TitleMEAspectBus
extends TitleMeBase
implements MachineComponentTile,
ColorableMachineTile {
    private int definedColor = Config.machineColor;

    public TitleMEAspectBus() {
        this.proxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public int getMachineColor() {
        return this.definedColor;
    }

    public void setMachineColor(int newColor) {
        if (this.definedColor != newColor) {
            this.definedColor = newColor;
            this.sync();
        }
    }

    protected IEssentiaStorageChannel getChannel() {
        return (IEssentiaStorageChannel)AEApi.instance().storage().getStorageChannel(IEssentiaStorageChannel.class);
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (!tag.func_74764_b("casingColor")) {
            this.definedColor = Config.machineColor;
        } else {
            int newColor = tag.func_74762_e("casingColor");
            if (this.definedColor != newColor) {
                this.definedColor = newColor;
                Sides.CLIENT.runIfPresent(() -> ClientProxy.clientScheduler.addRunnable(() -> {
                    World world = this.func_145831_w();
                    world.func_175641_c(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177230_c(), 1, 1);
                }, 0));
            }
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("casingColor", this.definedColor);
        return tag;
    }

    public synchronized int addAspectToME(Aspect aspect, int i, boolean b) {
        EssentiaStack inContainer = new EssentiaStack(aspect, i);
        AEEssentiaStack toInsert = AEEssentiaStack.fromEssentiaStack((EssentiaStack)inContainer);
        try {
            IStorageGrid storage = GridUtil.getStorageGrid((IGridHost)this);
            IMEMonitor monitor = storage.getInventory((IStorageChannel)this.getChannel());
            if (monitor.canAccept((IAEStack)toInsert)) {
                IAEEssentiaStack notInserted = (IAEEssentiaStack)monitor.injectItems((IAEStack)toInsert, Actionable.SIMULATE, this.source);
                if (notInserted != null && notInserted.getStackSize() > 0L) {
                    toInsert.decStackSize(notInserted.getStackSize());
                }
                if (b) {
                    monitor.injectItems((IAEStack)toInsert, Actionable.MODULATE, this.source);
                }
            }
            this.func_70296_d();
            return (int)toInsert.getStackSize();
        }
        catch (GridAccessException gridAccessException) {
            return 0;
        }
    }

    public synchronized int takeAspectFromME(Aspect aspect, int i, boolean b) {
        try {
            IStorageGrid storage = GridUtil.getStorageGrid((IGridHost)this);
            IMEMonitor monitor = storage.getInventory((IStorageChannel)this.getChannel());
            IAEEssentiaStack canExtract = (IAEEssentiaStack)monitor.extractItems((IAEStack)AEUtil.getAEStackFromAspect((Aspect)aspect, (int)i), Actionable.SIMULATE, this.source);
            if (canExtract == null) {
                return 0;
            }
            if (canExtract.getStackSize() != (long)i) {
                return (int)canExtract.getStackSize();
            }
            if (b) {
                monitor.extractItems((IAEStack)canExtract, Actionable.MODULATE, this.source);
            }
            this.func_70296_d();
            return (int)canExtract.getStackSize();
        }
        catch (GridAccessException gridAccessException) {
            return 0;
        }
    }
}

