/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.whimcraft.common.integration.crafttweaker;

import com.mojang.authlib.GameProfile;
import com.xinyihl.whimcraft.common.integration.crafttweaker.LootTableReflector;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.whimcraft.WhimCraftUtils")
public class WhimCraftUtils {
    private static final GameProfile GAME_PROFILE = new GameProfile(UUID.fromString("7E1D8024-D2EF-4077-AD6F-636F16F43BB6"), "[WhimCraft]");

    @ZenMethod
    public static IItemStack[] getDrops(IEntity ientity, boolean isPlayer, int luck) {
        FakePlayer killer;
        Entity entity = CraftTweakerMC.getEntity((IEntity)ientity);
        if (entity.field_70170_p.field_72995_K || !(entity instanceof EntityLiving)) {
            return null;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        WorldServer worldServer = (WorldServer)entityliving.field_70170_p;
        ResourceLocation lootTableLocation = LootTableReflector.getLootTable(entityliving);
        LootTableManager lootTableManager = worldServer.func_184146_ak();
        if (lootTableLocation == null) {
            return null;
        }
        LootTable lootTable = lootTableManager.func_186521_a(lootTableLocation);
        LootContext.Builder contextBuilder = new LootContext.Builder(worldServer).func_186472_a((Entity)entityliving).func_186469_a((float)luck);
        DamageSource damageSource = DamageSource.field_76377_j;
        if (isPlayer && (killer = FakePlayerFactory.get((WorldServer)worldServer, (GameProfile)GAME_PROFILE)) != null) {
            contextBuilder.func_186470_a((EntityPlayer)killer);
            damageSource = DamageSource.func_76365_a((EntityPlayer)killer);
        }
        contextBuilder.func_186473_a(damageSource);
        LootContext context = contextBuilder.func_186471_a();
        HashMap<Item, ItemStack> outMap = new HashMap<Item, ItemStack>();
        List drops = lootTable.func_186462_a(entityliving.func_70681_au(), context);
        for (ItemStack item : drops) {
            if (outMap.containsKey(item.func_77973_b())) {
                ItemStack stack = (ItemStack)outMap.get(item.func_77973_b());
                if (stack.func_190916_E() >= 16) continue;
                stack.func_190920_e(stack.func_190916_E() + 1);
                continue;
            }
            outMap.put(item.func_77973_b(), item);
        }
        return CraftTweakerMC.getIItemStacks((ItemStack[])outMap.values().toArray(new ItemStack[0]));
    }
}

