/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.whimcraft.common.mixins.mmce;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.features.ILocatable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.features.IWirelessTermRegistry;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.items.tools.powered.ToolWirelessTerminal;
import appeng.me.helpers.PlayerSource;
import appeng.tile.misc.TileSecurityStation;
import appeng.util.item.AEItemStack;
import baubles.api.BaublesApi;
import com.xinyihl.whimcraft.Configurations;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.network.PktAssemblyReport;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import ink.ikx.mmce.common.assembly.MachineAssembly;
import ink.ikx.mmce.common.utils.StructureIngredient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={MachineAssembly.class}, remap=false)
public abstract class MachineAssemblyMixin {
    @Shadow
    @Final
    private EntityPlayer player;
    @Shadow
    private StructureIngredient ingredient;

    @Shadow
    public static List<StructureIngredient.FluidIngredient> buildFluidIngredients(List<ItemStack> inventory, List<StructureIngredient.FluidIngredient> fluidIngredients) {
        return null;
    }

    @Shadow
    public static void searchAndRemoveContainFluid(List<ItemStack> inventory, List<StructureIngredient.FluidIngredient> fluidIngredients) {
    }

    @Shadow
    private static List<List<ItemStack>> getItemStackIngList(List<StructureIngredient.ItemIngredient> itemIngredientList) {
        return Collections.emptyList();
    }

    @Shadow
    private static List<List<FluidStack>> getFluidStackIngList(List<StructureIngredient.FluidIngredient> fluidIngredientList) {
        return Collections.emptyList();
    }

    @Unique
    private static void whimCraft$searchAndRemoveContainItem(EntityPlayer player, List<ItemStack> inventory, List<StructureIngredient.ItemIngredient> itemIngredients) {
        Iterator<StructureIngredient.ItemIngredient> itemIngredientIter = itemIngredients.iterator();
        block0: while (itemIngredientIter.hasNext()) {
            StructureIngredient.ItemIngredient ingredient = itemIngredientIter.next();
            for (Tuple tuple : ingredient.ingredientList()) {
                ItemStack required = (ItemStack)tuple.func_76341_a();
                if (!required.func_190926_b() && !MachineAssemblyMixin.whimCraft$consumeItem(player, false, required, inventory)) continue;
                itemIngredientIter.remove();
                continue block0;
            }
        }
    }

    @Unique
    private static boolean whimCraft$consumeItem(EntityPlayer player, boolean consume, ItemStack required, List<ItemStack> inventory) {
        for (ItemStack invStack : inventory) {
            if (!ItemUtils.matchStacks((ItemStack)invStack, (ItemStack)required)) continue;
            invStack.func_190918_g(required.func_190916_E());
            return true;
        }
        if (!Configurations.MMCE_CONFIG.assemblyAESupport) {
            return false;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack item = player.field_71071_by.func_70301_a(i);
            if (!(item.func_77973_b() instanceof ToolWirelessTerminal)) continue;
            return MachineAssemblyMixin.whimCraft$takeItemFromWirelessTerminal(consume, item, player, required, new BlockPos(i, 0, Integer.MIN_VALUE));
        }
        if (Loader.isModLoaded((String)"baubles")) {
            return MachineAssemblyMixin.whimCraft$readBaubles(player, consume, required);
        }
        return false;
    }

    @Unique
    @Optional.Method(modid="baubles")
    private static boolean whimCraft$readBaubles(EntityPlayer player, boolean consume, ItemStack required) {
        for (int i = 0; i < BaublesApi.getBaublesHandler((EntityPlayer)player).getSlots(); ++i) {
            ItemStack item = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(i);
            if (!(item.func_77973_b() instanceof ToolWirelessTerminal)) continue;
            return MachineAssemblyMixin.whimCraft$takeItemFromWirelessTerminal(consume, item, player, required, new BlockPos(i, 1, Integer.MIN_VALUE));
        }
        return false;
    }

    @Unique
    private static boolean whimCraft$takeItemFromWirelessTerminal(boolean consume, ItemStack item, EntityPlayer player, ItemStack required, BlockPos pos) {
        ToolWirelessTerminal wt = (ToolWirelessTerminal)item.func_77973_b();
        IWirelessTermRegistry registry = AEApi.instance().registries().wireless();
        if (!registry.isWirelessTerminal(item)) {
            player.func_145747_a(PlayerMessages.DeviceNotWirelessTerminal.get());
            return false;
        }
        IWirelessTermHandler handler = registry.getWirelessTerminalHandler(item);
        String unparsedKey = handler.getEncryptionKey(item);
        if (unparsedKey.isEmpty()) {
            player.func_145747_a(PlayerMessages.DeviceNotLinked.get());
            return false;
        }
        long parsedKey = Long.parseLong(unparsedKey);
        ILocatable securityStation = AEApi.instance().registries().locatable().getLocatableBy(parsedKey);
        if (securityStation instanceof TileSecurityStation) {
            TileSecurityStation t = (TileSecurityStation)securityStation;
            if (!handler.hasPower(player, 1000.0, item)) {
                player.func_145747_a(PlayerMessages.DeviceNotPowered.get());
                return false;
            }
            WirelessTerminalGuiObject obj = new WirelessTerminalGuiObject((IWirelessTermHandler)wt, item, player, player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (!obj.rangeCheck()) {
                player.func_145747_a(PlayerMessages.OutOfRange.get());
            } else {
                IGridNode gridNode = obj.getActionableNode();
                IGrid grid = gridNode.getGrid();
                if (MachineAssemblyMixin.whimCraft$securityCheck(player, grid)) {
                    IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
                    PlayerSource source = new PlayerSource(player, (IActionHost)t);
                    IMEMonitor monitor = storageGrid.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                    IAEItemStack canExtract = (IAEItemStack)monitor.extractItems(AEItemStack.fromItemStack((ItemStack)required).setStackSize(1L), Actionable.SIMULATE, (IActionSource)source);
                    if (canExtract != null && canExtract.getStackSize() == 1L) {
                        if (consume) {
                            monitor.extractItems((IAEStack)canExtract, Actionable.MODULATE, (IActionSource)source);
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Unique
    private static boolean whimCraft$securityCheck(EntityPlayer player, IGrid gridNode) {
        ISecurityGrid sg = (ISecurityGrid)gridNode.getCache(ISecurityGrid.class);
        return sg.hasPermission(player, SecurityPermissions.EXTRACT);
    }

    @Overwrite
    public static boolean checkAllItems(EntityPlayer player, StructureIngredient ingredient) {
        List<ItemStack> inventory = player.field_71071_by.field_70462_a.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        List itemIngredientList = ingredient.itemIngredient();
        List fluidIngredientList = ingredient.fluidIngredient();
        MachineAssemblyMixin.whimCraft$searchAndRemoveContainItem(player, inventory, itemIngredientList);
        MachineAssemblyMixin.searchAndRemoveContainFluid(inventory, fluidIngredientList);
        if (itemIngredientList.isEmpty() && fluidIngredientList.isEmpty()) {
            return true;
        }
        List<List<ItemStack>> itemStackIngList = MachineAssemblyMixin.getItemStackIngList(itemIngredientList);
        List<List<FluidStack>> fluidStackIngList = MachineAssemblyMixin.getFluidStackIngList(fluidIngredientList);
        PktAssemblyReport pkt = new PktAssemblyReport(itemStackIngList, fluidStackIngList);
        if (player instanceof EntityPlayerMP) {
            ModularMachinery.NET_CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        }
        return false;
    }

    @Overwrite
    public void buildIngredients(boolean consumeInventory) {
        Object inventory = this.player.field_71071_by.field_70462_a;
        if (!consumeInventory) {
            inventory = inventory.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        }
        List<StructureIngredient.ItemIngredient> newItemIngredients = this.whimCraft$buildItemIngredients((List<ItemStack>)inventory, this.ingredient.itemIngredient());
        List<StructureIngredient.FluidIngredient> newFluidIngredients = MachineAssemblyMixin.buildFluidIngredients((List<ItemStack>)inventory, this.ingredient.fluidIngredient());
        this.ingredient = new StructureIngredient(newItemIngredients, newFluidIngredients);
    }

    @Redirect(method={"assemblyItemBlocks"}, at=@At(value="INVOKE", target="Link/ikx/mmce/common/assembly/MachineAssembly;consumeInventoryItem(Lnet/minecraft/item/ItemStack;Ljava/util/List;)Z"))
    private boolean injected(ItemStack required, List<ItemStack> inventory) {
        return MachineAssemblyMixin.whimCraft$consumeItem(this.player, true, required, inventory);
    }

    @Unique
    public List<StructureIngredient.ItemIngredient> whimCraft$buildItemIngredients(List<ItemStack> inventory, List<StructureIngredient.ItemIngredient> itemIngredients) {
        ArrayList<StructureIngredient.ItemIngredient> result = new ArrayList<StructureIngredient.ItemIngredient>();
        Iterator<StructureIngredient.ItemIngredient> iterator = itemIngredients.iterator();
        block0: while (iterator.hasNext()) {
            StructureIngredient.ItemIngredient ingredient = iterator.next();
            for (Tuple tuple : ingredient.ingredientList()) {
                ItemStack required = (ItemStack)tuple.func_76341_a();
                if (!MachineAssemblyMixin.whimCraft$consumeItem(this.player, false, required, inventory)) continue;
                result.add(new StructureIngredient.ItemIngredient(ingredient.pos(), Collections.singletonList(tuple), ingredient.nbt()));
                iterator.remove();
                continue block0;
            }
        }
        return result;
    }
}

