/*
 * Decompiled with CFR 0.152.
 */
package com.xinyihl.whimcraft.common.operators;

import com.xinyihl.whimcraft.Configurations;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldChunkUnloader {
    private static final Logger log = LogManager.getLogger(WorldChunkUnloader.class);
    private final World world;
    private HashSet<ChunkPos> chunksToUnload;

    public WorldChunkUnloader(World world) {
        this.world = world;
    }

    private HashSet<ChunkPos> groupedChunksFinder(HashSet<ChunkPos> loadedChunks, ChunkPos seed, int radiusLimit) {
        LinkedList<ChunkPos> queue = new LinkedList<ChunkPos>();
        HashSet<ChunkPos> groupedChunks = new HashSet<ChunkPos>();
        if (!loadedChunks.contains(seed)) {
            return groupedChunks;
        }
        queue.add(seed);
        while (!queue.isEmpty()) {
            ChunkPos chunk = (ChunkPos)queue.remove();
            if (groupedChunks.contains(chunk)) continue;
            int west = chunk.field_77276_a;
            while (loadedChunks.contains(new ChunkPos(west - 1, chunk.field_77275_b)) && (radiusLimit == 0 || Math.abs(west - 1 - seed.field_77276_a) <= radiusLimit)) {
                --west;
            }
            int east = chunk.field_77276_a;
            while (loadedChunks.contains(new ChunkPos(east + 1, chunk.field_77275_b)) && (radiusLimit == 0 || Math.abs(east + 1 - seed.field_77276_a) <= radiusLimit)) {
                ++east;
            }
            for (int x = west; x <= east; ++x) {
                groupedChunks.add(new ChunkPos(x, chunk.field_77275_b));
                if (loadedChunks.contains(new ChunkPos(x, chunk.field_77275_b + 1)) && (radiusLimit == 0 || Math.abs(chunk.field_77275_b + 1 - seed.field_77275_b) <= radiusLimit)) {
                    queue.add(new ChunkPos(x, chunk.field_77275_b + 1));
                }
                if (!loadedChunks.contains(new ChunkPos(x, chunk.field_77275_b - 1)) || radiusLimit != 0 && Math.abs(chunk.field_77275_b - 1 - seed.field_77275_b) > radiusLimit) continue;
                queue.add(new ChunkPos(x, chunk.field_77275_b - 1));
            }
        }
        return groupedChunks;
    }

    private void populateChunksToUnload() {
        this.chunksToUnload = new HashSet();
        if (this.world.func_72863_F() instanceof ChunkProviderServer) {
            HashSet<ChunkPos> loadedChunks = new HashSet<ChunkPos>();
            HashSet<ChunkPos> playerLoadedChunks = new HashSet<ChunkPos>();
            HashSet<ChunkPos> forceLoadedChunks = new HashSet<ChunkPos>();
            HashSet<ChunkPos> spawnLoadedChunks = new HashSet<ChunkPos>();
            List listPlayers = this.world.field_73010_i;
            int CHUNK_WIDTH = 16;
            int PLAYER_RADIUS = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72395_o();
            boolean TICKET_RADIUS = false;
            int SPAWN_RADIUS = 8;
            int PLAYER_LIMIT = Configurations.CHUNCK_CONFIG.pradius;
            int TICKET_LIMIT = Configurations.CHUNCK_CONFIG.tradius;
            int SPAWN_LIMIT = Configurations.CHUNCK_CONFIG.sradius;
            for (Chunk chunk : ((ChunkProviderServer)this.world.func_72863_F()).func_189548_a()) {
                loadedChunks.add(chunk.func_76632_l());
            }
            int radiusLimit = (int)Math.ceil(PLAYER_RADIUS + PLAYER_LIMIT);
            for (EntityPlayer player : listPlayers) {
                if (player instanceof FakePlayer) continue;
                ChunkPos playerChunkCoords = new ChunkPos(player.field_70176_ah, player.field_70164_aj);
                playerLoadedChunks.addAll(this.groupedChunksFinder(loadedChunks, playerChunkCoords, radiusLimit));
            }
            radiusLimit = (int)Math.ceil(0 + TICKET_LIMIT);
            for (ChunkPos coord : this.world.getPersistentChunks().keySet()) {
                forceLoadedChunks.addAll(this.groupedChunksFinder(loadedChunks, coord, radiusLimit));
            }
            radiusLimit = (int)Math.ceil(8 + SPAWN_LIMIT);
            if (this.world.field_73011_w.func_76567_e() && this.world.field_73011_w.func_186058_p().shouldLoadSpawn()) {
                ChunkPos spawnChunkCoords = new ChunkPos((int)Math.floor((double)this.world.func_175694_M().func_177958_n() / 16.0), (int)Math.floor((double)this.world.func_175694_M().func_177952_p() / 16.0));
                spawnLoadedChunks.addAll(this.groupedChunksFinder(loadedChunks, spawnChunkCoords, radiusLimit));
            }
            for (ChunkPos coord : loadedChunks) {
                if (playerLoadedChunks.contains(coord) || forceLoadedChunks.contains(coord) || spawnLoadedChunks.contains(coord)) continue;
                this.chunksToUnload.add(coord);
            }
        }
    }

    public void unloadChunks() {
        long initialTime = MinecraftServer.func_130071_aq();
        this.populateChunksToUnload();
        if (this.world.func_72863_F() instanceof ChunkProviderServer) {
            ChunkProviderServer chunkProviderServer = (ChunkProviderServer)this.world.func_72863_F();
            for (ChunkPos coord : this.chunksToUnload) {
                Chunk chunk = chunkProviderServer.func_186026_b(coord.field_77276_a, coord.field_77275_b);
                if (chunk == null) continue;
                chunkProviderServer.func_189549_a(chunk);
            }
        }
        if (Configurations.CHUNCK_CONFIG.debug) {
            log.log(Level.INFO, "Queued " + this.chunksToUnload.size() + " chunks for unload in " + this.world.field_73011_w.func_186058_p().func_186065_b() + " (" + this.world.field_73011_w.getDimension() + ") in " + (MinecraftServer.func_130071_aq() - initialTime) + " milliseconds.");
        }
    }
}

