/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.database.impl;

import com.artillexstudios.axinventoryrestore.AxInventoryRestore;
import com.artillexstudios.axinventoryrestore.backups.Backup;
import com.artillexstudios.axinventoryrestore.backups.BackupData;
import com.artillexstudios.axinventoryrestore.database.Converter2;
import com.artillexstudios.axinventoryrestore.database.Converter3;
import com.artillexstudios.axinventoryrestore.database.Database;
import com.artillexstudios.axinventoryrestore.events.AxirEvents;
import com.artillexstudios.axinventoryrestore.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axinventoryrestore.libs.axapi.serializers.Serializers;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.ContainerUtils;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.StringUtils;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.logging.LogUtils;
import com.artillexstudios.axinventoryrestore.utils.SQLUtils;
import com.google.common.collect.HashBiMap;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Base
implements Database {
    private static final Logger log = LoggerFactory.getLogger(Base.class);
    private static volatile boolean shutdown = false;
    private final HashBiMap<Integer, UUID> uuidCache = HashBiMap.create();
    private final HashBiMap<Integer, String> reasonCache = HashBiMap.create();
    private final HashBiMap<Integer, String> worldCache = HashBiMap.create();
    private final AtomicBoolean cleaning = new AtomicBoolean(false);
    private long nextClear = 0L;

    public abstract Connection getConnection();

    @Override
    public abstract String getType();

    @Override
    public void setup() {
        Statement stmt;
        String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS axir_backups (id INT(128) NOT NULL AUTO_INCREMENT, userId INT(128) NOT NULL, reasonId INT(128) NOT NULL, worldId INT NOT NULL, x INT(128) NOT NULL, y INT(128) NOT NULL, z INT(128) NOT NULL, inventoryId INT NOT NULL, time BIGINT(128) NOT NULL, cause VARCHAR(1024), PRIMARY KEY (id));";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt2 = conn.prepareStatement("CREATE TABLE IF NOT EXISTS axir_backups (id INT(128) NOT NULL AUTO_INCREMENT, userId INT(128) NOT NULL, reasonId INT(128) NOT NULL, worldId INT NOT NULL, x INT(128) NOT NULL, y INT(128) NOT NULL, z INT(128) NOT NULL, inventoryId INT NOT NULL, time BIGINT(128) NOT NULL, cause VARCHAR(1024), PRIMARY KEY (id));");){
            stmt2.executeUpdate();
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while creating axir_backups table!", (Throwable)exception);
        }
        String CREATE_TABLE2 = "CREATE TABLE IF NOT EXISTS axir_reasons ( id INT(128) NOT NULL AUTO_INCREMENT, reason VARCHAR(255) NOT NULL, PRIMARY KEY (id), UNIQUE (reason));";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt3 = conn.prepareStatement("CREATE TABLE IF NOT EXISTS axir_reasons ( id INT(128) NOT NULL AUTO_INCREMENT, reason VARCHAR(255) NOT NULL, PRIMARY KEY (id), UNIQUE (reason));");){
            stmt3.executeUpdate();
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while creating axir_reasons table!", (Throwable)exception);
        }
        String CREATE_TABLE3 = "CREATE TABLE IF NOT EXISTS axir_users ( id INT(128) NOT NULL AUTO_INCREMENT, uuid VARCHAR(36) NOT NULL, name VARCHAR(512) NOT NULL, PRIMARY KEY (id), UNIQUE (uuid));";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt4 = conn.prepareStatement("CREATE TABLE IF NOT EXISTS axir_users ( id INT(128) NOT NULL AUTO_INCREMENT, uuid VARCHAR(36) NOT NULL, name VARCHAR(512) NOT NULL, PRIMARY KEY (id), UNIQUE (uuid));");){
            stmt4.executeUpdate();
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while creating axir_users table!", (Throwable)exception);
        }
        String CREATE_TABLE4 = "CREATE TABLE IF NOT EXISTS axir_restorerequests ( id INT(128) NOT NULL AUTO_INCREMENT, backupId INT(128) NOT NULL, granted BOOLEAN, PRIMARY KEY (id));";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt5 = conn.prepareStatement("CREATE TABLE IF NOT EXISTS axir_restorerequests ( id INT(128) NOT NULL AUTO_INCREMENT, backupId INT(128) NOT NULL, granted BOOLEAN, PRIMARY KEY (id));");){
            stmt5.executeUpdate();
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while creating axir_restorerequests table!", (Throwable)exception);
        }
        String CREATE_TABLE5 = "CREATE TABLE IF NOT EXISTS axir_storage (id INT NOT NULL AUTO_INCREMENT, inventory MEDIUMBLOB, PRIMARY KEY (id));";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt6 = conn.prepareStatement("CREATE TABLE IF NOT EXISTS axir_storage (id INT NOT NULL AUTO_INCREMENT, inventory MEDIUMBLOB, PRIMARY KEY (id));");){
            stmt6.executeUpdate();
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while creating axir_storage table!", (Throwable)exception);
        }
        String CREATE_TABLE6 = "CREATE TABLE IF NOT EXISTS axir_worlds (id INT NOT NULL AUTO_INCREMENT, name VARCHAR(255) NOT NULL, PRIMARY KEY (id), UNIQUE (name));";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt7 = conn.prepareStatement("CREATE TABLE IF NOT EXISTS axir_worlds (id INT NOT NULL AUTO_INCREMENT, name VARCHAR(255) NOT NULL, PRIMARY KEY (id), UNIQUE (name));");){
            stmt7.executeUpdate();
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while creating axir_worlds table!", (Throwable)exception);
        }
        String CREATE_INDEX1 = "CREATE INDEX idx_user ON axir_backups (userId);";
        try (Connection conn2 = this.getConnection();
             PreparedStatement stmt8 = conn2.prepareStatement("CREATE INDEX idx_user ON axir_backups (userId);");){
            stmt8.executeUpdate();
        }
        catch (SQLException conn2) {
            // empty catch block
        }
        String CREATE_INDEX2 = "CREATE INDEX idx_worldId ON axir_backups(worldId);";
        try (Connection conn3 = this.getConnection();
             PreparedStatement stmt9 = conn3.prepareStatement("CREATE INDEX idx_worldId ON axir_backups(worldId);");){
            stmt9.executeUpdate();
        }
        catch (SQLException conn3) {
            // empty catch block
        }
        String CREATE_INDEX3 = "CREATE INDEX idx_inventoryId ON axir_backups(inventoryId);";
        try (Connection conn4 = this.getConnection();){
            stmt = conn4.prepareStatement("CREATE INDEX idx_inventoryId ON axir_backups(inventoryId);");
            try {
                stmt.executeUpdate();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException conn4) {
            // empty catch block
        }
        String CREATE_INDEX4 = "CREATE INDEX idx_time ON axir_backups(time);";
        try (Connection conn5 = this.getConnection();
             PreparedStatement stmt10 = conn5.prepareStatement("CREATE INDEX idx_time ON axir_backups(time);");){
            stmt10.executeUpdate();
        }
        catch (SQLException conn5) {
            // empty catch block
        }
        try {
            if (SQLUtils.tableExists(this.getConnection(), "axinventoryrestore_data")) {
                new Converter2(this);
            }
        }
        catch (Exception exception) {
            log.error("An unexpected error occurred while running v2 converter!", (Throwable)exception);
        }
        try {
            stmt = this.getConnection().createStatement();
            try {
                String query = "SELECT * FROM axir_backups LIMIT 1";
                try (ResultSet rs = stmt.executeQuery(query);){
                    ResultSetMetaData rsmd = rs.getMetaData();
                    if (rsmd.getColumnName(8).equalsIgnoreCase("inventory")) {
                        new Converter3(this);
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (Exception exception) {
            log.error("An unexpected error occurred while running v3 converter!", (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Integer getUserId(@NotNull UUID uuid) {
        Integer userId = (Integer)this.uuidCache.inverse().get((Object)uuid);
        if (userId != null) {
            return userId;
        }
        String sql = "SELECT * FROM axir_users WHERE uuid = ? LIMIT 1;";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT * FROM axir_users WHERE uuid = ? LIMIT 1;");){
            stmt.setString(1, uuid.toString());
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return null;
                int id = rs.getInt(1);
                this.uuidCache.put((Object)id, (Object)uuid);
                Integer n = id;
                return n;
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while getting userid for user with uuid {}!", (Object)uuid, (Object)exception);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public UUID getUserUUID(int id) {
        UUID uid = (UUID)this.uuidCache.get((Object)id);
        if (uid != null) {
            return uid;
        }
        String sql = "SELECT * FROM axir_users WHERE id = ? LIMIT 1;";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT * FROM axir_users WHERE id = ? LIMIT 1;");){
            stmt.setInt(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return null;
                UUID uuid = UUID.fromString(rs.getString(2));
                this.uuidCache.put((Object)id, (Object)uuid);
                UUID uUID = uuid;
                return uUID;
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while getting userid for user with id {}!", (Object)id, (Object)exception);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public String getReasonName(int id) {
        String cachedReason = (String)this.reasonCache.get((Object)id);
        if (cachedReason != null) {
            return cachedReason;
        }
        String sql = "SELECT * FROM axir_reasons WHERE id = ? LIMIT 1;";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT * FROM axir_reasons WHERE id = ? LIMIT 1;");){
            stmt.setInt(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return null;
                String reason = rs.getString(2);
                this.reasonCache.put((Object)id, (Object)reason);
                String string = reason;
                return string;
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while getting reason from reason-id {}!", (Object)id, (Object)exception);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Integer getReasonId(@NotNull String reason) {
        Integer reasonId = (Integer)this.reasonCache.inverse().get((Object)reason);
        if (reasonId != null) {
            return reasonId;
        }
        String sql = "INSERT INTO axir_reasons(reason) VALUES (?);";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO axir_reasons(reason) VALUES (?);", 1);){
            stmt.setString(1, reason);
            stmt.executeUpdate();
            try (ResultSet rs = stmt.getGeneratedKeys();){
                if (!rs.next()) return null;
                int id = rs.getInt(1);
                this.reasonCache.put((Object)id, (Object)reason);
                Integer n = id;
                return n;
            }
        }
        catch (SQLException ex) {
            String sql2 = "SELECT * FROM axir_reasons WHERE reason = ? LIMIT 1;";
            try (Connection conn2 = this.getConnection();
                 PreparedStatement stmt2 = conn2.prepareStatement("SELECT * FROM axir_reasons WHERE reason = ? LIMIT 1;");){
                stmt2.setString(1, reason);
                try (ResultSet rs = stmt2.executeQuery();){
                    if (!rs.next()) return null;
                    int id = rs.getInt(1);
                    this.reasonCache.put((Object)id, (Object)reason);
                    Integer n = id;
                    return n;
                }
            }
            catch (SQLException exception) {
                log.error("An unexpected error occurred while getting reason-id for reason {}!", (Object)reason, (Object)exception);
            }
        }
        return null;
    }

    @Override
    public void saveInventory(@NotNull Player player, @NotNull String reason, @Nullable String cause) {
        this.saveInventory(player.getInventory().getContents(), player, reason, cause);
    }

    @Override
    public void saveInventory(ItemStack[] items, @NotNull Player player, @NotNull String reason, @Nullable String cause) {
        if (shutdown) {
            return;
        }
        if (AxirEvents.callInventoryBackupEvent(player, reason, cause)) {
            return;
        }
        boolean isEmpty = true;
        for (ItemStack it : items) {
            if (it == null || it.getType().isAir()) continue;
            isEmpty = false;
            break;
        }
        if (isEmpty) {
            return;
        }
        long time = System.currentTimeMillis();
        if (AxInventoryRestore.isDebugMode()) {
            LogUtils.debug("Creatig backup for {} [reason: {}] [cause: {}]", (Object)player.getName(), (Object)reason, (Object)cause);
        }
        String sql = "INSERT INTO axir_backups(userId, reasonId, worldId, x, y, z, inventoryId, time, cause) VALUES (?,?,?,?,?,?,?,?,?);";
        Location location = player.getLocation();
        AxInventoryRestore.getThreadedQueue().submit(() -> {
            byte[] bytes;
            if (AxInventoryRestore.isDebugMode()) {
                LogUtils.debug("ThreadedQueue submit for {} in {}ms", (Object)player.getName(), (Object)(System.currentTimeMillis() - time));
            }
            byte[] inventory = Serializers.ITEM_ARRAY.serialize(items);
            Integer userId = this.getUserId(player.getUniqueId());
            if (userId == null) {
                return;
            }
            Integer storedId = null;
            Integer backupId = this.getLastBackupInventoryId(userId);
            if (backupId != null && (bytes = this.getBytesFromBackup(backupId)) != null && Arrays.equals(inventory, bytes)) {
                storedId = backupId;
            }
            if (storedId == null) {
                storedId = this.storeItems(inventory);
            }
            try (Connection conn = this.getConnection();
                 PreparedStatement stmt = conn.prepareStatement("INSERT INTO axir_backups(userId, reasonId, worldId, x, y, z, inventoryId, time, cause) VALUES (?,?,?,?,?,?,?,?,?);");){
                stmt.setInt(1, userId);
                stmt.setInt(2, this.getReasonId(reason));
                stmt.setInt(3, this.storeWorld(location.getWorld().getName()));
                stmt.setInt(4, location.getBlockX());
                stmt.setInt(5, location.getBlockY());
                stmt.setInt(6, location.getBlockZ());
                stmt.setInt(7, storedId);
                stmt.setLong(8, System.currentTimeMillis());
                stmt.setString(9, cause);
                stmt.executeUpdate();
            }
            catch (Exception exception) {
                log.error("An unexpected error occurred while saving inventory of user {}!", (Object)player.getName(), (Object)exception);
            }
            if (AxInventoryRestore.isDebugMode()) {
                LogUtils.debug("Backup ready for {} in {}ms", (Object)player.getName(), (Object)(System.currentTimeMillis() - time));
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int storeItems(byte[] items) {
        String sql = "INSERT INTO axir_storage(inventory) VALUES (?);";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO axir_storage(inventory) VALUES (?);", 1);){
            stmt.setBytes(1, items);
            stmt.executeUpdate();
            try (ResultSet rs = stmt.getGeneratedKeys();){
                if (!rs.next()) throw new RuntimeException("Failed to save inventory!");
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while storing items!", (Throwable)exception);
        }
        throw new RuntimeException("Failed to save inventory!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int storeWorld(String world) {
        Integer worldId = (Integer)this.worldCache.inverse().get((Object)world);
        if (worldId != null) {
            return worldId;
        }
        String sql0 = "SELECT id FROM axir_worlds WHERE name = ? LIMIT 1";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT id FROM axir_worlds WHERE name = ? LIMIT 1");){
            stmt.setString(1, world);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    int n = rs.getInt(1);
                    return n;
                }
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while storing world {}!", (Object)world, (Object)exception);
        }
        String sql = "INSERT INTO axir_worlds(name) VALUES (?);";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO axir_worlds(name) VALUES (?);", 1);){
            stmt.setString(1, world);
            stmt.executeUpdate();
            try (ResultSet rs = stmt.getGeneratedKeys();){
                if (!rs.next()) throw new RuntimeException("Failed to save world!");
                int id = rs.getInt(1);
                this.worldCache.put((Object)id, (Object)world);
                int n = id;
                return n;
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while storing world {}!", (Object)world, (Object)exception);
        }
        throw new RuntimeException("Failed to save world!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public World getWorld(int id) {
        String worldName = (String)this.worldCache.get((Object)id);
        if (worldName != null) {
            return Bukkit.getWorld((String)worldName);
        }
        String sql = "SELECT name FROM axir_worlds WHERE id = ? LIMIT 1;";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT name FROM axir_worlds WHERE id = ? LIMIT 1;");){
            stmt.setInt(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return null;
                String name = rs.getString(1);
                World world = Bukkit.getWorld((String)name);
                this.worldCache.put((Object)id, (Object)name);
                World world2 = world;
                return world2;
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while getting world with id {}!", (Object)id, (Object)exception);
        }
        return null;
    }

    @Override
    public Backup getBackupsOfPlayer(@NotNull UUID uuid) {
        ArrayList<BackupData> backups = new ArrayList<BackupData>();
        String sql = "SELECT id, reasonid, worldId, x, y, z, time, cause, inventoryId FROM axir_backups WHERE userId = ?;";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT id, reasonid, worldId, x, y, z, time, cause, inventoryId FROM axir_backups WHERE userId = ?;");){
            stmt.setInt(1, this.getUserId(uuid));
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    World world = this.getWorld(rs.getInt(3));
                    if (world == null) continue;
                    backups.add(new BackupData(rs.getInt(1), uuid, this.getReasonName(rs.getInt(2)), new Location(world, (double)rs.getInt(4), (double)rs.getInt(5), (double)rs.getInt(6)), rs.getLong(7), rs.getString(8), rs.getInt(9)));
                }
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while getting backups of player {}!", (Object)uuid, (Object)exception);
        }
        Collections.reverse(backups);
        return new Backup(backups);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Integer getLastBackupInventoryId(int userId) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT inventoryId FROM axir_backups WHERE userId = ? ORDER BY id DESC LIMIT 1;");){
            statement.setInt(1, userId);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                Integer n = resultSet.getInt("inventoryId");
                return n;
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while getting last backup id for usre {}!", (Object)userId, (Object)exception);
        }
        return null;
    }

    @Override
    public void join(@NotNull Player player) {
        String sql = "INSERT INTO axir_users(uuid, name) VALUES (?,?);";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO axir_users(uuid, name) VALUES (?,?);", 1);){
            stmt.setString(1, player.getUniqueId().toString());
            stmt.setString(2, player.getName());
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            String sql2 = "UPDATE axir_users SET name = ? WHERE uuid = ?;";
            try (Connection conn2 = this.getConnection();
                 PreparedStatement stmt2 = conn2.prepareStatement("UPDATE axir_users SET name = ? WHERE uuid = ?;");){
                stmt2.setString(1, player.getName());
                stmt2.setString(2, player.getUniqueId().toString());
                stmt2.executeUpdate();
            }
            catch (SQLException exception) {
                log.error("An unexpected error occurred while updating the name of {}!", (Object)player.getName(), (Object)exception);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UUID getUUID(@NotNull String name) {
        String ex = "SELECT uuid FROM axir_users WHERE name = ? LIMIT 1;";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(ex);){
            stmt.setString(1, name);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return null;
                UUID uUID = UUID.fromString(rs.getString(1));
                return uUID;
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while getting the uuid of {}!", (Object)name, (Object)exception);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int addRestoreRequest(int backupId) {
        String sql = "INSERT INTO axir_restorerequests(backupId, granted) VALUES (?, false);";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO axir_restorerequests(backupId, granted) VALUES (?, false);", 1);){
            stmt.setInt(1, backupId);
            stmt.executeUpdate();
            try (ResultSet rs = stmt.getGeneratedKeys();){
                if (!rs.next()) return -1;
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while adding restore request!", (Throwable)exception);
        }
        return -1;
    }

    @Override
    public void grantRestoreRequest(int restoreId) {
        String sql = "UPDATE axir_restorerequests SET granted = true WHERE id = ?;";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("UPDATE axir_restorerequests SET granted = true WHERE id = ?;");){
            stmt.setInt(1, restoreId);
            stmt.executeUpdate();
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while granting restore request with id {}!", (Object)restoreId, (Object)exception);
        }
        String sql2 = "SELECT uuid FROM axir_users WHERE id = (SELECT userId FROM axir_backups WHERE id = (SELECT backupId FROM axir_restorerequests WHERE id = ? LIMIT 1) LIMIT 1);";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT uuid FROM axir_users WHERE id = (SELECT userId FROM axir_backups WHERE id = (SELECT backupId FROM axir_restorerequests WHERE id = ? LIMIT 1) LIMIT 1);");){
            stmt.setInt(1, restoreId);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    this.fetchRestoreRequests(UUID.fromString(rs.getString(1)));
                }
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while granting restore request with id {}!", (Object)restoreId, (Object)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BackupData getBackupDataById(int backupId) {
        String sql = "SELECT id, userid, reasonid, worldId, x, y, z, time, cause, inventoryId FROM axir_backups WHERE id = ? LIMIT 1;";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT id, userid, reasonid, worldId, x, y, z, time, cause, inventoryId FROM axir_backups WHERE id = ? LIMIT 1;");){
            stmt.setInt(1, backupId);
            try (ResultSet rs = stmt.executeQuery();){
                World world;
                do {
                    if (!rs.next()) return null;
                } while ((world = this.getWorld(rs.getInt(4))) == null);
                BackupData backupData = new BackupData(rs.getInt(1), this.getUserUUID(rs.getInt(2)), this.getReasonName(rs.getInt(3)), new Location(world, (double)rs.getInt(5), (double)rs.getInt(6), (double)rs.getInt(7)), rs.getLong(8), rs.getString(9), rs.getInt(10));
                return backupData;
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while getting backup data by id {}!", (Object)backupId, (Object)exception);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytesFromBackup(int backupId) {
        String sql = "SELECT inventory FROM axir_storage WHERE id = ? LIMIT 1;";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT inventory FROM axir_storage WHERE id = ? LIMIT 1;");){
            stmt.setInt(1, backupId);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return null;
                byte[] byArray = rs.getBytes(1);
                return byArray;
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while getting items from backup by id {}!", (Object)backupId, (Object)exception);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ItemStack[] getItemsFromBackup(int backupId) {
        String sql = "SELECT inventory FROM axir_storage WHERE id = ? LIMIT 1;";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT inventory FROM axir_storage WHERE id = ? LIMIT 1;");){
            stmt.setInt(1, backupId);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return null;
                ItemStack[] itemStackArray = Serializers.ITEM_ARRAY.deserialize(rs.getBytes(1));
                return itemStackArray;
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while getting items from backup by id {}!", (Object)backupId, (Object)exception);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getSaves(UUID uuid, @Nullable String reason) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removeLastSaves(UUID uuid, @Nullable String reason, int amount) {
        String noReason = "SELECT id FROM axir_backups WHERE userId = ? ORDER BY time ASC LIMIT ?;";
        String withReason = "SELECT id FROM axir_backups WHERE userId = ? AND reasonId = ? ORDER BY time ASC LIMIT ?;";
        try (Connection connection = this.getConnection();
             PreparedStatement stmt = connection.prepareStatement(reason == null ? "SELECT id FROM axir_backups WHERE userId = ? ORDER BY time ASC LIMIT ?;" : "SELECT id FROM axir_backups WHERE userId = ? AND reasonId = ? ORDER BY time ASC LIMIT ?;");){
            stmt.setInt(1, this.getUserId(uuid));
            if (reason == null) {
                stmt.setInt(2, amount);
            } else {
                stmt.setInt(2, this.getReasonId(reason));
                stmt.setInt(3, amount);
            }
            ArrayList<CallSite> ids = new ArrayList<CallSite>();
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    ids.add((CallSite)((Object)("" + rs.getInt(1))));
                }
            }
            if (ids.isEmpty()) {
                return;
            }
            String delete = "DELETE FROM axir_backups WHERE id IN (" + String.join((CharSequence)",", ids) + ");";
            try (PreparedStatement stmt2 = connection.prepareStatement(delete);){
                stmt2.executeUpdate();
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while removing last save for {}!", (Object)uuid, (Object)exception);
        }
        this.clean();
    }

    private void clean() {
        if (System.currentTimeMillis() < this.nextClear) {
            return;
        }
        if (this.cleaning.get()) {
            return;
        }
        this.nextClear = System.currentTimeMillis() + Duration.ofMinutes(30L).toMillis();
        this.cleaning.set(true);
        String sql2 = "DELETE FROM axir_storage WHERE id not IN (SELECT inventoryId FROM axir_backups WHERE inventoryId IS NOT NULL);";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("DELETE FROM axir_storage WHERE id not IN (SELECT inventoryId FROM axir_backups WHERE inventoryId IS NOT NULL);");){
            stmt.executeUpdate();
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while cleaning up!", (Throwable)exception);
        }
        this.cleaning.set(false);
    }

    @Override
    public void fetchRestoreRequests(@NotNull UUID uuid) {
        if (AxInventoryRestore.getDiscordAddon() == null) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return;
        }
        String sql = "SELECT * FROM axir_restorerequests WHERE granted AND backupId IN (SELECT id FROM axir_backups WHERE userId = (SELECT id FROM axir_users WHERE uuid = ? LIMIT 1));";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT * FROM axir_restorerequests WHERE granted AND backupId IN (SELECT id FROM axir_backups WHERE userId = (SELECT id FROM axir_users WHERE uuid = ? LIMIT 1));");){
            stmt.setString(1, uuid.toString());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    BackupData backupData = this.getBackupDataById(rs.getInt(2));
                    backupData.getInShulkers("---").thenAccept(items -> Scheduler.get().run(scheduledTask -> ContainerUtils.INSTANCE.addOrDrop((Inventory)player.getInventory(), (List<ItemStack>)items, player.getLocation())));
                    player.sendMessage(StringUtils.formatToString(AxInventoryRestore.CONFIG.getString("prefix") + AxInventoryRestore.DISCORD.getString("messages.restored"), new TagResolver[0]));
                    int id = rs.getInt(1);
                    this.removeRestoreRequest(id);
                }
            }
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while fetching restore request for user with uuid {}!", (Object)uuid, (Object)exception);
        }
    }

    @Override
    public void removeRestoreRequest(int restoreId) {
        String ex = "DELETE FROM axir_restorerequests WHERE id = ?;";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("DELETE FROM axir_restorerequests WHERE id = ?;");){
            stmt.setInt(1, restoreId);
            stmt.executeUpdate();
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while removing restore request!", (Throwable)exception);
        }
    }

    @Override
    public void cleanup() {
        String sql = "DELETE FROM axir_backups WHERE time < ?;";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("DELETE FROM axir_backups WHERE time < ?;");){
            stmt.setLong(1, System.currentTimeMillis() - 86400000L * AxInventoryRestore.CONFIG.getLong("cleanup-after-days"));
            stmt.executeUpdate();
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while cleaning up!", (Throwable)exception);
        }
        String sql2 = "DELETE FROM axir_storage WHERE NOT EXISTS (SELECT 1 FROM axir_backups WHERE axir_backups.inventoryId = axir_storage.id);";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("DELETE FROM axir_storage WHERE NOT EXISTS (SELECT 1 FROM axir_backups WHERE axir_backups.inventoryId = axir_storage.id);");){
            stmt.executeUpdate();
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while cleaning up!", (Throwable)exception);
        }
        String sql3 = "DELETE FROM axir_worlds WHERE NOT EXISTS (SELECT 1 FROM axir_backups WHERE axir_backups.worldId = axir_worlds.id);";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("DELETE FROM axir_worlds WHERE NOT EXISTS (SELECT 1 FROM axir_backups WHERE axir_backups.worldId = axir_worlds.id);");){
            stmt.executeUpdate();
        }
        catch (SQLException exception) {
            log.error("An unexpected error occurred while cleaning up!", (Throwable)exception);
        }
    }

    @Override
    public void disable() {
        shutdown = true;
    }
}

