/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.database.impl;

import com.artillexstudios.axinventoryrestore.AxInventoryRestore;
import com.artillexstudios.axinventoryrestore.database.impl.Base;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.h2.jdbc.JdbcConnection;

public class H2
extends Base {
    private H2Connection conn;

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public String getType() {
        return "H2";
    }

    @Override
    public void setup() {
        try {
            this.conn = new H2Connection("jdbc:h2:./" + String.valueOf(AxInventoryRestore.getInstance().getDataFolder()) + "/data;mode=MySQL", new Properties(), null, null, false);
            this.conn.setAutoCommit(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.setup();
    }

    @Override
    public void disable() {
        super.disable();
        String sql = "SHUTDOWN COMPACT;";
        try (PreparedStatement stmt = this.conn.prepareStatement("SHUTDOWN COMPACT;");){
            if (AxInventoryRestore.CONFIG.getBoolean("compact-database", true)) {
                stmt.executeUpdate();
            }
            this.conn.realClose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class H2Connection
    extends JdbcConnection {
        public H2Connection(String s, Properties properties, String s1, Object o, boolean b) throws SQLException {
            super(s, properties, s1, o, b);
        }

        public synchronized void close() {
        }

        public synchronized void realClose() throws SQLException {
            super.close();
        }
    }
}

