/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.database.impl;

import com.artillexstudios.axinventoryrestore.AxInventoryRestore;
import com.artillexstudios.axinventoryrestore.database.impl.Base;
import com.artillexstudios.axinventoryrestore.libs.hikari.HikariConfig;
import com.artillexstudios.axinventoryrestore.libs.hikari.HikariDataSource;
import java.sql.Connection;

public class MySQL
extends Base {
    private HikariDataSource dataSource;

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String getType() {
        return "MySQL";
    }

    @Override
    public void setup() {
        HikariConfig hConfig = new HikariConfig();
        hConfig.setPoolName("axinventoryrestore-pool");
        hConfig.setMaximumPoolSize(AxInventoryRestore.CONFIG.getInt("database.pool.maximum-pool-size"));
        hConfig.setMinimumIdle(AxInventoryRestore.CONFIG.getInt("database.pool.minimum-idle"));
        hConfig.setMaxLifetime((long)AxInventoryRestore.CONFIG.getInt("database.pool.maximum-lifetime"));
        hConfig.setKeepaliveTime((long)AxInventoryRestore.CONFIG.getInt("database.pool.keepalive-time"));
        hConfig.setConnectionTimeout((long)AxInventoryRestore.CONFIG.getInt("database.pool.connection-timeout"));
        hConfig.setDriverClassName("com.artillexstudios.axinventoryrestore.libs.mysql.cj.jdbc.Driver");
        hConfig.setJdbcUrl("jdbc:mysql://" + AxInventoryRestore.CONFIG.getString("database.address") + ":" + AxInventoryRestore.CONFIG.getString("database.port") + "/" + AxInventoryRestore.CONFIG.getString("database.database"));
        hConfig.addDataSourceProperty("user", (Object)AxInventoryRestore.CONFIG.getString("database.username"));
        hConfig.addDataSourceProperty("password", (Object)AxInventoryRestore.CONFIG.getString("database.password"));
        this.dataSource = new HikariDataSource(hConfig);
        super.setup();
    }

    @Override
    public void disable() {
        super.disable();
        try {
            this.dataSource.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

