/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.discord;

import com.artillexstudios.axinventoryrestore.AxInventoryRestore;
import com.artillexstudios.axinventoryrestore.backups.BackupData;
import com.artillexstudios.axinventoryrestore.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.StringUtils;
import com.artillexstudios.axinventoryrestore.utils.DateUtils;
import com.artillexstudios.axinventoryrestore.utils.JDAEmbedBuilder;
import com.artillexstudios.axinventoryrestore.utils.LocationUtils;
import java.util.HashMap;
import java.util.UUID;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.context.ImmutableContextSet;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;

public class DiscordAddon
extends ListenerAdapter {
    private JDA jda = null;

    public DiscordAddon() {
        if (AxInventoryRestore.DISCORD.getString("token").isBlank()) {
            return;
        }
        JDABuilder jdaBuilder = JDABuilder.createDefault((String)AxInventoryRestore.DISCORD.getString("token"));
        jdaBuilder.setActivity(Activity.playing((String)AxInventoryRestore.DISCORD.getString("bot-activity", " ")));
        this.jda = jdaBuilder.build();
        try {
            this.jda.awaitReady();
            this.jda.addEventListener(new Object[]{this});
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#00FF00[AxInventoryRestore] Loaded discord module!", new TagResolver[0]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sendRequest(Player requester, BackupData backupData) {
        LuckPerms api;
        ImmutableContextSet set;
        RegisteredServiceProvider provider;
        TextChannel channel = this.jda.getTextChannelById(AxInventoryRestore.DISCORD.getString("channel-id"));
        if (channel == null) {
            Bukkit.getLogger().warning("Discord channel with id " + AxInventoryRestore.DISCORD.getString("channel-id") + " was not found!");
            return;
        }
        int id = AxInventoryRestore.getDatabase().addRestoreRequest(backupData.getId());
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("%player%", Bukkit.getOfflinePlayer((UUID)backupData.getPlayerUUID()).getName());
        replacements.put("%requester%", requester.getName());
        replacements.put("%date%", DateUtils.formatDate(backupData.getDate()));
        replacements.put("%category%", AxInventoryRestore.MESSAGES.getString("categories." + backupData.getReason() + ".raw", "---"));
        replacements.put("%cause%", backupData.getCause() == null ? "---" : backupData.getCause());
        replacements.put("%location%", LocationUtils.serializeLocationReadable(backupData.getLocation()));
        if (ClassUtils.INSTANCE.classExists("net.luckperms.api.LuckPerms") && (provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class)) != null && (set = (api = (LuckPerms)provider.getProvider()).getContextManager().getStaticContext()).getAnyValue("server").isPresent()) {
            String str = (String)set.getAnyValue("server").get();
            replacements.put("%server%", str);
        }
        MessageCreateAction action = channel.sendMessageEmbeds(new JDAEmbedBuilder(AxInventoryRestore.DISCORD.getSection("prompt"), replacements).get(), new MessageEmbed[0]);
        ((MessageCreateAction)action.addActionRow(new ItemComponent[]{Button.success((String)("axir-accept:" + id), (String)AxInventoryRestore.DISCORD.getString("messages.restore")), Button.danger((String)("axir-deny:" + id), (String)AxInventoryRestore.DISCORD.getString("messages.decline"))})).queue(message -> {
            if (!AxInventoryRestore.DISCORD.getBoolean("create-thread", true)) {
                return;
            }
            channel.createThreadChannel(AxInventoryRestore.DISCORD.getString("thread-name", "-"), message.getId()).queue();
        });
    }

    public ItemStack getRequestItem() {
        return ItemBuilder.create(AxInventoryRestore.DISCORD.getSection("request-restore")).get();
    }

    public void onButtonInteraction(@NotNull ButtonInteractionEvent event) {
        String status;
        if (event.getComponentId().startsWith("axir-accept")) {
            status = "accepted";
            AxInventoryRestore.getDatabase().grantRestoreRequest(Integer.parseInt(event.getComponentId().split(":")[1]));
        } else if (event.getComponentId().startsWith("axir-deny")) {
            status = "declined";
            AxInventoryRestore.getDatabase().removeRestoreRequest(Integer.parseInt(event.getComponentId().split(":")[1]));
        } else {
            return;
        }
        if (event.getMember() == null) {
            event.reply("Something went wrong! member = null").setEphemeral(true).queue();
            return;
        }
        if (!event.getMember().hasPermission(new Permission[]{Permission.valueOf((String)AxInventoryRestore.DISCORD.getString("required-permission", "ADMINISTRATOR"))})) {
            event.reply(AxInventoryRestore.DISCORD.getString("messages.no-permission")).setEphemeral(true).queue();
            return;
        }
        try {
            event.deferReply().queue(interactionHook -> {
                MessageEmbed embed = (MessageEmbed)event.getMessage().getEmbeds().get(0);
                event.getMessage().editMessageEmbeds(new MessageEmbed[]{EmbedBuilder.fromData((DataObject)embed.toData()).setAuthor(event.getUser().getName(), null, event.getUser().getAvatarUrl()).setColor(Integer.parseInt(AxInventoryRestore.DISCORD.getString("messages." + status + "-color").replace("#", ""), 16)).build()}).queue();
                event.getMessage().editMessageComponents(new LayoutComponent[0]).queue();
                interactionHook.sendMessage(AxInventoryRestore.DISCORD.getString("messages." + status)).setEphemeral(true).queue();
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

