/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.libs.axapi.libs.yamlassist;

import com.artillexstudios.axinventoryrestore.libs.axapi.libs.snakeyaml.error.YAMLException;
import java.util.List;

public abstract class SyntaxError {
    public abstract List<String> getSuggestions(YAMLException var1, List<String> var2);

    protected String removeIndent(String line) {
        String replaced = line;
        while (replaced.startsWith(" ") || replaced.startsWith("\t")) {
            replaced = replaced.substring(1);
        }
        while (replaced.endsWith(" ") || replaced.endsWith("\t")) {
            replaced = replaced.substring(0, replaced.length() - 1);
        }
        return replaced;
    }

    protected int getIndentCount(String line) {
        if (line.split("#")[0].replace(" ", "").isEmpty()) {
            return 0;
        }
        int index = 0;
        int spaces = 0;
        while (line.length() > index && (line.charAt(index) == ' ' || line.charAt(index) == '\t')) {
            if (line.charAt(index) == ' ') {
                ++index;
                ++spaces;
                continue;
            }
            ++index;
            spaces += 4;
        }
        return spaces;
    }

    protected String getValue(String line) {
        String value = this.removeIndent(line);
        if (value.startsWith("- ")) {
            value = value.substring(2);
        } else if (value.contains(": ")) {
            value = value.substring(value.split(": ")[0].length() + 2);
        } else {
            for (String c2 : new String[]{"'", "\""}) {
                if (!value.startsWith(c2)) continue;
                value = value.substring(1);
                int index = value.indexOf(c2) + 2;
                if (value.length() < index || (value = value.substring(index)).isEmpty()) continue;
                value = value.substring(1);
            }
        }
        return this.removeEndLineComments(value);
    }

    protected String removeEndLineComments(String line) {
        StringBuilder sb = new StringBuilder();
        boolean insideQuotes = false;
        char quoteChar = '\u0000';
        for (int i = 0; i < line.length(); ++i) {
            char c2 = line.charAt(i);
            if (c2 == '\"' || c2 == '\'') {
                if (i == 0) {
                    insideQuotes = true;
                    quoteChar = c2;
                } else if (quoteChar == c2) {
                    insideQuotes = false;
                }
            }
            if (c2 == '#' && !insideQuotes && (quoteChar != '\u0000' || sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ')) {
                while (sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
                    sb.setLength(sb.length() - 1);
                }
                return sb.toString();
            }
            sb.append(c2);
        }
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

