/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.yo_hooks.network;

import com.yori3o.yo_hooks.config.ServerConfig;
import com.yori3o.yo_hooks.entity.HookEntity;
import com.yori3o.yo_hooks.utils.PlayerWithHookData;
import dev.architectury.networking.NetworkManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class JumpServerPacket {
    static ServerConfig sc = new ServerConfig();
    private static final boolean isJumpAllowed_onConfig = ((ServerConfig.Values)JumpServerPacket.sc.get()).isJumpAllowed;
    private static final float decreaseSatiety = ((ServerConfig.Values)JumpServerPacket.sc.get()).decreaseSatiety;

    public static void registerPackets() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)new ResourceLocation("yo_hooks", "player_jumped_from_hook"), (buf, context) -> {
            Player player = context.getPlayer();
            PlayerWithHookData hookDataPlayer = (PlayerWithHookData)player;
            if (hookDataPlayer == null) {
                return;
            }
            context.queue(() -> {
                HookEntity hook = hookDataPlayer.getHook();
                Boolean allowed = hookDataPlayer.isResetFallDistance();
                if (hook != null && hook.isInBlock() && allowed.booleanValue() && isJumpAllowed_onConfig) {
                    context.getPlayer().getFoodData().addExhaustion(decreaseSatiety / 3.0f);
                    Level world = player.level();
                    hook.discard();
                    JumpServerPacket.applyJumpImpulse(context.getPlayer());
                    world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
                }
            });
        });
    }

    public static void applyJumpImpulse(Player player) {
        double FORWARD_VELOCITY = 0.62;
        double UPWARD_VELOCITY = 0.42;
        Vec3 lookVector = player.getLookAngle();
        Vec3 currentMotion = player.getDeltaMovement();
        double newX = lookVector.x * 0.62;
        double newZ = lookVector.z * 0.62;
        double newY = Math.max(currentMotion.y, 0.42);
        player.setDeltaMovement(newX, newY, newZ);
        player.hurtMarked = true;
        player.resetFallDistance();
    }
}

