/*
 * Decompiled with CFR 0.152.
 */
package net.mokus.mokuslibs.item.Cooldown;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.mokus.mokuslibs.network.ServerNetworkHandler;

public class CooldownManagerServer {
    private static final Map<UUID, Map<class_1792, Integer>> playerCooldowns = new HashMap<UUID, Map<class_1792, Integer>>();

    public static int getCooldown(class_3222 player, class_1792 item) {
        return ((Map)playerCooldowns.getOrDefault(player.method_5667(), new HashMap())).getOrDefault(item, 0);
    }

    public static boolean tryAddCooldown(class_3222 player, class_1792 item, int amount, int max) {
        playerCooldowns.putIfAbsent(player.method_5667(), new HashMap());
        Map<class_1792, Integer> itemCooldowns = playerCooldowns.get(player.method_5667());
        int current = itemCooldowns.getOrDefault(item, 0);
        if (current >= max) {
            return false;
        }
        itemCooldowns.put(item, Math.min(current + amount, max));
        CooldownManagerServer.syncToClient(player, item);
        return true;
    }

    public static void tick() {
        for (Map<class_1792, Integer> itemCooldowns : playerCooldowns.values()) {
            itemCooldowns.replaceAll((item, cd) -> Math.max(cd - 1, 0));
        }
    }

    private static void syncToClient(class_3222 player, class_1792 item) {
        int cooldown = CooldownManagerServer.getCooldown(player, item);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10812(class_7923.field_41178.method_10221((Object)item));
        buf.writeInt(cooldown);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ServerNetworkHandler.COOLDOWN_SYNC_PACKET, (class_2540)buf);
    }
}

