/*
 * Decompiled with CFR 0.152.
 */
package net.mokus.mokuslibs.mixin.skineffect;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1007;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.mokus.mokuslibs.mixin.skineffect.BipedEntityModelAccessor;
import net.mokus.mokuslibs.mixin.skineffect.LivingEntityRendererMixin;
import net.mokus.mokuslibs.network.SkinEffectClientTracker;
import net.mokus.mokuslibs.skineffect.SkinEffect;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1007.class})
public abstract class SkinEffectPlayerEntityRendererMixin
extends LivingEntityRendererMixin<class_742, class_591<class_742>> {
    @Redirect(method={"renderArm"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/network/AbstractClientPlayerEntity;getSkinTexture()Lnet/minecraft/util/Identifier;"))
    private class_2960 mokuslibs$armSkin(class_742 player) {
        return SkinEffectPlayerEntityRendererMixin.getEffectiveSkin(player);
    }

    @Unique
    private static class_2960 getEffectiveSkin(class_742 player) {
        class_2960 trackedSkin = SkinEffectClientTracker.getPlayerSkin(player);
        if (trackedSkin != null) {
            return trackedSkin;
        }
        for (class_1293 instance : player.method_6026()) {
            class_1291 effect = instance.method_5579();
            if (!(effect instanceof SkinEffect)) continue;
            SkinEffect skinEffect = (SkinEffect)effect;
            return skinEffect.getSkinOverride(player);
        }
        return player.method_3117();
    }

    @Override
    protected boolean mokuslibs$overrideModelRender(@Nullable class_742 player, class_4587 matrices, int light, int overlay, float red, float green, float blue, float alpha, float yaw, float tickDelta, class_4587 stack, class_4597 vertexConsumers) {
        if (player == null || !SkinEffectClientTracker.hasOverlay(player)) {
            return true;
        }
        boolean showBody = !player.method_5767();
        boolean translucent = !showBody;
        boolean showOutline = class_310.method_1551().method_27022((class_1297)player);
        class_1921 bodyLayer = this.method_24302(player, showBody, translucent, showOutline);
        class_1921 overlayLayer = this.getSkinRenderLayer(player, showBody, translucent, showOutline);
        if (bodyLayer != null && overlayLayer != null) {
            class_4588 bodyVertices = vertexConsumers.getBuffer(bodyLayer);
            ((class_591)this.method_4038()).field_3398.method_22699(matrices, bodyVertices, light, overlay, red, green, blue, alpha);
            ((class_591)this.method_4038()).field_3394.method_22699(matrices, bodyVertices, light, overlay, red, green, blue, alpha);
            class_4588 overlayVertices = vertexConsumers.getBuffer(overlayLayer);
            for (class_630 part : ((BipedEntityModelAccessor)this.method_4038()).mokuslibs$getBodyParts()) {
                this.renderBodyPart(part, matrices, overlayVertices, light, overlay, red, green, blue, alpha);
                ((class_591)this.method_4038()).field_3391.method_22699(matrices, overlayVertices, light, overlay, red, green, blue, alpha);
            }
            return false;
        }
        return true;
    }

    @Unique
    protected void renderBodyPart(class_630 part, class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!part.equals(((class_591)this.method_4038()).field_3391)) {
            part.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    @Unique
    @Nullable
    protected class_1921 getSkinRenderLayer(class_742 player, boolean showBody, boolean translucent, boolean showOutline) {
        class_2960 texture = SkinEffectPlayerEntityRendererMixin.getEffectiveSkin(player);
        if (translucent) {
            return class_1921.method_23580((class_2960)texture);
        }
        if (showBody) {
            return ((class_591)this.method_4038()).method_23500(texture);
        }
        return showOutline ? class_1921.method_23287((class_2960)texture) : null;
    }
}

