/*
 * Decompiled with CFR 0.152.
 */
package net.mokus.mokuslibs.components;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.mokus.mokuslibs.components.ModComponents;

public class CooldownComponent
implements CommonTickingComponent,
AutoSyncedComponent {
    private final class_1657 player;
    private final Map<class_1792, SemiCooldownData> cooldowns = new HashMap<class_1792, SemiCooldownData>();

    public CooldownComponent(class_1657 player) {
        this.player = player;
    }

    public void addCooldown(class_1792 item, int addedCooldown, int maxCooldown) {
        SemiCooldownData data = this.cooldowns.get(item);
        if (data != null) {
            data.currentCooldown = Math.min(data.currentCooldown + addedCooldown, maxCooldown);
            data.maxCooldown = maxCooldown;
            data.addedCooldown = addedCooldown;
        } else {
            this.cooldowns.put(item, new SemiCooldownData(addedCooldown, maxCooldown, addedCooldown));
        }
    }

    public int getCurrentCooldown(class_1792 item) {
        SemiCooldownData data = this.cooldowns.get(item);
        return data != null ? data.currentCooldown : 0;
    }

    public int getMaxCooldown(class_1792 item) {
        SemiCooldownData data = this.cooldowns.get(item);
        return data != null ? data.maxCooldown : 0;
    }

    public boolean canUse(class_1792 item) {
        SemiCooldownData data = this.cooldowns.get(item);
        if (data == null) {
            return true;
        }
        return data.currentCooldown <= data.maxCooldown + 10 - data.addedCooldown;
    }

    public void readFromNbt(class_2487 nbt) {
        this.cooldowns.clear();
        if (nbt.method_10573("Cooldowns", 9)) {
            class_2499 list = nbt.method_10554("Cooldowns", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 entry = list.method_10602(i);
                class_2960 itemId = class_2960.method_12829((String)entry.method_10558("Item"));
                if (itemId == null || !class_7923.field_41178.method_10250(itemId)) continue;
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
                int current = entry.method_10550("Current");
                int max = entry.method_10550("Max");
                int added = entry.method_10550("Added");
                this.cooldowns.put(item, new SemiCooldownData(current, max, added));
            }
        }
    }

    public void writeToNbt(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (Map.Entry<class_1792, SemiCooldownData> entry : this.cooldowns.entrySet()) {
            class_2487 itemNbt = new class_2487();
            class_2960 itemId = class_7923.field_41178.method_10221((Object)entry.getKey());
            SemiCooldownData data = entry.getValue();
            itemNbt.method_10582("Item", itemId.toString());
            itemNbt.method_10569("Current", data.currentCooldown);
            itemNbt.method_10569("Max", data.maxCooldown);
            itemNbt.method_10569("Added", data.addedCooldown);
            list.add((Object)itemNbt);
        }
        nbt.method_10566("Cooldowns", (class_2520)list);
    }

    public void tick() {
        this.cooldowns.entrySet().removeIf(entry -> {
            SemiCooldownData data = (SemiCooldownData)entry.getValue();
            data.currentCooldown = Math.max(data.currentCooldown - 1, 0);
            ModComponents.MOKUS_COOLDOWN.sync((Object)this.player);
            return data.currentCooldown == 0;
        });
    }

    public static class SemiCooldownData {
        public int currentCooldown;
        public int maxCooldown;
        public int addedCooldown;

        public SemiCooldownData(int currentCooldown, int maxCooldown, int addedCooldown) {
            this.currentCooldown = currentCooldown;
            this.maxCooldown = maxCooldown;
            this.addedCooldown = addedCooldown;
        }
    }
}

