/*
 * Decompiled with CFR 0.152.
 */
package net.multyfora.mib2.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/mib2.json");
    public int logoRegionHeight = 64;
    public int logoRegionWidth = 256;
    private static ModConfig INSTANCE;

    public static ModConfig get() {
        if (INSTANCE == null) {
            ModConfig.load();
        }
        return INSTANCE;
    }

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            INSTANCE = new ModConfig();
            ModConfig.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            INSTANCE = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            INSTANCE = new ModConfig();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

