/*
 * Decompiled with CFR 0.152.
 */
package sircow.preservedinferno;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import sircow.preservedinferno.CommonClass;
import sircow.preservedinferno.Constants;
import sircow.preservedinferno.MenuTypes;
import sircow.preservedinferno.block.FabricModBlocks;
import sircow.preservedinferno.block.entity.PreservedCauldronBlockData;
import sircow.preservedinferno.block.entity.PreservedCauldronBlockEntity;
import sircow.preservedinferno.item.FabricModItemGroups;
import sircow.preservedinferno.item.FabricModItems;
import sircow.preservedinferno.other.DelayedBlockTransformationTask;
import sircow.preservedinferno.other.FabricModEvents;
import sircow.preservedinferno.other.OpenAdvancementPayload;
import sircow.preservedinferno.other.ShieldStaminaHandler;
import sircow.preservedinferno.screen.AnglingTableMenu;
import sircow.preservedinferno.screen.CacheMenu;
import sircow.preservedinferno.screen.PreservedCauldronMenu;
import sircow.preservedinferno.screen.PreservedEnchantmentMenu;
import sircow.preservedinferno.screen.PreservedFletchingTableMenu;
import sircow.preservedinferno.screen.PreservedLoomMenu;

public class PreservedInferno
implements ModInitializer {
    private static final List<DelayedBlockTransformationTask> scheduledTasks = new ArrayList<DelayedBlockTransformationTask>();
    public static PreservedInferno INSTANCE;
    private static final class_3917<AnglingTableMenu> ANGLING_TABLE_MENU_TYPE;
    public static final class_3917<PreservedCauldronMenu> PRESERVED_CAULDRON_MENU_TYPE;
    public static final class_3917<PreservedFletchingTableMenu> PRESERVED_FLETCHING_TABLE_MENU_TYPE;
    private static final class_3917<PreservedLoomMenu> PRESERVED_LOOM_MENU_TYPE;
    private static final class_3917<PreservedEnchantmentMenu> PRESERVED_ENCHANT_MENU_TYPE;
    private static final class_3917<CacheMenu> CACHE_MENU_TYPE;
    public static final class_2591<PreservedCauldronBlockEntity> PRESERVED_CAULDRON_BLOCK_ENTITY;

    public static <T extends class_2591<?>> T register(String path, T blockEntityType) {
        return (T)((class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)Constants.id(path), blockEntityType));
    }

    public static void scheduleDelayedTask(DelayedBlockTransformationTask task) {
        scheduledTasks.add(task);
    }

    public static void cancelTaskAt(class_2338 pos) {
        scheduledTasks.removeIf(task -> task.getPos().equals((Object)pos));
    }

    private void onServerTick(MinecraftServer server) {
        ArrayList<DelayedBlockTransformationTask> tasksToRemove = new ArrayList<DelayedBlockTransformationTask>();
        ArrayList<DelayedBlockTransformationTask> tasksToSchedule = new ArrayList<DelayedBlockTransformationTask>();
        for (DelayedBlockTransformationTask task : scheduledTasks) {
            task.tick();
            if (task.isFinished()) {
                if (task.getServerLevel().method_8320(task.getPos()).method_27852(task.expectedInitialBlock)) {
                    DelayedBlockTransformationTask nextTask = task.transformBlock();
                    if (nextTask != null) {
                        tasksToSchedule.add(nextTask);
                    }
                } else {
                    task.removeBreakingAnimation();
                }
                tasksToRemove.add(task);
                continue;
            }
            if (task.getServerLevel().method_8320(task.getPos()).method_27852(task.expectedInitialBlock)) continue;
            tasksToRemove.add(task);
            task.removeBreakingAnimation();
        }
        scheduledTasks.removeAll(tasksToRemove);
        scheduledTasks.addAll(tasksToSchedule);
        for (class_3222 player : server.method_3760().method_14571()) {
            ShieldStaminaHandler.onServerTick(player);
        }
    }

    public void onInitialize() {
        PayloadTypeRegistry.playC2S().register(OpenAdvancementPayload.ID, OpenAdvancementPayload.CODEC);
        INSTANCE = this;
        CommonClass.init();
        FabricModEvents.registerModEvents();
        FabricModItems.registerModItems();
        FabricModBlocks.registerBlocks();
        FabricModItemGroups.registerItemGroups();
        ServerTickEvents.END_SERVER_TICK.register(this::onServerTick);
    }

    static {
        ANGLING_TABLE_MENU_TYPE = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)Constants.id("angling_table"), (Object)new ExtendedScreenHandlerType((pWindowID, pInventory, pData) -> new AnglingTableMenu(pWindowID, pInventory), BlockData.CODEC));
        PRESERVED_CAULDRON_MENU_TYPE = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)Constants.id("preserved_cauldron"), (Object)new ExtendedScreenHandlerType(PreservedCauldronMenu::new, PreservedCauldronBlockData.STREAM_CODEC));
        PRESERVED_FLETCHING_TABLE_MENU_TYPE = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)Constants.id("preserved_fletching_table"), (Object)new ExtendedScreenHandlerType((pWindowID, pInventory, pData) -> new PreservedFletchingTableMenu(pWindowID, pInventory), BlockData.CODEC));
        PRESERVED_LOOM_MENU_TYPE = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)Constants.id("preserved_loom"), (Object)new ExtendedScreenHandlerType((pWindowID, pInventory, pData) -> new PreservedLoomMenu(pWindowID, pInventory), BlockData.CODEC));
        PRESERVED_ENCHANT_MENU_TYPE = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)Constants.id("preserved_enchant"), (Object)new ExtendedScreenHandlerType((pWindowID, pInventory, pData) -> new PreservedEnchantmentMenu(pWindowID, pInventory), BlockData.CODEC));
        CACHE_MENU_TYPE = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)Constants.id("cache"), (Object)new ExtendedScreenHandlerType(CacheMenu::new, ItemData.CODEC));
        Constants.ANGLING_TABLE_MENU_TYPE = () -> ANGLING_TABLE_MENU_TYPE;
        MenuTypes.CACHE_MENU_TYPE = () -> CACHE_MENU_TYPE;
        Constants.PRESERVED_ENCHANT_MENU_TYPE = () -> PRESERVED_ENCHANT_MENU_TYPE;
        Constants.PRESERVED_FLETCHING_TABLE_MENU_TYPE = () -> PRESERVED_FLETCHING_TABLE_MENU_TYPE;
        Constants.PRESERVED_LOOM_MENU_TYPE = () -> PRESERVED_LOOM_MENU_TYPE;
        MenuTypes.PRESERVED_CAULDRON_MENU_TYPE = () -> PRESERVED_CAULDRON_MENU_TYPE;
        PRESERVED_CAULDRON_BLOCK_ENTITY = PreservedInferno.register("preserved_cauldron_entity", FabricBlockEntityTypeBuilder.create(PreservedCauldronBlockEntity::new, (class_2248[])new class_2248[]{class_2246.field_10593}).build());
    }

    public record BlockData(boolean empty) {
        public static final class_9139<class_9129, BlockData> CODEC = class_9139.method_56434((class_9139)class_9135.field_48547, BlockData::empty, BlockData::new);
    }

    public record ItemData(int containerSize) {
        public static final class_9139<class_9129, ItemData> CODEC = class_9139.method_56434((class_9139)class_9135.field_48550, ItemData::containerSize, ItemData::new);

        public void write(class_9129 buf) {
            buf.method_10804(this.containerSize);
        }

        public static ItemData read(class_9129 buf) {
            return new ItemData(buf.method_10816());
        }
    }
}

