/*
 * Decompiled with CFR 0.152.
 */
package sircow.preservedinferno.other;

import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_167;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2421;
import net.minecraft.class_2488;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_5134;
import net.minecraft.class_8779;
import org.jetbrains.annotations.NotNull;
import sircow.preservedinferno.PreservedInferno;
import sircow.preservedinferno.effect.ModEffects;
import sircow.preservedinferno.item.ModItems;
import sircow.preservedinferno.other.AdvancementDelayCache;
import sircow.preservedinferno.other.MobLineOfSight;
import sircow.preservedinferno.other.ModEntityData;
import sircow.preservedinferno.other.OpenAdvancementPayload;
import sircow.preservedinferno.other.ShieldStaminaHandler;
import sircow.preservedinferno.other.SimpleBlockTransformationTask;
import sircow.preservedinferno.other.TempInventoryStorage;
import sircow.preservedinferno.platform.Services;
import sircow.preservedinferno.screen.PreservedFletchingTableMenu;
import sircow.preservedinferno.trigger.ModTriggers;

public class FabricModEvents {
    private static final long REGEN_COOLDOWN_MS = 600000L;

    public static void checkInitialAdvancement() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                class_167 progress;
                class_8779 advancement;
                UUID uuid;
                class_3218 level = player.method_51469();
                if (AdvancementDelayCache.hasCompleted(level, uuid = player.method_5667()) || (advancement = server.method_3851().method_12896(class_2960.method_60656((String)"story/root"))) == null || !(progress = player.method_14236().method_12882(advancement)).method_740()) continue;
                AdvancementDelayCache.markCompleted(level, uuid);
            }
        });
    }

    public static void limitCropBreak() {
        LootTableEvents.MODIFY_DROPS.register((entry, context, drops) -> {
            if (context.method_300(class_181.field_1224) && context.method_300(class_181.field_1229) && context.method_300(class_181.field_1226)) {
                class_2680 brokenState = (class_2680)context.method_35508(class_181.field_1224);
                class_1799 toolUsed = (class_1799)context.method_35508(class_181.field_1229);
                class_1657 playerEntity = null;
                if (context.method_65013(class_181.field_1226) instanceof class_1657) {
                    playerEntity = (class_1657)context.method_65013(class_181.field_1226);
                }
                if (playerEntity != null && (brokenState.method_27852(class_2246.field_10293) || brokenState.method_27852(class_2246.field_10609) || brokenState.method_27852(class_2246.field_10247) || brokenState.method_27852(class_2246.field_10341) || brokenState.method_27852(class_2246.field_46286) || brokenState.method_27852(class_2246.field_46287) || brokenState.method_27852(class_2246.field_9974)) && !toolUsed.method_31573(class_3489.field_42613)) {
                    drops.clear();
                }
            }
        });
    }

    public static void modifySleeping() {
        EntitySleepEvents.ALLOW_SLEEPING.register((player, pos) -> {
            boolean holdingDreamcatcher;
            class_1799 mainHandItem = player.method_5998(class_1268.field_5808);
            class_1799 offHandItem = player.method_5998(class_1268.field_5810);
            boolean bl = holdingDreamcatcher = mainHandItem.method_7909() == ModItems.DREAMCATCHER || offHandItem.method_7909() == ModItems.DREAMCATCHER;
            if (MobLineOfSight.hasMonsterLineOfSight(player.method_73183(), pos)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"block.minecraft.bed.not_safe"), true);
                return class_1657.class_1658.field_7531;
            }
            if (player.method_73183().method_66346() && !holdingDreamcatcher) {
                player.method_7353((class_2561)class_2561.method_43471((String)"block.minecraft.bed.no_dreamcatcher"), true);
                return class_1657.class_1658.field_7531;
            }
            if (player.method_73183().method_66346() && holdingDreamcatcher) {
                return null;
            }
            return class_1657.class_1658.field_7531;
        });
        EntitySleepEvents.START_SLEEPING.register((entity, sleepingPos) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                class_1799 main = player.method_6047();
                class_1799 off = player.method_6079();
                if (main.method_31574(ModItems.DREAMCATCHER)) {
                    main.method_7970(1, (class_1309)player, class_1304.field_6173);
                } else if (off.method_31574(ModItems.DREAMCATCHER)) {
                    off.method_7970(1, (class_1309)player, class_1304.field_6171);
                }
            }
        });
        EntitySleepEvents.STOP_SLEEPING.register((entity, sleepingPos) -> {
            class_1657 player;
            if (!Services.PLATFORM.isModLoaded("pblizzard") && entity instanceof class_1657 && (player = (class_1657)entity).method_7297() > 20 && !player.method_73183().method_66346()) {
                player.method_6092(new class_1293(ModEffects.WELL_RESTED, 24000, 0, false, false, true));
                player.method_7353((class_2561)class_2561.method_43471((String)"effect.pinferno.well_rested_awake"), true);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            if ((Long)player.method_5841().method_12789(ModEntityData.PLAYER_HARDCORE_REGEN_COOLDOWN) == 0L) {
                player.method_5841().method_12778(ModEntityData.PLAYER_HARDCORE_REGEN_COOLDOWN, (Object)(System.currentTimeMillis() - 600000L));
            }
        });
    }

    public static void handleEntityDeath() {
        ServerLivingEntityEvents.AFTER_DEATH.register((livingEntity, damageSource) -> {
            if (livingEntity instanceof class_1657) {
                class_1657 player = (class_1657)livingEntity;
                ShieldStaminaHandler.playerShieldCooldownMap.remove(player.method_5667());
            }
        });
        ServerLivingEntityEvents.ALLOW_DEATH.register((livingEntity, damageSource, damageAmount) -> {
            class_1657 player;
            if (livingEntity instanceof class_1657) {
                player = (class_1657)livingEntity;
                TempInventoryStorage.savePlayerInventory(player);
            }
            if (livingEntity instanceof class_3222 && (player = (class_3222)livingEntity).method_51469().method_8401().method_152() && player.method_6059(ModEffects.WELL_RESTED)) {
                player.method_6033(1.0f);
                player.method_6016(ModEffects.WELL_RESTED);
                player.field_6008 = 60;
                player.method_7353((class_2561)class_2561.method_43471((String)"effect.pinferno.well_rested_hardcore"), true);
                return false;
            }
            return true;
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            boolean hadWellRestedEffectOnDeath = TempInventoryStorage.restorePlayerInventory(newPlayer);
            if ((Integer)oldPlayer.method_5841().method_12789(ModEntityData.PLAYER_HEAT) >= 100 && newPlayer.method_51469().method_27983() != class_1937.field_25180) {
                newPlayer.method_5841().method_12778(ModEntityData.PLAYER_HEAT, (Object)99);
            } else if (newPlayer.method_51469().method_27983() == class_1937.field_25180) {
                newPlayer.method_5841().method_12778(ModEntityData.PLAYER_HEAT, (Object)0);
            } else {
                newPlayer.method_5841().method_12778(ModEntityData.PLAYER_HEAT, (Object)((Integer)oldPlayer.method_5841().method_12789(ModEntityData.PLAYER_HEAT)));
            }
            if (hadWellRestedEffectOnDeath && !Services.PLATFORM.isModLoaded("pblizzard") && !oldPlayer.method_51469().method_8401().method_152() && !newPlayer.method_51469().method_8401().method_152()) {
                Objects.requireNonNull(newPlayer.method_51469().method_8503()).execute(() -> newPlayer.method_43502((class_2561)class_2561.method_43471((String)"effect.pinferno.well_rested_consume"), true));
            }
            if (!alive) {
                newPlayer.method_6033(10.0f);
                newPlayer.method_7344().method_7580(10);
                newPlayer.method_7344().method_7581(5.0f);
            }
        });
    }

    public static void handleBlockPlace() {
        UseBlockCallback.EVENT.register((player, level, hand, hitResult) -> {
            if (level.method_8608()) {
                return class_1269.field_5811;
            }
            class_1799 itemInHand = player.method_5998(hand);
            class_2338 targetPos = hitResult.method_17777();
            class_2680 stateAtTargetPos = level.method_8320(targetPos);
            if (itemInHand.method_31574(class_2246.field_10477.method_8389()) && stateAtTargetPos.method_27852(class_2246.field_10477) && level.method_27983() == class_1937.field_25180) {
                int maxLayers;
                int currentLayers = (Integer)stateAtTargetPos.method_11654((class_2769)class_2488.field_11518);
                if (currentLayers < (maxLayers = 8)) {
                    PreservedInferno.cancelTaskAt(targetPos);
                    PreservedInferno.scheduleDelayedTask(new SimpleBlockTransformationTask(PreservedInferno.INSTANCE, (class_3218)level, targetPos, class_2246.field_10124.method_9564(), class_2246.field_10477, 200));
                }
                return class_1269.field_5811;
            }
            return class_1269.field_5811;
        });
    }

    public static void checkBreakFullyGrownCrop() {
        PlayerBlockBreakEvents.AFTER.register((level, player, pos, state, blockEntity) -> {
            boolean isCrop;
            if (level.method_8608()) {
                return;
            }
            boolean bl = isCrop = state.method_27852(class_2246.field_10293) || state.method_27852(class_2246.field_10609) || state.method_27852(class_2246.field_10247) || state.method_27852(class_2246.field_10341) || state.method_27852(class_2246.field_9974);
            if (isCrop) {
                boolean isFullyGrown = false;
                class_1799 mainHandItem = player.method_6047();
                class_2248 patt0$temp = state.method_26204();
                if (patt0$temp instanceof class_2302) {
                    class_2302 cropBlock = (class_2302)patt0$temp;
                    isFullyGrown = cropBlock.method_9825(state);
                } else if (state.method_26204() instanceof class_2421) {
                    boolean bl2 = isFullyGrown = state.method_28498((class_2769)class_2421.field_11306) && (Integer)state.method_11654((class_2769)class_2421.field_11306) == 3;
                }
                if (isFullyGrown && mainHandItem.method_31573(class_3489.field_42613)) {
                    ModTriggers.BREAK_GROWN_CROP.trigger((class_3222)player);
                }
            }
        });
    }

    private static void keyPressForFirstAdvancement() {
        ServerPlayNetworking.registerGlobalReceiver(OpenAdvancementPayload.ID, (payload, context) -> ModTriggers.OPENED_ADVANCEMENT_SCREEN.trigger(context.player()));
    }

    public static void hardcoreSetup() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            if (!server.method_3754()) {
                return;
            }
            if (!((Boolean)player.method_5841().method_12789(ModEntityData.PLAYER_HUNGER_INITIALIZED)).booleanValue()) {
                player.method_7344().method_7580(10);
                player.method_6033(10.0f);
                player.method_5841().method_12778(ModEntityData.PLAYER_HUNGER_INITIALIZED, (Object)true);
            }
            if (((Boolean)player.method_5841().method_12789(ModEntityData.RESET_HARDCORE_HEALTH)).booleanValue()) {
                if (Objects.requireNonNull(player.method_5996(class_5134.field_23716)).method_6201() != 20.0) {
                    Objects.requireNonNull(player.method_5996(class_5134.field_23716)).method_6192(20.0);
                }
                player.method_5841().method_12778(ModEntityData.RESET_HARDCORE_HEALTH, (Object)false);
            }
        });
    }

    public static void enableMinecartExperiment() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            boolean isEnabled;
            class_3218 overworld = server.method_30002();
            class_3283 registries = server.method_3836();
            if (((class_1928.class_4312)overworld.method_64395().method_20746(class_1928.field_52614)).method_20763() != 32) {
                ((class_1928.class_4312)overworld.method_64395().method_20746(class_1928.field_52614)).method_35236(32, server);
            }
            if (!(isEnabled = registries.method_14444().stream().anyMatch(pack -> pack.method_14463().equals("minecart_improvements")))) {
                registries.method_49427("minecart_improvements");
            }
        });
    }

    public static void openFletchingTable() {
        UseBlockCallback.EVENT.register((player, level, hand, hitResult) -> {
            if (level.method_8608()) {
                return class_1269.field_5811;
            }
            final class_2338 pos = hitResult.method_17777();
            class_2680 state = level.method_8320(pos);
            if (state.method_27852(class_2246.field_16331)) {
                player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                    @NotNull
                    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                        return new PreservedFletchingTableMenu(syncId, playerInventory, class_3914.method_17392((class_1937)level, (class_2338)pos));
                    }

                    @NotNull
                    public class_2561 method_5476() {
                        return class_2561.method_43471((String)"block.minecraft.fletching_table");
                    }

                    public Object getScreenOpeningData(class_3222 serverPlayer) {
                        boolean isEmpty = level.method_8321(pos) == null;
                        return new PreservedInferno.BlockData(isEmpty);
                    }
                });
                player.method_7281(class_3468.field_15368);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
    }

    public static void registerModEvents() {
        FabricModEvents.checkInitialAdvancement();
        FabricModEvents.limitCropBreak();
        FabricModEvents.modifySleeping();
        FabricModEvents.handleEntityDeath();
        FabricModEvents.handleBlockPlace();
        FabricModEvents.checkBreakFullyGrownCrop();
        FabricModEvents.keyPressForFirstAdvancement();
        FabricModEvents.hardcoreSetup();
        FabricModEvents.enableMinecartExperiment();
        FabricModEvents.openFletchingTable();
    }
}

