/*
 * Decompiled with CFR 0.152.
 */
package sircow.preservedinferno.block.entity;

import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import sircow.preservedinferno.PreservedInferno;
import sircow.preservedinferno.block.entity.PreservedCauldronBlockData;
import sircow.preservedinferno.recipe.CauldronRecipe;
import sircow.preservedinferno.recipe.CauldronRecipeInput;
import sircow.preservedinferno.recipe.ModRecipes;
import sircow.preservedinferno.screen.PreservedCauldronMenu;
import sircow.preservedinferno.sound.ModSounds;

public class PreservedCauldronBlockEntity
extends class_2624
implements ExtendedScreenHandlerFactory {
    private class_2371<class_1799> inventory = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    private static final int INPUT_SLOT = 0;
    private static final int INPUT_SLOT_TWO = 1;
    private static final int OUTPUT_SLOT = 2;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> PreservedCauldronBlockEntity.this.progress;
                case 1 -> PreservedCauldronBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    PreservedCauldronBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    PreservedCauldronBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    protected final class_3913 propertyDelegateTwo = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> PreservedCauldronBlockEntity.this.progressWater;
                case 1 -> PreservedCauldronBlockEntity.this.maxWaterProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    PreservedCauldronBlockEntity.this.progressWater = value;
                    break;
                }
                case 1: {
                    PreservedCauldronBlockEntity.this.maxWaterProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 100;
    public int progressWater = 0;
    public int maxWaterProgress = 64;

    public PreservedCauldronBlockEntity(class_2338 pos, class_2680 state) {
        super(PreservedInferno.PRESERVED_CAULDRON_BLOCK_ENTITY, pos, state);
    }

    @NotNull
    public class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> items) {
        this.inventory = items;
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        class_1262.method_5427((class_11372)output, this.inventory, (boolean)false);
        output.method_71465("CauldronProgress", this.progress);
        output.method_71465("CauldronWaterProgress", this.progressWater);
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        class_1262.method_5429((class_11368)input, this.inventory);
        this.progress = input.method_71424("CauldronProgress", 0);
        this.progressWater = input.method_71424("CauldronWaterProgress", 0);
    }

    public class_2596<class_2602> method_38235() {
        class_2487 tag = new class_2487();
        tag.method_10569("CauldronWaterProgress", this.progressWater);
        tag.method_10569("CauldronMaxWaterProgress", this.maxWaterProgress);
        return class_2622.method_39026((class_2586)this, (blockEntity, registryAccess) -> tag);
    }

    public void onDataPacket(class_2622 packet) {
        class_2487 tag = packet.method_11290();
        this.progressWater = tag.method_68083("CauldronWaterProgress", 0);
        this.maxWaterProgress = tag.method_68083("CauldronMaxWaterProgress", 64);
    }

    @NotNull
    public class_2561 method_17823() {
        return class_2561.method_43471((String)"block.minecraft.cauldron");
    }

    @NotNull
    public class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new PreservedCauldronMenu(syncId, playerInventory, this.propertyDelegate, this.propertyDelegateTwo, (class_1263)this);
    }

    public static void tick(class_3218 level, class_2338 pos, class_2680 state, PreservedCauldronBlockEntity cauldron) {
        if (level.method_8608()) {
            return;
        }
        if (cauldron.isOutputSlotEmptyOrReceivable()) {
            if (cauldron.hasRecipe() && cauldron.progressWater > 0) {
                cauldron.increaseCraftProgress();
                PreservedCauldronBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
                if (cauldron.hasCraftingFinished()) {
                    cauldron.craftItem();
                    cauldron.resetProgress();
                }
            } else {
                cauldron.resetProgress();
            }
        } else {
            cauldron.resetProgress();
            PreservedCauldronBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
        }
        cauldron.insertWater();
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<class_8786<CauldronRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        class_1799 output = ((CauldronRecipe)recipe.get().comp_1933()).output();
        class_1799 inputStack = this.method_5438(0);
        if (inputStack.method_57826(class_9334.field_49644)) {
            class_1799 result = inputStack.method_7972();
            result.method_57381(class_9334.field_49644);
            this.method_5447(2, result);
        } else if (output != null) {
            this.method_5447(2, new class_1799((class_1935)output.method_7909(), this.method_5438(2).method_7947() + output.method_7947()));
        }
        this.method_5434(0, 1);
        --this.progressWater;
        this.method_5431();
        if (this.field_11863 != null) {
            if (!this.field_11863.method_8608()) {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
            }
            this.field_11863.method_54762(null, (double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260(), ModSounds.CAULDRON_BUBBLE, class_3419.field_15245);
        }
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftProgress() {
        ++this.progress;
    }

    private void insertWater() {
        boolean waterProgressChanged = false;
        class_1844 potionContentsComponent = (class_1844)this.method_5438(1).method_58694(class_9334.field_49651);
        if (this.method_5438(1).method_7909() == class_1802.field_8705 && (this.progressWater != this.maxWaterProgress || this.progressWater + 8 < this.maxWaterProgress)) {
            class_1799 emptyBucket = new class_1799((class_1935)class_1802.field_8550);
            this.progressWater += 8;
            this.method_5434(1, 1);
            this.method_5447(1, new class_1799((class_1935)emptyBucket.method_7909()));
            if (this.field_11863 != null) {
                this.field_11863.method_8396(null, this.method_11016(), class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
            }
            waterProgressChanged = true;
        } else if (this.method_5438(1).method_7909() == class_1802.field_8574 && potionContentsComponent != null && potionContentsComponent.method_57401(class_1847.field_8991) && (this.progressWater != this.maxWaterProgress || this.progressWater + this.method_5438(1).method_7947() * 2 < this.maxWaterProgress)) {
            int stackSize = this.method_5438(1).method_7947();
            this.progressWater += stackSize * 2;
            class_1799 emptyBottle = new class_1799((class_1935)class_1802.field_8469);
            this.method_5434(1, 1);
            this.method_5447(1, new class_1799((class_1935)emptyBottle.method_7909(), stackSize));
            if (this.field_11863 != null) {
                this.field_11863.method_8396(null, this.method_11016(), class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
            }
            waterProgressChanged = true;
        }
        if (this.progressWater > this.maxWaterProgress) {
            this.progressWater = 64;
        }
        if (waterProgressChanged) {
            this.method_5431();
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
            }
        }
    }

    private boolean hasRecipe() {
        class_1799 input = (class_1799)this.inventory.getFirst();
        if (this.isLeatherArmor(input) && !input.method_57826(class_9334.field_49644)) {
            return false;
        }
        Optional<class_8786<CauldronRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        class_1799 output = ((CauldronRecipe)recipe.get().comp_1933()).output();
        return this.progressWater >= 1 && this.canInsertAmountIntoOutputSlot(output) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<class_8786<CauldronRecipe>> getCurrentRecipe() {
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return Optional.empty();
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_1799 original = (class_1799)this.inventory.getFirst();
        if (original.method_57826(class_9334.field_49644) && original.method_7909().method_7876().contains("leather_")) {
            class_1799 normalized = original.method_7972();
            normalized.method_57381(class_9334.field_49644);
            return serverLevel.method_64577().method_8132(ModRecipes.CAULDRON_TYPE, (class_9695)new CauldronRecipeInput(normalized), (class_1937)serverLevel);
        }
        return serverLevel.method_64577().method_8132(ModRecipes.CAULDRON_TYPE, (class_9695)new CauldronRecipeInput(original), (class_1937)serverLevel);
    }

    private boolean isLeatherArmor(class_1799 stack) {
        class_1792 item = stack.method_7909();
        String id = item.method_7876();
        return id.contains("leather_helmet") || id.contains("leather_chestplate") || id.contains("leather_leggings") || id.contains("leather_boots");
    }

    private boolean canInsertItemIntoOutputSlot(class_1799 item) {
        return this.method_5438(2).method_7909() == item.method_7909() || this.method_5438(2).method_7960();
    }

    private boolean canInsertAmountIntoOutputSlot(class_1799 result) {
        return this.method_5438(2).method_7947() + result.method_7947() <= this.method_5438(2).method_7914();
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.method_5438(2).method_7960() || this.method_5438(2).method_7947() < this.method_5438(2).method_7914();
    }

    public int method_5439() {
        return 3;
    }

    public Object getScreenOpeningData(class_3222 serverPlayer) {
        return new PreservedCauldronBlockData(this.method_11016());
    }

    public void method_5431() {
        super.method_5431();
    }
}

