/*
 * Decompiled with CFR 0.152.
 */
package sircow.preservedinferno.mixin;

import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_1088;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_9779;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sircow.preservedinferno.Constants;
import sircow.preservedinferno.item.custom.PreservedShieldItem;
import sircow.preservedinferno.other.HeatAccessor;
import sircow.preservedinferno.other.ShieldStaminaHandler;

@Mixin(value={class_329.class})
public class GuiMixin {
    @Unique
    private static final class_2960 HEAT_EMPTY_SPRITE = Constants.id("textures/gui/sprites/hud/heat_bar_empty.png");
    @Unique
    private static final class_2960 HEAT_FILLED_SPRITE = Constants.id("textures/gui/sprites/hud/heat_bar_filled.png");
    @Unique
    private static final class_2960 HEAT_100_SPRITE = Constants.id("textures/gui/sprites/hud/heat_100.png");
    @Unique
    private static final class_2960 HEAT_OVER_100_SPRITE = Constants.id("textures/gui/sprites/hud/heat_over_100.png");
    @Unique
    private static final class_2960 NEW_ARMOUR_BAR_EMPTY = Constants.id("hud/armor_bar_empty");
    @Unique
    private static final class_2960 NEW_ARMOUR_BAR_FILLED = Constants.id("hud/armor_bar_filled");
    @Unique
    private static final class_2960 SHIELD_BAR_BACKGROUND_SPRITE = Constants.id("textures/gui/sprites/hud/shield_bar_background.png");
    @Unique
    private static final class_2960 SHIELD_BAR_COOLDOWN_SPRITE = Constants.id("textures/gui/sprites/hud/shield_bar_cooldown.png");
    @Unique
    private static final class_2960 SHIELD_BAR_PROGRESS_SPRITE = Constants.id("textures/gui/sprites/hud/shield_bar_progress.png");
    @Unique
    private int heat;
    @Unique
    private class_1657 player;

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void preserved_inferno$renderHeat(class_332 guiGraphics, class_9779 deltaTracker, CallbackInfo ci) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 != null) {
            this.player = minecraft.field_1724;
            this.heat = ((HeatAccessor)this.player).preserved_inferno$getHeat();
        }
    }

    @Inject(method={"renderPlayerHealth"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;renderFood(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/player/Player;II)V", shift=At.Shift.BEFORE)})
    public void preserved_inferno$renderHeatBar(class_332 guiGraphics, CallbackInfo ci) {
        int screenWidth = guiGraphics.method_51421();
        int screenHeight = guiGraphics.method_51443();
        int x = screenWidth / 2 + 91;
        int baseY = screenHeight - 39;
        int heatBarY = baseY - 10;
        int barWidth = 81;
        int barHeight = 9;
        int maxAir = this.player.method_5748();
        if (this.player.method_5669() < maxAir) {
            heatBarY -= 10;
        }
        this.renderHeat(guiGraphics, x, heatBarY, barWidth, barHeight);
    }

    @Unique
    private void renderHeat(class_332 guiGraphics, int x, int y, int barWidth, int barHeight) {
        double maxHeatVal = 100.0;
        int heatVal = this.heat;
        if (heatVal > 0) {
            guiGraphics.method_25290(class_10799.field_56883, HEAT_EMPTY_SPRITE, x - barWidth, y, 0.0f, 0.0f, barWidth, barHeight, barWidth, barHeight);
            if (heatVal >= 100) {
                barWidth = 83;
                guiGraphics.method_25290(class_10799.field_56883, HEAT_100_SPRITE, x - barWidth + 1, y, 0.0f, 0.0f, barWidth, barHeight, barWidth, barHeight);
                if (heatVal > 100) {
                    double percentageMultiplier = (double)(heatVal - 100) / maxHeatVal;
                    int filledWidth = (int)(percentageMultiplier * (double)barWidth);
                    guiGraphics.method_25290(class_10799.field_56883, HEAT_OVER_100_SPRITE, x - barWidth + (barWidth - filledWidth) + 1, y, (float)(barWidth - filledWidth), 0.0f, filledWidth, barHeight, barWidth, barHeight);
                }
            } else {
                double percentageMultiplier = (double)heatVal / maxHeatVal;
                int filledWidth = (int)(percentageMultiplier * (double)barWidth);
                guiGraphics.method_25290(class_10799.field_56883, HEAT_FILLED_SPRITE, x - barWidth, y, 0.0f, 0.0f, filledWidth, barHeight, barWidth, barHeight);
            }
        }
    }

    @Inject(method={"renderArmor"}, at={@At(value="HEAD")}, cancellable=true)
    private static void preserved_inferno$modifyArmourBar(class_332 guiGraphics, class_1657 player, int y, int heartRows, int height, int x, CallbackInfo ci) {
        double maxArmourVal = 100.0;
        int armourVal = player.method_6096();
        int barWidth = 81;
        int barHeight = 9;
        int j = y - (heartRows - 1) * height - 10;
        if (armourVal > 0) {
            guiGraphics.method_52706(class_10799.field_56883, NEW_ARMOUR_BAR_EMPTY, x, j, barWidth, barHeight);
            double percentageMultiplier = armourVal >= 100 ? 1.0 : (double)armourVal / maxArmourVal;
            guiGraphics.method_70846(class_10799.field_56883, NEW_ARMOUR_BAR_FILLED, barWidth, barHeight, 0, 0, x, j, (int)(percentageMultiplier * (double)barWidth), barHeight);
        }
        ci.cancel();
    }

    @Inject(method={"renderHotbarAndDecorations"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/contextualbar/ContextualBarRenderer;render(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V", shift=At.Shift.AFTER)})
    private void preserved_inferno$renderShieldBar(class_332 guiGraphics, class_9779 deltaTracker, CallbackInfo ci) {
        int barWidth = 182;
        int barHeight = 5;
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            class_1799 heldStack = client.field_1724.method_6079();
            int x = client.method_22683().method_4486() / 2 - 91;
            int y = client.method_22683().method_4502() - 32 + 3;
            if (!heldStack.method_7960() && heldStack.method_7909() instanceof PreservedShieldItem && !this.player.method_68878() && !this.player.method_7325()) {
                guiGraphics.method_25290(class_10799.field_56883, SHIELD_BAR_BACKGROUND_SPRITE, x, y, 0.0f, 0.0f, barWidth, barHeight, barWidth, barHeight);
                float currentStamina = ShieldStaminaHandler.getShieldStamina(heldStack, (class_1657)client.field_1724);
                int maxStamina = ShieldStaminaHandler.getShieldMaxStamina(heldStack);
                if (maxStamina > 0) {
                    double percentageMultiplier = (double)currentStamina / (double)maxStamina;
                    int filledWidth = (int)(percentageMultiplier * (double)barWidth);
                    if (currentStamina <= (float)maxStamina) {
                        guiGraphics.method_25290(class_10799.field_56883, SHIELD_BAR_PROGRESS_SPRITE, x, y, 0.0f, 0.0f, filledWidth, barHeight, barWidth, barHeight);
                    }
                }
                if (ShieldStaminaHandler.isOnCooldown((class_1657)client.field_1724)) {
                    guiGraphics.method_25290(class_10799.field_56883, SHIELD_BAR_COOLDOWN_SPRITE, x, y, 0.0f, 0.0f, barWidth, barHeight, barWidth, barHeight);
                }
            }
        }
    }

    @Inject(method={"renderCameraOverlays"}, at={@At(value="TAIL")})
    private void preserved_inferno$renderHeatOverlay(class_332 graphics, class_9779 delta, CallbackInfo ci) {
        HeatAccessor accessor;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player instanceof HeatAccessor && (accessor = (HeatAccessor)player).preserved_inferno$getHeat() >= 100 && !player.method_5809() && !player.method_68878() && mc.field_1690.method_31044().method_31034()) {
            class_4587 poseStack = new class_4587();
            class_4597.class_4598 buffer = mc.method_22940().method_23000();
            class_1058 textureAtlasSprite = class_1088.field_5370.method_24148();
            class_4588 vertexConsumer = buffer.getBuffer(class_1921.method_65217((class_2960)textureAtlasSprite.method_45852()));
            float f = textureAtlasSprite.method_4594();
            float g = textureAtlasSprite.method_4577();
            float h = (f + g) / 2.0f;
            float i = textureAtlasSprite.method_4593();
            float j = textureAtlasSprite.method_4575();
            float k = (i + j) / 2.0f;
            float l = textureAtlasSprite.method_23842();
            float m = class_3532.method_16439((float)l, (float)f, (float)h);
            float n = class_3532.method_16439((float)l, (float)g, (float)h);
            float o = class_3532.method_16439((float)l, (float)i, (float)k);
            float p = class_3532.method_16439((float)l, (float)j, (float)k);
            for (int r = 0; r < 2; ++r) {
                poseStack.method_22903();
                poseStack.method_46416((float)(-(r * 2 - 1)) * 0.24f, -0.3f, 0.0f);
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)(r * 2 - 1) * 10.0f));
                Matrix4f matrix4f = poseStack.method_23760().method_23761();
                vertexConsumer.method_22918(matrix4f, -0.5f, -0.5f, -0.5f).method_22913(n, p).method_22915(1.0f, 1.0f, 1.0f, 0.9f);
                vertexConsumer.method_22918(matrix4f, 0.5f, -0.5f, -0.5f).method_22913(m, p).method_22915(1.0f, 1.0f, 1.0f, 0.9f);
                vertexConsumer.method_22918(matrix4f, 0.5f, 0.5f, -0.5f).method_22913(m, o).method_22915(1.0f, 1.0f, 1.0f, 0.9f);
                vertexConsumer.method_22918(matrix4f, -0.5f, 0.5f, -0.5f).method_22913(n, o).method_22915(1.0f, 1.0f, 1.0f, 0.9f);
                poseStack.method_22909();
            }
        }
    }

    @ModifyConstant(method={"renderSleepOverlay"}, constant={@Constant(floatValue=100.0f)})
    private float preserved_inferno$modifyFloatValue(float original) {
        return 200.0f;
    }

    @Redirect(method={"renderHotbarAndDecorations"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/contextualbar/ContextualBarRenderer;renderExperienceLevel(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;I)V"))
    private void preserved_inferno$moveXPNumber(class_332 guiGraphics, class_327 font, int level) {
        class_5250 component = class_2561.method_43469((String)"gui.experience.level", (Object[])new Object[]{level});
        int i = (guiGraphics.method_51421() - font.method_27525((class_5348)component)) / 2;
        int j = guiGraphics.method_51443() - 24 - 9 - 5;
        guiGraphics.method_51439(font, (class_2561)component, i + 1, j, -16777216, false);
        guiGraphics.method_51439(font, (class_2561)component, i - 1, j, -16777216, false);
        guiGraphics.method_51439(font, (class_2561)component, i, j + 1, -16777216, false);
        guiGraphics.method_51439(font, (class_2561)component, i, j - 1, -16777216, false);
        guiGraphics.method_51439(font, (class_2561)component, i, j, -8323296, false);
    }
}

