/*
 * Decompiled with CFR 0.152.
 */
package sircow.preservedinferno.other;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import sircow.preservedinferno.effect.ModEffects;

public class TempInventoryStorage {
    private static final Map<UUID, class_2499> SAVED_INVENTORIES = new HashMap<UUID, class_2499>();
    private static final Map<UUID, Integer> SAVED_EXPERIENCE_LEVELS = new HashMap<UUID, Integer>();
    private static final Map<UUID, Float> SAVED_EXPERIENCE_PROGRESS = new HashMap<UUID, Float>();
    private static final Map<UUID, Boolean> PLAYER_HAD_WELL_RESTED_ON_DEATH = new HashMap<UUID, Boolean>();

    public static void savePlayerInventory(class_1657 player) {
        if (player.method_6059(ModEffects.WELL_RESTED)) {
            class_2499 inventoryTag = new class_2499();
            class_1661 inventory = player.method_31548();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7960()) continue;
                class_2487 tag = new class_2487();
                tag.method_10567("Slot", (byte)i);
                class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)player.method_37908().method_30349());
                class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)stack).resultOrPartial(error -> {}).ifPresent(encoded -> tag.method_10566("Item", encoded));
                inventoryTag.add((Object)tag);
            }
            for (class_1304 slot : new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166}) {
                class_1799 stack = player.method_6118(slot);
                if (stack.method_7960()) continue;
                class_2487 tag = TempInventoryStorage.getCompoundTag(slot);
                class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)player.method_37908().method_30349());
                class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)stack).resultOrPartial(error -> {}).ifPresent(encoded -> tag.method_10566("Item", encoded));
                inventoryTag.add((Object)tag);
            }
            class_1799 offhand = player.method_6118(class_1304.field_6171);
            if (!offhand.method_7960()) {
                class_2487 tag = new class_2487();
                tag.method_10567("Slot", (byte)-106);
                class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)player.method_37908().method_30349());
                class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)offhand).resultOrPartial(error -> {}).ifPresent(encoded -> tag.method_10566("Item", encoded));
                inventoryTag.add((Object)tag);
            }
            SAVED_INVENTORIES.put(player.method_5667(), inventoryTag);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                SAVED_EXPERIENCE_LEVELS.put(serverPlayer.method_5667(), serverPlayer.field_7520);
                SAVED_EXPERIENCE_PROGRESS.put(serverPlayer.method_5667(), Float.valueOf(serverPlayer.field_7510));
            }
            PLAYER_HAD_WELL_RESTED_ON_DEATH.put(player.method_5667(), true);
        }
    }

    @NotNull
    private static class_2487 getCompoundTag(class_1304 slot) {
        class_2487 tag = new class_2487();
        byte id = switch (slot) {
            case class_1304.field_6166 -> 100;
            case class_1304.field_6172 -> 101;
            case class_1304.field_6174 -> 102;
            case class_1304.field_6169 -> 103;
            default -> throw new IllegalStateException("Unexpected EquipmentSlot: " + String.valueOf(slot));
        };
        tag.method_10567("Slot", id);
        return tag;
    }

    public static boolean restorePlayerInventory(class_3222 player) {
        boolean hadWellRestedEffectOnDeath;
        UUID uuid = player.method_5667();
        class_2499 tagList = SAVED_INVENTORIES.remove(uuid);
        if (tagList != null) {
            player.method_31548().method_5448();
            for (class_2520 value : tagList) {
                class_2487 tag = (class_2487)value;
                int slotId = tag.method_68562("Slot", (byte)0) & 0xFF;
                class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)player.method_51469().method_30349());
                Optional<class_1799> stackOpt = Optional.ofNullable(tag.method_10580("Item")).flatMap(itemTag -> class_1799.field_24671.decode((DynamicOps)ops, itemTag).result()).map(Pair::getFirst);
                class_1799 stack = stackOpt.orElse(class_1799.field_8037);
                if (stack.method_7960()) continue;
                if (slotId < player.method_31548().method_5439()) {
                    player.method_31548().method_5447(slotId, stack);
                    continue;
                }
                if (slotId >= 100 && slotId < 104) {
                    class_1304 slot = switch (slotId) {
                        case 100 -> class_1304.field_6166;
                        case 101 -> class_1304.field_6172;
                        case 102 -> class_1304.field_6174;
                        case 103 -> class_1304.field_6169;
                        default -> throw new IllegalStateException("Invalid equipment slot ID: " + slotId);
                    };
                    player.method_5673(slot, stack);
                    continue;
                }
                if (slotId != 150) continue;
                player.method_5673(class_1304.field_6171, stack);
            }
        }
        if (SAVED_EXPERIENCE_LEVELS.containsKey(uuid)) {
            player.field_7520 = SAVED_EXPERIENCE_LEVELS.remove(uuid);
        }
        if (SAVED_EXPERIENCE_PROGRESS.containsKey(uuid)) {
            player.field_7510 = SAVED_EXPERIENCE_PROGRESS.remove(uuid).floatValue();
        }
        boolean bl = hadWellRestedEffectOnDeath = PLAYER_HAD_WELL_RESTED_ON_DEATH.remove(uuid) != null;
        if (hadWellRestedEffectOnDeath) {
            player.method_6016(ModEffects.WELL_RESTED);
        }
        return hadWellRestedEffectOnDeath;
    }
}

