/*
 * Decompiled with CFR 0.152.
 */
package sircow.preservedinferno;

import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import sircow.preservedinferno.Constants;
import sircow.preservedinferno.block.ModBlocks;
import sircow.preservedinferno.components.ModComponents;
import sircow.preservedinferno.effect.ModEffects;
import sircow.preservedinferno.entity.ModEntities;
import sircow.preservedinferno.item.ModItems;
import sircow.preservedinferno.other.ModDamageTypes;
import sircow.preservedinferno.other.ModEntityData;
import sircow.preservedinferno.other.ModTags;
import sircow.preservedinferno.platform.Services;
import sircow.preservedinferno.potion.ModPotions;
import sircow.preservedinferno.recipe.ModRecipes;
import sircow.preservedinferno.sound.ModSounds;
import sircow.preservedinferno.trigger.ModTriggers;

public class CommonClass {
    public static void init() {
        if (Services.PLATFORM.isModLoaded("pinferno")) {
            Constants.LOG.info("Initialising Preserved: Inferno");
            ModBlocks.registerModBlocks();
            ModItems.registerModItems();
            ModTags.registerModTags();
            ModDamageTypes.registerModDamageTypes();
            ModSounds.registerSounds();
            ModComponents.registerModComponents();
            ModEntityData.registerModEntityData();
            ModEntities.registerModEntities();
            ModRecipes.registerModRecipes();
            ModEffects.registerModEffects();
            ModPotions.registerModPotions();
            ModTriggers.registerTriggers();
            CommonClass.suppressSpecificLogLines();
        }
    }

    public static void suppressSpecificLogLines() {
        Logger rootLogger = (Logger)LogManager.getRootLogger();
        final List<String> suppressedMessages = Arrays.asList("Couldn't parse data file 'pinferno:nether/all_effects'", "Couldn't parse data file 'minecraft:netherite_upgrade_smithing_template'", "Couldn't parse data file 'minecraft:repair_item'", "Couldn't parse data file 'minecraft:leather'", "Couldn't parse data file 'minecraft:shield'", "Couldn't parse data file 'minecraft:white_wool_from_string'", "Tried to add entity minecraft:enderman but it was marked as removed already", "Tried to add entity minecraft:spider but it was marked as removed already");
        rootLogger.addFilter((Filter)new AbstractFilter(){

            public Filter.Result filter(LogEvent event) {
                String msg = event.getMessage().getFormattedMessage();
                if (msg != null) {
                    for (String suppressedMsgPart : suppressedMessages) {
                        if (!msg.contains(suppressedMsgPart)) continue;
                        return Filter.Result.DENY;
                    }
                }
                return Filter.Result.NEUTRAL;
            }
        });
    }
}

