/*
 * Decompiled with CFR 0.152.
 */
package sircow.preservedinferno.client;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.minecraft.class_11515;
import net.minecraft.class_124;
import net.minecraft.class_167;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3929;
import net.minecraft.class_5250;
import net.minecraft.class_5601;
import net.minecraft.class_5616;
import net.minecraft.class_5619;
import net.minecraft.class_632;
import net.minecraft.class_8779;
import net.minecraft.class_953;
import sircow.preservedinferno.Constants;
import sircow.preservedinferno.MenuTypes;
import sircow.preservedinferno.PreservedInferno;
import sircow.preservedinferno.block.ModBlocks;
import sircow.preservedinferno.block.entity.PreservedCauldronBlockEntityRenderer;
import sircow.preservedinferno.client.AnglingTableScreen;
import sircow.preservedinferno.client.CopperTridentModel;
import sircow.preservedinferno.client.PreservedEnchantingTableScreen;
import sircow.preservedinferno.client.PreservedFletchingTableScreen;
import sircow.preservedinferno.client.PreservedLoomScreen;
import sircow.preservedinferno.client.ThrownCopperTridentRenderer;
import sircow.preservedinferno.components.ModComponents;
import sircow.preservedinferno.entity.ModEntities;
import sircow.preservedinferno.item.ModItems;
import sircow.preservedinferno.mixin.ClientAdvancementsAccessor;
import sircow.preservedinferno.other.IMinecraftMixin;
import sircow.preservedinferno.other.ModTags;
import sircow.preservedinferno.screen.CacheScreen;
import sircow.preservedinferno.screen.PreservedCauldronScreen;

public class FabricPreservedInfernoClient
implements ClientModInitializer {
    DecimalFormat df = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US));
    public static boolean waitingForAdvancement = false;
    public static boolean suppressNextOpen = false;
    public static int advancementDelayTicks = -1;
    public static boolean hasTriggeredOnce = false;
    public static boolean advancementsSynced = false;
    public static boolean advancementGranted = false;
    private static int initialMessageDelay = 40;

    public void onInitializeClient() {
        this.registerMenuScreens();
        this.registerEntities();
        this.configureBlockRenderLayers();
        this.registerCustomTooltip();
        this.tickAdvancement();
        class_5616.method_32144(PreservedInferno.PRESERVED_CAULDRON_BLOCK_ENTITY, PreservedCauldronBlockEntityRenderer::new);
    }

    private void registerMenuScreens() {
        class_3929.method_17542(Constants.ANGLING_TABLE_MENU_TYPE.get(), AnglingTableScreen::new);
        class_3929.method_17542(MenuTypes.CACHE_MENU_TYPE.get(), CacheScreen::new);
        class_3929.method_17542(Constants.PRESERVED_ENCHANT_MENU_TYPE.get(), PreservedEnchantingTableScreen::new);
        class_3929.method_17542(Constants.PRESERVED_FLETCHING_TABLE_MENU_TYPE.get(), PreservedFletchingTableScreen::new);
        class_3929.method_17542(Constants.PRESERVED_LOOM_MENU_TYPE.get(), PreservedLoomScreen::new);
        class_3929.method_17542(MenuTypes.PRESERVED_CAULDRON_MENU_TYPE.get(), PreservedCauldronScreen::new);
    }

    private void registerEntities() {
        class_5619.method_32173(ModEntities.FLARE_GUN_PROJECTILE, class_953::new);
        class_5619.method_32173(ModEntities.COPPER_TRIDENT, ThrownCopperTridentRenderer::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)ThrownCopperTridentRenderer.COPPER_TRIDENT, CopperTridentModel::createLayer);
    }

    private void configureBlockRenderLayers() {
        BlockRenderLayerMap.putBlocks((class_11515)class_11515.field_60925, (class_2248[])new class_2248[]{ModBlocks.INDUCTOR_RAIL, ModBlocks.EXPOSED_INDUCTOR_RAIL, ModBlocks.WEATHERED_INDUCTOR_RAIL, ModBlocks.OXIDIZED_INDUCTOR_RAIL, ModBlocks.WAXED_INDUCTOR_RAIL, ModBlocks.WAXED_EXPOSED_INDUCTOR_RAIL, ModBlocks.WAXED_WEATHERED_INDUCTOR_RAIL, ModBlocks.WAXED_OXIDIZED_INDUCTOR_RAIL, ModBlocks.REINFORCED_OAK_DOOR, ModBlocks.REINFORCED_SPRUCE_DOOR, ModBlocks.REINFORCED_BIRCH_DOOR, ModBlocks.REINFORCED_JUNGLE_DOOR, ModBlocks.REINFORCED_ACACIA_DOOR, ModBlocks.REINFORCED_CHERRY_DOOR, ModBlocks.REINFORCED_DARK_OAK_DOOR, ModBlocks.REINFORCED_PALE_OAK_DOOR, ModBlocks.REINFORCED_MANGROVE_DOOR, ModBlocks.REINFORCED_BAMBOO_DOOR, ModBlocks.REINFORCED_CRIMSON_DOOR, ModBlocks.REINFORCED_WARPED_DOOR, ModBlocks.REINFORCED_COPPER_DOOR, ModBlocks.REINFORCED_EXPOSED_COPPER_DOOR, ModBlocks.REINFORCED_OXIDIZED_COPPER_DOOR, ModBlocks.REINFORCED_WEATHERED_COPPER_DOOR, ModBlocks.REINFORCED_WAXED_COPPER_DOOR, ModBlocks.REINFORCED_WAXED_EXPOSED_COPPER_DOOR, ModBlocks.REINFORCED_WAXED_OXIDIZED_COPPER_DOOR, ModBlocks.REINFORCED_WAXED_WEATHERED_COPPER_DOOR});
    }

    private void registerCustomTooltip() {
        ItemTooltipCallback.EVENT.register((stack, context, tooltipType, lines) -> {
            String durabilityTranslatable = class_2561.method_43471((String)"item.durability").getString();
            String textBeforeSplit = durabilityTranslatable.substring(0, durabilityTranslatable.indexOf(58)).trim();
            int insertIndex = this.findTooltipInsertIndex(lines, textBeforeSplit);
            Integer maxStamina = (Integer)stack.method_58694(ModComponents.SHIELD_MAX_STAMINA_COMPONENT);
            Float staminaRegenRate = (Float)stack.method_58694(ModComponents.SHIELD_REGEN_RATE_COMPONENT);
            String particleVal = (String)stack.method_58694(ModComponents.FLARE_PARTICLE_COMPONENT);
            String hook = (String)stack.method_58694(ModComponents.HOOK_COMPONENT);
            String line = (String)stack.method_58694(ModComponents.LINE_COMPONENT);
            String sinker = (String)stack.method_58694(ModComponents.SINKER_COMPONENT);
            if (maxStamina != null) {
                this.addShieldTooltip(lines, insertIndex, maxStamina, staminaRegenRate);
            }
            if (stack.method_31573(ModTags.ROD_UPGRADES)) {
                this.addFishingUpgradeTooltip(lines, insertIndex, stack.method_7909());
            }
            if (hook != null && !hook.equals("none") || line != null && !line.equals("none") || sinker != null && !sinker.equals("none")) {
                this.addFishingUpgradeTooltip(lines, insertIndex, hook, line, sinker);
            }
            if (stack.method_31574(ModItems.FLARE_GUN) && particleVal != null) {
                if (particleVal.equals("0xFFFFFF")) {
                    particleVal = "#FFFFFF";
                }
                int parsedParticleVal = Integer.parseInt(particleVal.replace("#", ""), 16);
                lines.add(insertIndex, class_2561.method_43469((String)"item.color", (Object[])new Object[]{class_2561.method_43470((String)particleVal).method_27696(class_2583.field_24360.method_36139(parsedParticleVal))}).method_27692(class_124.field_1080));
            }
            this.addSmithingTemplateTooltip(lines, insertIndex, stack);
        });
    }

    private int findTooltipInsertIndex(List<class_2561> lines, String textBeforeSplit) {
        for (int i = 0; i < lines.size(); ++i) {
            String lineString = lines.get(i).getString();
            if (!lineString.contains(textBeforeSplit) && (lineString.contains(textBeforeSplit) || !lineString.contains("minecraft") && !lineString.contains("pinferno"))) continue;
            return i;
        }
        return lines.size();
    }

    private void addShieldTooltip(List<class_2561> lines, int insertIndex, Integer maxStamina, Float staminaRegenRate) {
        lines.add(insertIndex++, (class_2561)class_2561.method_43473());
        lines.add(insertIndex++, (class_2561)class_2561.method_43471((String)"item.modifiers.offhand").method_27692(class_124.field_1080));
        lines.add(insertIndex++, (class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"item.pinferno.shield_max_stamina", (Object[])new Object[]{maxStamina}).method_27692(class_124.field_1077)));
        lines.add(insertIndex++, (class_2561)class_2561.method_43473());
        lines.add(insertIndex++, (class_2561)class_2561.method_43471((String)"item.pinferno.modifiers.not_active").method_27692(class_124.field_1080));
        lines.add(insertIndex, (class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"item.pinferno.shield_regen_rate", (Object[])new Object[]{this.df.format(staminaRegenRate.floatValue() * 20.0f)}).method_27692(class_124.field_1078)));
    }

    private void addSmithingTemplateTooltip(List<class_2561> lines, int insertIndex, class_1799 stack) {
        if (stack.method_31574(ModItems.NETHER_ALLOY_UPGRADE_SMITHING_TEMPLATE)) {
            lines.add(insertIndex++, (class_2561)class_2561.method_43471((String)"item.minecraft.smithing_template").method_27692(class_124.field_1080));
            lines.add(insertIndex++, (class_2561)class_2561.method_43473());
            lines.add(insertIndex++, (class_2561)class_2561.method_43471((String)"item.minecraft.smithing_template.applies_to").method_27692(class_124.field_1080));
            lines.add(insertIndex++, (class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"item.pinferno.helmets").method_27692(class_124.field_1078)));
            lines.add(insertIndex++, (class_2561)class_2561.method_43471((String)"item.minecraft.smithing_template.ingredients").method_27692(class_124.field_1080));
            lines.add(insertIndex, (class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"item.pinferno.nether_alloy_ingot").method_27692(class_124.field_1078)));
        }
        if (stack.method_31574(ModItems.ECHOING_PRISM_UPGRADE_SMITHING_TEMPLATE)) {
            lines.add(insertIndex++, (class_2561)class_2561.method_43471((String)"item.minecraft.smithing_template").method_27692(class_124.field_1080));
            lines.add(insertIndex++, (class_2561)class_2561.method_43473());
            lines.add(insertIndex++, (class_2561)class_2561.method_43471((String)"item.minecraft.smithing_template.applies_to").method_27692(class_124.field_1080));
            lines.add(insertIndex++, (class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"item.pinferno.leggings").method_27692(class_124.field_1078)));
            lines.add(insertIndex++, (class_2561)class_2561.method_43471((String)"item.minecraft.smithing_template.ingredients").method_27692(class_124.field_1080));
            lines.add(insertIndex, (class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"item.pinferno.echoing_prism").method_27692(class_124.field_1078)));
        }
    }

    private void addFishingUpgradeTooltip(List<class_2561> lines, int insertIndex, String hook, String line, String sinker) {
        lines.add(insertIndex++, (class_2561)class_2561.method_43473());
        lines.add(insertIndex++, (class_2561)class_2561.method_43471((String)"item.pinferno.modifiers.rod_in_hand").method_27692(class_124.field_1080));
        Map<String, Double> valuesMap = Map.of("copper", 0.5, "iron", 1.0, "prismarine", 1.5, "golden", 1.5, "diamond", 2.0, "netherite", 3.0);
        if (valuesMap.containsKey(hook)) {
            lines.add(insertIndex++, (class_2561)class_2561.method_43469((String)"item.pinferno.modifiers.fishing_speed", (Object[])new Object[]{valuesMap.get(hook)}).method_27692(class_124.field_1078));
        }
        if (valuesMap.containsKey(line)) {
            lines.add(insertIndex++, (class_2561)class_2561.method_43469((String)"item.pinferno.modifiers.fortune", (Object[])new Object[]{valuesMap.get(line)}).method_27692(class_124.field_1078));
        }
        if (valuesMap.containsKey(sinker)) {
            lines.add(insertIndex, (class_2561)class_2561.method_43469((String)"item.pinferno.modifiers.luck", (Object[])new Object[]{valuesMap.get(sinker)}).method_27692(class_124.field_1078));
        }
    }

    private void addFishingUpgradeTooltip(List<class_2561> lines, int insertIndex, class_1792 item) {
        lines.add(insertIndex++, (class_2561)class_2561.method_43473());
        lines.add(insertIndex++, (class_2561)class_2561.method_43471((String)"item.pinferno.modifiers.on_rod").method_27692(class_124.field_1080));
        Map<class_1792, Double> fishingSpeedMap = Map.of(ModItems.COPPER_FISHING_HOOK, 0.5, ModItems.IRON_FISHING_HOOK, 1.0, ModItems.PRISMARINE_FISHING_HOOK, 1.5, ModItems.GOLDEN_FISHING_HOOK, 1.5, ModItems.DIAMOND_FISHING_HOOK, 2.0, ModItems.NETHERITE_FISHING_HOOK, 3.0);
        Map<class_1792, Double> fortuneMap = Map.of(ModItems.COPPER_LACED_FISHING_LINE, 0.5, ModItems.IRON_LACED_FISHING_LINE, 1.0, ModItems.PRISMARINE_LACED_FISHING_LINE, 1.5, ModItems.GOLDEN_LACED_FISHING_LINE, 1.5, ModItems.DIAMOND_LACED_FISHING_LINE, 2.0, ModItems.NETHERITE_LACED_FISHING_LINE, 3.0);
        Map<class_1792, Double> luckMap = Map.of(ModItems.COPPER_SINKER, 0.5, ModItems.IRON_SINKER, 1.0, ModItems.PRISMARINE_SINKER, 1.5, ModItems.GOLDEN_SINKER, 1.5, ModItems.DIAMOND_SINKER, 2.0, ModItems.NETHERITE_SINKER, 3.0);
        this.addIfPresent(lines, insertIndex, item, fishingSpeedMap, "item.pinferno.modifiers.fishing_speed");
        this.addIfPresent(lines, insertIndex, item, fortuneMap, "item.pinferno.modifiers.fortune");
        this.addIfPresent(lines, insertIndex, item, luckMap, "item.pinferno.modifiers.luck");
    }

    private void addIfPresent(List<class_2561> lines, int insertIndex, class_1792 item, Map<class_1792, Double> map, String translationKey) {
        if (map.containsKey(item)) {
            lines.add(insertIndex, (class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)translationKey, (Object[])new Object[]{map.get(item)}).method_27692(class_124.field_1078)));
        }
    }

    private void tickAdvancement() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            Map<class_8779, class_167> progressMap;
            class_167 rootProgress;
            if (advancementDelayTicks > 0) {
                --advancementDelayTicks;
            } else if (advancementDelayTicks == 0) {
                advancementDelayTicks = -1;
                ((IMinecraftMixin)client).startWaitForAdvancement(client, 0);
            }
            if (initialMessageDelay > 0) {
                --initialMessageDelay;
                return;
            }
            if (client.field_1724 == null) {
                return;
            }
            class_632 advancements = client.field_1724.field_3944.method_2869();
            class_8779 rootAdvancementHolder = advancements.method_53815(class_2960.method_60656((String)"story/root"));
            advancementGranted = rootAdvancementHolder != null ? (rootProgress = (progressMap = ((ClientAdvancementsAccessor)advancements).getProgress()).get(rootAdvancementHolder)) != null && rootProgress.method_740() : false;
            if (!advancementGranted) {
                class_304 key = class_310.method_1551().field_1690.field_1844;
                class_5250 actionbar = class_2561.method_43469((String)"advancement.pinferno.actionbar.open_advancements", (Object[])new Object[]{class_2561.method_43472((String)key.method_1431())});
                client.field_1705.method_1758((class_2561)actionbar, false);
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            advancementGranted = false;
            hasTriggeredOnce = false;
            suppressNextOpen = false;
            waitingForAdvancement = false;
            advancementDelayTicks = -1;
            advancementsSynced = false;
            initialMessageDelay = 40;
        });
    }
}

