/*
 * Decompiled with CFR 0.152.
 */
package sircow.preservedinferno.other;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import sircow.preservedinferno.PreservedInferno;

public abstract class DelayedBlockTransformationTask {
    protected final class_3218 serverLevel;
    protected final class_2338 pos;
    protected final class_2680 newState;
    protected int delayTicks;
    protected final PreservedInferno modInstance;
    protected final int breakerId;
    public final class_2248 expectedInitialBlock;
    private static final Set<class_2338> noDropBlocks = Collections.synchronizedSet(new HashSet());

    public DelayedBlockTransformationTask(PreservedInferno modInstance, class_3218 serverLevel, class_2338 pos, class_2680 newState, class_2248 expectedInitialBlock, int delayTicks) {
        this.modInstance = modInstance;
        this.serverLevel = serverLevel;
        this.pos = pos;
        this.newState = newState;
        this.delayTicks = delayTicks;
        this.breakerId = this.generateUniqueBreakerId();
        this.expectedInitialBlock = expectedInitialBlock;
        this.addNoDropBlock(pos);
    }

    public void addNoDropBlock(class_2338 pos) {
        noDropBlocks.add(pos.method_10062());
    }

    public void removeNoDropBlock(class_2338 pos) {
        noDropBlocks.remove(pos);
    }

    public static boolean isNoDropBlock(class_2338 pos) {
        return noDropBlocks.contains(pos);
    }

    private int generateUniqueBreakerId() {
        return this.pos.hashCode() + this.serverLevel.method_27983().hashCode();
    }

    public void tick() {
        if (!this.isBlockValid()) {
            this.cancelTransformation();
            return;
        }
        --this.delayTicks;
        if (this.delayTicks >= 0) {
            this.updateBreakingProgress();
        }
    }

    protected void updateBreakingProgress() {
        int maxDelay = this.getMaxDelayTicks();
        if (maxDelay == 0) {
            return;
        }
        int progress = (int)((float)(maxDelay - this.delayTicks) / (float)maxDelay * 10.0f);
        progress = Math.max(0, Math.min(9, progress));
        this.sendBreakingProgressToClients(progress);
    }

    protected void sendBreakingProgressToClients(int progress) {
        this.serverLevel.method_18456().forEach(player -> {
            if (player.method_24515().method_19771((class_2382)this.pos, 64.0)) {
                player.field_13987.method_14364((class_2596)new class_2620(this.breakerId, this.pos, progress));
            }
        });
    }

    protected abstract int getMaxDelayTicks();

    public abstract DelayedBlockTransformationTask transformBlock();

    public boolean isFinished() {
        return this.delayTicks <= 0;
    }

    protected boolean isBlockValid() {
        return this.serverLevel.method_8320(this.pos).method_27852(this.expectedInitialBlock);
    }

    public void cancelTransformation() {
        this.removeBreakingAnimation();
    }

    public void removeBreakingAnimation() {
        this.sendBreakingProgressToClients(-1);
    }

    public class_3218 getServerLevel() {
        return this.serverLevel;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2680 getNewState() {
        return this.newState;
    }

    public int getDelayTicks() {
        return this.delayTicks;
    }
}

