/*
 * Decompiled with CFR 0.152.
 */
package sircow.preservedinferno.other;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import sircow.preservedinferno.trigger.ModTriggers;

public class KillTracker {
    private static final Map<UUID, KillSession> ACTIVE_SESSIONS = new HashMap<UUID, KillSession>();

    public static void onEntityKilled(class_3222 serverPlayer, class_1309 livingEntity, class_1282 source) {
        if (!Objects.requireNonNull(source.method_60948()).method_31573(class_3489.field_42611)) {
            return;
        }
        KillSession session = ACTIVE_SESSIONS.computeIfAbsent(serverPlayer.method_5667(), id -> new KillSession());
        session.registerKill(serverPlayer.method_51469().method_8510());
        if (session.kills >= 3) {
            ModTriggers.TRIPLE_KILL.trigger(serverPlayer);
            ACTIVE_SESSIONS.remove(serverPlayer.method_5667());
        }
    }

    private static class KillSession {
        int kills = 0;
        long lastKillTick = 0L;

        private KillSession() {
        }

        void registerKill(long currentTick) {
            if (currentTick - this.lastKillTick > 5L) {
                this.kills = 0;
            }
            ++this.kills;
            this.lastKillTick = currentTick;
        }
    }
}

