/*
 * Decompiled with CFR 0.152.
 */
package sircow.preservedinferno.other;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import sircow.preservedinferno.item.custom.PreservedShieldItem;
import sircow.preservedinferno.other.ModEntityData;
import sircow.preservedinferno.sound.ModSounds;

public class ShieldStaminaHandler {
    public static final Map<UUID, Integer> playerShieldCooldownMap = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> regenBlockMap = new HashMap<UUID, Integer>();
    private static final int COOLDOWN_TICKS = 200;
    private static final int REGEN_BLOCK_TICKS = 40;
    private static final float STAMINA_LOSS = 0.15f;
    public static class_1282 lastBypassingSource = null;

    public static void onServerTick(class_3222 player) {
        ShieldStaminaHandler.handleShieldUsage(player);
        ShieldStaminaHandler.handleStaminaRegeneration(player);
        ShieldStaminaHandler.handleCooldown(player);
        ShieldStaminaHandler.handleRegenBlock(player);
        ShieldStaminaHandler.checkBlockingOnCooldown(player);
        ShieldStaminaHandler.checkStopBlocking(player);
    }

    private static void handleShieldUsage(class_3222 player) {
        class_1799 heldStack = player.method_6079();
        if (heldStack.method_7909() instanceof PreservedShieldItem && player.method_6039() && !ShieldStaminaHandler.isOnCooldown((class_1657)player) && !player.method_68878()) {
            float newStamina;
            float currentStamina = ((Float)player.method_5841().method_12789(ModEntityData.PLAYER_SHIELD_STAMINA)).floatValue();
            float drainRate = 0.15f;
            if (lastBypassingSource != null) {
                drainRate *= 1.5f;
            }
            if ((newStamina = Math.max(0.0f, currentStamina - drainRate)) != currentStamina) {
                player.method_5841().method_12778(ModEntityData.PLAYER_SHIELD_STAMINA, (Object)Float.valueOf(newStamina));
            }
            if (newStamina <= 0.0f && currentStamina > 0.0f) {
                ShieldStaminaHandler.triggerCooldown((class_1657)player, heldStack);
            }
        }
    }

    private static void handleStaminaRegeneration(class_3222 player) {
        class_1799 stack = player.method_6079();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof PreservedShieldItem) {
            PreservedShieldItem shieldItem = (PreservedShieldItem)class_17922;
            if (!(player.method_6039() || ShieldStaminaHandler.isOnCooldown((class_1657)player) || ShieldStaminaHandler.isRegenBlocked((class_1657)player))) {
                float regenRate;
                float currentStamina = ((Float)player.method_5841().method_12789(ModEntityData.PLAYER_SHIELD_STAMINA)).floatValue();
                int maxStamina = shieldItem.getMaxStamina(stack);
                float newStamina = Math.min((float)maxStamina, currentStamina + (regenRate = shieldItem.getRegenerationRate(stack)));
                if (newStamina != currentStamina) {
                    player.method_5841().method_12778(ModEntityData.PLAYER_SHIELD_STAMINA, (Object)Float.valueOf(newStamina));
                }
            }
        }
    }

    private static void handleCooldown(class_3222 player) {
        if (playerShieldCooldownMap.containsKey(player.method_5667())) {
            int cooldown = playerShieldCooldownMap.get(player.method_5667());
            if (cooldown > 0) {
                playerShieldCooldownMap.put(player.method_5667(), cooldown - 1);
            } else {
                playerShieldCooldownMap.remove(player.method_5667());
            }
        }
    }

    private static void handleRegenBlock(class_3222 player) {
        if (regenBlockMap.containsKey(player.method_5667())) {
            int ticks = regenBlockMap.get(player.method_5667());
            if (ticks > 0) {
                regenBlockMap.put(player.method_5667(), ticks - 1);
            } else {
                regenBlockMap.remove(player.method_5667());
            }
        }
    }

    private static void checkStopBlocking(class_3222 player) {
        UUID id = player.method_5667();
        boolean isBlocking = player.method_6039();
        boolean wasBlocking = (Boolean)player.method_5841().method_12789(ModEntityData.PLAYER_WAS_BLOCKING);
        if (wasBlocking && !isBlocking) {
            regenBlockMap.put(id, 40);
        }
        player.method_5841().method_12778(ModEntityData.PLAYER_WAS_BLOCKING, (Object)isBlocking);
    }

    public static void triggerCooldown(class_1657 player, class_1799 shield) {
        if (shield.method_7909() instanceof PreservedShieldItem) {
            playerShieldCooldownMap.put(player.method_5667(), 200);
            ShieldStaminaHandler.stopBlocking(player);
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                class_1799 itemStack = player.method_31548().method_5438(i);
                if (!(itemStack.method_7909() instanceof PreservedShieldItem)) continue;
                player.method_7357().method_62835(itemStack, 200);
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_51469().method_43128(null, serverPlayer.method_23317(), serverPlayer.method_23318(), serverPlayer.method_23321(), ModSounds.SHIELD_COOLDOWN, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
    }

    private static void stopBlocking(class_1657 player) {
        player.method_6021();
    }

    private static void checkBlockingOnCooldown(class_3222 player) {
        if (ShieldStaminaHandler.isOnCooldown((class_1657)player) && player.method_6039() && player.method_6030().method_7909() instanceof PreservedShieldItem) {
            ShieldStaminaHandler.stopBlocking((class_1657)player);
        }
    }

    public static float getShieldStamina(class_1799 stack, class_1657 player) {
        if (stack.method_7909() instanceof PreservedShieldItem) {
            return ((Float)player.method_5841().method_12789(ModEntityData.PLAYER_SHIELD_STAMINA)).floatValue();
        }
        return 0.0f;
    }

    public static int getShieldMaxStamina(class_1799 stack) {
        if (stack.method_7909() instanceof PreservedShieldItem) {
            return ((PreservedShieldItem)stack.method_7909()).getMaxStamina(stack);
        }
        return 0;
    }

    public static boolean isOnCooldown(class_1657 player) {
        return playerShieldCooldownMap.containsKey(player.method_5667());
    }

    public static boolean isRegenBlocked(class_1657 player) {
        return regenBlockMap.containsKey(player.method_5667());
    }
}

