/*
 * Decompiled with CFR 0.152.
 */
package com.ducklegs.leafierlitter.world.biome;

import com.ducklegs.leafierlitter.utils.GetBiomeDownfall;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class CustomBiomeColors {
    private static final int[][] LEAF_COLORS = new int[][]{{10233606, 10712075, 14497544, 10189683, 16737034, 10174771, 10237001}, {16497409, 10712075, 16767744, 11047250, 16502017, 12352257, 16497571}};

    public static int getAutumnalFoliageColor(class_1920 world, class_2338 pos, LeafType leafType) {
        HashSet<class_6880<class_1959>> biomes = new HashSet<class_6880<class_1959>>();
        biomes.add(world.getBiomeFabric(pos));
        biomes.add(world.getBiomeFabric(pos.method_10095()));
        biomes.add(world.getBiomeFabric(pos.method_10072()));
        biomes.add(world.getBiomeFabric(pos.method_10078()));
        biomes.add(world.getBiomeFabric(pos.method_10067()));
        float[] temperatures = new float[biomes.size()];
        float[] humidities = new float[biomes.size()];
        int index = 0;
        for (class_6880 class_68802 : biomes) {
            temperatures[index] = ((class_1959)class_68802.comp_349()).method_8712();
            humidities[index] = ((GetBiomeDownfall)class_68802.comp_349()).getDownfall();
            ++index;
        }
        int color = CustomBiomeColors.blendBiomeColors(temperatures, humidities, biomes, leafType);
        return color;
    }

    private static int blendBiomeColors(float[] temperatures, float[] humidities, Set<class_6880<class_1959>> biomes, LeafType leafType) {
        int blendedColor = 0;
        class_6880[] biomeArray = biomes.toArray(new class_6880[0]);
        for (int i = 0; i < temperatures.length; ++i) {
            int color = CustomBiomeColors.getColorForBiome(temperatures[i], humidities[i], (class_6880<class_1959>)biomeArray[i], leafType);
            blendedColor = CustomBiomeColors.blendColors(blendedColor, color, 1.0f / (float)(i + 1));
        }
        return blendedColor;
    }

    private static int getColorForBiome(float temperature, float humidity, class_6880<class_1959> biome, LeafType leafType) {
        int[] colors = LEAF_COLORS[leafType.ordinal()];
        if ((double)temperature < 0.3) {
            return colors[6];
        }
        if ((double)temperature > 0.9 && (double)humidity < 0.2) {
            return colors[5];
        }
        if ((double)humidity > 0.9) {
            if ((double)temperature > 0.8) {
                return colors[2];
            }
            if ((double)temperature > 0.5) {
                return colors[4];
            }
            return colors[1];
        }
        if (biome.method_40225(class_1972.field_55052)) {
            return colors[3];
        }
        return colors[0];
    }

    private static int blendColors(int color1, int color2, float weight) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = class_3532.method_15340((int)((int)((float)r1 * (1.0f - weight) + (float)r2 * weight)), (int)0, (int)255);
        int g = class_3532.method_15340((int)((int)((float)g1 * (1.0f - weight) + (float)g2 * weight)), (int)0, (int)255);
        int b = class_3532.method_15340((int)((int)((float)b1 * (1.0f - weight) + (float)b2 * weight)), (int)0, (int)255);
        return r << 16 | g << 8 | b;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum LeafType {
        OAK,
        BIRCH;

    }
}

