/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer;

import de.guntram.mcmod.durabilityviewer.cloth.HudPosition;
import de.guntram.mcmod.durabilityviewer.cloth.WarnMode;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="durabilityviewer", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue SHOW_INVENTORY_ITEM_DURABILITY = BUILDER.comment("show inventory item durability").define("showInventoryItemDurability", true);
    private static final ForgeConfigSpec.BooleanValue ARMOR_AROUND_HOTBAR = BUILDER.comment("Armor Around Hotbar").define("armorAroundHotbar", false);
    private static final ForgeConfigSpec.BooleanValue EFFECT_DURATION = BUILDER.comment("show effect duration").define("effectDuration", true);
    private static final ForgeConfigSpec.EnumValue<HudPosition> HUD_POSITION = BUILDER.comment("HUD position").defineEnum("hudPosition", (Enum)HudPosition.BOTTOM_RIGHT);
    private static final ForgeConfigSpec.IntValue HIDE_DAMAGE_OVER_PERCENT = BUILDER.comment("hide hud damage over percent").defineInRange("hideDamageOverPercent", 100, 0, 100);
    private static final ForgeConfigSpec.IntValue SOUND_BELOW_DURABILITY = BUILDER.comment("play sound when durability is lower than this").defineInRange("soundBelowDurability", 20, 0, 1500);
    private static final ForgeConfigSpec.IntValue SOUND_BELOW_PERCENT = BUILDER.comment("play sound when percent is lower than this").defineInRange("soundBelowPercent", 10, 0, 100);
    private static final ForgeConfigSpec.BooleanValue SHOW_PERCENT_RATHER_THAN_DURABILITY = BUILDER.comment("show percent rather than durability").define("showPercentRatherThanDurability", false);
    private static final ForgeConfigSpec.IntValue PERCENT_TO_SHOW_DAMAGE_RATHER_THAN_DURABILITY = BUILDER.comment("percent to show damage rather than durability").defineInRange("percentToShowDamageRatherThanDurability", 80, 0, 100);
    private static final ForgeConfigSpec.BooleanValue SHOW_FREE_INVENTORY_SLOTS = BUILDER.comment("show free inventory slots").define("showFreeInventorySlots", true);
    private static final ForgeConfigSpec.EnumValue<WarnMode> WARNING_MODE = BUILDER.comment("warning mode").defineEnum("warningMode", (Enum)WarnMode.BOTH);
    private static final ForgeConfigSpec.BooleanValue SHOW_ALL_TRINKETS = BUILDER.comment("show  trinkets").define("showAllTrinkets", true);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean showInventoryItemDurability;
    public static boolean armorAroundHotbar;
    public static boolean effectDuration;
    public static HudPosition hudPosition;
    public static int hideDamageOverPercent;
    public static int soundBelowDurability;
    public static int soundBelowPercent;
    public static boolean showPercentRatherThanDurability;
    public static int percentToShowDamageRatherThanDurability;
    public static boolean showFreeInventorySlots;
    public static WarnMode warningMode;
    public static boolean showAllTrinkets;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        showInventoryItemDurability = (Boolean)SHOW_INVENTORY_ITEM_DURABILITY.get();
        armorAroundHotbar = (Boolean)ARMOR_AROUND_HOTBAR.get();
        effectDuration = (Boolean)EFFECT_DURATION.get();
        hudPosition = (HudPosition)((Object)HUD_POSITION.get());
        hideDamageOverPercent = (Integer)HIDE_DAMAGE_OVER_PERCENT.get();
        soundBelowDurability = (Integer)SOUND_BELOW_DURABILITY.get();
        soundBelowPercent = (Integer)SOUND_BELOW_PERCENT.get();
        showPercentRatherThanDurability = (Boolean)SHOW_PERCENT_RATHER_THAN_DURABILITY.get();
        percentToShowDamageRatherThanDurability = (Integer)PERCENT_TO_SHOW_DAMAGE_RATHER_THAN_DURABILITY.get();
        showFreeInventorySlots = (Boolean)SHOW_FREE_INVENTORY_SLOTS.get();
        warningMode = (WarnMode)((Object)WARNING_MODE.get());
        showAllTrinkets = (Boolean)SHOW_ALL_TRINKETS.get();
    }
}

