/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.client.gui;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.guntram.mcmod.durabilityviewer.Config;
import de.guntram.mcmod.durabilityviewer.cloth.HudPosition;
import de.guntram.mcmod.durabilityviewer.cloth.WarnMode;
import de.guntram.mcmod.durabilityviewer.itemindicator.InventorySlotsIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemCountIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemDamageIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemIndicator;
import de.guntram.mcmod.durabilityviewer.sound.ColytraBreakingWarner;
import de.guntram.mcmod.durabilityviewer.sound.ItemBreakingWarner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;

public class GuiItemDurability {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Minecraft minecraft = Minecraft.m_91087_();
    private static boolean visible;
    private final Font fontRenderer;
    private final ItemRenderer itemRenderer;
    private long lastWarningTime;
    private ItemStack lastWarningItem;
    private static final int iconWidth = 16;
    private static final int iconHeight = 16;
    private static final int spacing = 2;
    private static boolean haveTrinketsApi;
    private static boolean haveTRCore;
    private final ItemBreakingWarner mainHandWarner;
    private final ItemBreakingWarner offHandWarner;
    private final ItemBreakingWarner helmetWarner;
    private final ItemBreakingWarner chestWarner;
    private final ItemBreakingWarner pantsWarner;
    private final ItemBreakingWarner bootsWarner;
    private final ItemBreakingWarner colytraWarner;
    private ItemBreakingWarner[] trinketWarners;

    public static void toggleVisibility() {
        visible = !visible;
    }

    public GuiItemDurability() {
        this.fontRenderer = this.minecraft.f_91062_;
        this.itemRenderer = this.minecraft.m_91291_();
        visible = true;
        this.mainHandWarner = new ItemBreakingWarner();
        this.offHandWarner = new ItemBreakingWarner();
        this.helmetWarner = new ItemBreakingWarner();
        this.chestWarner = new ItemBreakingWarner();
        this.pantsWarner = new ItemBreakingWarner();
        this.bootsWarner = new ItemBreakingWarner();
        this.colytraWarner = new ColytraBreakingWarner();
        try {
            Class.forName("top.theillusivec4.curios.api.CuriosApi");
            LOGGER.info("Using curios in DurabilityViewer");
            haveTrinketsApi = true;
            this.trinketWarners = new ItemBreakingWarner[this.getTrinketSlotCount((Player)this.minecraft.f_91074_)];
            for (int i = 0; i < this.trinketWarners.length; ++i) {
                this.trinketWarners[i] = new ItemBreakingWarner();
            }
        }
        catch (ClassNotFoundException ex) {
            LOGGER.info("DurabilityViewer did not find curios API");
            this.trinketWarners = new ItemBreakingWarner[0];
        }
    }

    private int getInventoryArrowCount() {
        int arrows = 0;
        for (ItemStack stack : this.minecraft.f_91074_.m_150109_().f_35974_) {
            if (!this.isArrow(stack)) continue;
            arrows += stack.m_41613_();
        }
        return arrows;
    }

    private ItemStack getFirstArrowStack() {
        if (this.isArrow(this.minecraft.f_91074_.m_21206_())) {
            return this.minecraft.f_91074_.m_21206_();
        }
        if (this.isArrow(this.minecraft.f_91074_.m_21205_())) {
            return this.minecraft.f_91074_.m_21205_();
        }
        int size = this.minecraft.f_91074_.m_150109_().m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack itemstack = this.minecraft.f_91074_.m_150109_().m_8020_(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    private boolean isArrow(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() instanceof ArrowItem;
    }

    public void onRenderGameOverlayPost(GuiGraphics context, float partialTicks) {
        int ypos;
        int xposTrinkets;
        int xposTools;
        int xposArmor;
        long timeSinceLastWarning;
        ItemIndicator[] trinkets;
        InventorySlotsIndicator invSlots;
        LocalPlayer player = this.minecraft.f_91074_;
        ItemStack needToWarn = null;
        ItemIndicator mainHand = this.damageOrEnergy((Player)player, EquipmentSlot.MAINHAND);
        ItemIndicator offHand = this.damageOrEnergy((Player)player, EquipmentSlot.OFFHAND);
        ItemStack chestItem = player.m_6844_(EquipmentSlot.CHEST);
        ItemIndicator colytra = null;
        ItemDamageIndicator boots = new ItemDamageIndicator(player.m_6844_(EquipmentSlot.FEET));
        ItemDamageIndicator leggings = new ItemDamageIndicator(player.m_6844_(EquipmentSlot.LEGS));
        ItemDamageIndicator chestplate = new ItemDamageIndicator(chestItem);
        ItemDamageIndicator helmet = new ItemDamageIndicator(player.m_6844_(EquipmentSlot.HEAD));
        ItemCountIndicator arrows = null;
        InventorySlotsIndicator inventorySlotsIndicator = invSlots = Config.showFreeInventorySlots ? new InventorySlotsIndicator(this.minecraft.f_91074_.m_150109_()) : null;
        if (this.mainHandWarner.checkBreaks(player.m_6844_(EquipmentSlot.MAINHAND))) {
            needToWarn = player.m_6844_(EquipmentSlot.MAINHAND);
        }
        if (needToWarn == null && this.offHandWarner.checkBreaks(player.m_6844_(EquipmentSlot.OFFHAND))) {
            needToWarn = player.m_6844_(EquipmentSlot.OFFHAND);
        }
        if (needToWarn == null && this.bootsWarner.checkBreaks(player.m_6844_(EquipmentSlot.FEET))) {
            needToWarn = player.m_6844_(EquipmentSlot.FEET);
        }
        if (needToWarn == null && this.pantsWarner.checkBreaks(player.m_6844_(EquipmentSlot.LEGS))) {
            needToWarn = player.m_6844_(EquipmentSlot.LEGS);
        }
        if (needToWarn == null && this.chestWarner.checkBreaks(chestItem)) {
            needToWarn = chestItem;
        }
        if (needToWarn == null && this.helmetWarner.checkBreaks(player.m_6844_(EquipmentSlot.HEAD))) {
            needToWarn = player.m_6844_(EquipmentSlot.HEAD);
        }
        if (needToWarn == null && this.colytraWarner.checkBreaks(chestItem)) {
            needToWarn = chestItem;
        }
        if (haveTrinketsApi) {
            int i;
            List<ItemStack> equipped = GuiItemDurability.getAllCuriosItems((Player)player);
            trinkets = new ItemIndicator[equipped.size()];
            if (trinkets.length > this.trinketWarners.length) {
                this.trinketWarners = new ItemBreakingWarner[trinkets.length];
                for (i = 0; i < this.trinketWarners.length; ++i) {
                    this.trinketWarners[i] = new ItemBreakingWarner();
                }
            }
            LOGGER.debug("know about " + trinkets.length + " curios, invSize is " + equipped.size() + ", have " + this.trinketWarners.length + " warners");
            for (i = 0; i < trinkets.length; ++i) {
                trinkets[i] = new ItemDamageIndicator(equipped.get(i), Config.showAllTrinkets);
                if (needToWarn == null && this.trinketWarners[i].checkBreaks(equipped.get(i))) {
                    needToWarn = equipped.get(i);
                }
                LOGGER.debug("curios position " + i + " has item " + equipped.get(i).m_41720_().toString());
            }
        } else {
            trinkets = new ItemIndicator[]{};
        }
        WarnMode warnMode = Config.warningMode;
        if (needToWarn != null) {
            if (warnMode == WarnMode.SOUND || warnMode == WarnMode.BOTH) {
                ItemBreakingWarner.playWarningSound();
            }
            this.lastWarningTime = System.currentTimeMillis();
            this.lastWarningItem = needToWarn;
        }
        if ((timeSinceLastWarning = System.currentTimeMillis() - this.lastWarningTime) < 1000L && (warnMode == WarnMode.VISUAL || warnMode == WarnMode.BOTH)) {
            this.renderItemBreakingOverlay(context, this.lastWarningItem, timeSinceLastWarning);
        }
        if (!visible || this.minecraft.f_91066_.f_92063_) {
            return;
        }
        if (mainHand.getItemStack().m_41720_() instanceof ProjectileWeaponItem || offHand.getItemStack().m_41720_() instanceof ProjectileWeaponItem) {
            arrows = new ItemCountIndicator(this.getFirstArrowStack(), this.getInventoryArrowCount());
        }
        Window mainWindow = Minecraft.m_91087_().m_91268_();
        RenderSize armorSize = Config.armorAroundHotbar ? new RenderSize(0, 0) : this.renderItems(context, 0, 0, false, RenderPos.left, 0, boots, leggings, colytra, chestplate, helmet);
        RenderSize toolsSize = this.renderItems(context, 0, 0, false, RenderPos.right, 0, invSlots, mainHand, offHand, arrows);
        RenderSize trinketsSize = this.renderItems(context, 0, 0, false, RenderPos.left, 0, trinkets);
        int totalHeight = Math.max(toolsSize.height, armorSize.height);
        if (trinketsSize.height > totalHeight) {
            totalHeight = trinketsSize.height;
        }
        if (trinketsSize.width == 0 && trinkets.length > 0 && Config.showAllTrinkets) {
            trinketsSize.width = 20;
        }
        HudPosition hudPosition = Config.hudPosition;
        switch (hudPosition) {
            case TOP_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                xposTrinkets = 5 + armorSize.width + trinketsSize.width;
                ypos = 5;
                break;
            }
            case TOP_RIGHT: {
                xposArmor = mainWindow.m_85445_() - 5 - armorSize.width;
                xposTools = xposArmor - toolsSize.width;
                xposTrinkets = xposTools - trinketsSize.width;
                ypos = 60;
                break;
            }
            case BOTTOM_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                xposTrinkets = 5 + armorSize.width + trinketsSize.width;
                ypos = mainWindow.m_85446_() - 5 - totalHeight;
                break;
            }
            case BOTTOM_RIGHT: {
                xposArmor = mainWindow.m_85445_() - 5 - armorSize.width;
                xposTools = mainWindow.m_85445_() - 5 - armorSize.width - toolsSize.width;
                xposTrinkets = xposTools - trinketsSize.width;
                ypos = mainWindow.m_85446_() - 5 - totalHeight;
                break;
            }
            default: {
                return;
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (Config.armorAroundHotbar) {
            int leftOffset = -120;
            int rightOffset = 100;
            if (!player.m_6844_(EquipmentSlot.OFFHAND).m_41619_()) {
                if (this.minecraft.f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT) {
                    leftOffset -= 20;
                } else {
                    rightOffset += 20;
                }
            }
            int helmetTextWidth = this.fontRenderer.m_92895_(helmet.getDisplayValue());
            int chestTextWidth = this.fontRenderer.m_92895_(chestplate.getDisplayValue());
            this.renderItems(context, mainWindow.m_85445_() / 2 + leftOffset - helmetTextWidth, mainWindow.m_85446_() - 32 - 2, true, RenderPos.left, helmetTextWidth + 16 + 2, helmet);
            this.renderItems(context, mainWindow.m_85445_() / 2 + leftOffset - chestTextWidth, mainWindow.m_85446_() - 16 - 2, true, RenderPos.left, chestTextWidth + 16 + 2, chestplate);
            if (colytra != null) {
                int colytraTextWidth = this.fontRenderer.m_92895_(colytra.getDisplayValue());
                this.renderItems(context, mainWindow.m_85445_() / 2 + leftOffset - chestTextWidth - colytraTextWidth - 16, mainWindow.m_85446_() - 16 - 2, true, RenderPos.left, colytraTextWidth + 16 + 2, colytra);
            }
            this.renderItems(context, mainWindow.m_85445_() / 2 + rightOffset, mainWindow.m_85446_() - 32 - 2, true, RenderPos.right, armorSize.width, leggings);
            this.renderItems(context, mainWindow.m_85445_() / 2 + rightOffset, mainWindow.m_85446_() - 16 - 2, true, RenderPos.right, armorSize.width, boots);
            xposTools = hudPosition.isRight() ? (xposTools += armorSize.width) : (xposTools -= armorSize.width);
        } else {
            this.renderItems(context, xposArmor, ypos, true, hudPosition.isLeft() ? RenderPos.left : RenderPos.right, armorSize.width, helmet, chestplate, colytra, leggings, boots);
        }
        this.renderItems(context, xposTools, ypos, true, hudPosition.isRight() ? RenderPos.right : RenderPos.left, toolsSize.width, invSlots, mainHand, offHand, arrows);
        if (Config.showAllTrinkets) {
            this.renderItems(context, xposTrinkets, ypos, true, hudPosition.isRight() ? RenderPos.right : RenderPos.left, trinketsSize.width, trinkets);
        }
    }

    private ItemIndicator damageOrEnergy(Player player, EquipmentSlot slot) {
        ItemStack stack = player.m_6844_(slot);
        if (stack.m_41763_()) {
            return new ItemDamageIndicator(stack);
        }
        if (haveTRCore) {
            // empty if block
        }
        return new ItemDamageIndicator(stack);
    }

    private void renderItemBreakingOverlay(GuiGraphics context, ItemStack itemStack, long timeDelta) {
        Window mainWindow = Minecraft.m_91087_().m_91268_();
        float alpha = 1.0f - (float)timeDelta / 1000.0f;
        float xWarn = (float)mainWindow.m_85445_() / 2.0f;
        float yWarn = (float)mainWindow.m_85446_() / 2.0f;
        float scale = 5.0f;
        context.m_280509_(0, 0, mainWindow.m_85445_(), mainWindow.m_85446_(), 0xFF0000 + ((int)(alpha * 128.0f) << 24));
        PoseStack stack = RenderSystem.getModelViewStack();
        stack.m_85836_();
        stack.m_85841_(scale, scale, scale);
        RenderSystem.applyModelViewMatrix();
        context.m_280480_(itemStack, (int)(xWarn / scale - 8.0f), (int)(yWarn / scale - 8.0f));
        stack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void afterRenderStatusEffects(GuiGraphics context, float partialTicks) {
        if (Config.effectDuration) {
            Window mainWindow = Minecraft.m_91087_().m_91268_();
            Collection collection = this.minecraft.f_91074_.m_21220_();
            int posGood = 0;
            int posBad = 0;
            for (MobEffectInstance potioneffect : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
                int ypos;
                if (!potioneffect.m_19575_()) continue;
                MobEffect potion = potioneffect.m_19544_();
                int xpos = mainWindow.m_85445_();
                if (potion.m_19486_()) {
                    xpos -= (posGood += 25);
                    ypos = 15;
                } else {
                    xpos -= (posBad += 25);
                    ypos = 41;
                }
                int duration = potioneffect.m_19557_();
                String show = duration > 1200 ? duration / 1200 + "m" : duration / 20 + "s";
                context.m_280056_(this.fontRenderer, show, xpos + 2, ypos, ItemIndicator.color_yellow, true);
            }
        }
    }

    private RenderSize renderItems(GuiGraphics context, int xpos, int ypos, boolean reallyDraw, RenderPos numberPos, int maxWidth, ItemIndicator ... items) {
        RenderSize result = new RenderSize(0, 0);
        for (ItemIndicator item : items) {
            if (item == null || item.isEmpty() || !item.isItemStackDamageable()) continue;
            String displayString = item.getDisplayValue();
            int width = this.fontRenderer.m_92895_(displayString);
            if (width > result.width) {
                result.width = width;
            }
            if (reallyDraw) {
                int color = item.getDisplayColor();
                context.m_280480_(item.getItemStack(), numberPos == RenderPos.left ? xpos + maxWidth - 16 - 2 : xpos, ypos + result.height);
                int n = numberPos != RenderPos.right ? xpos : xpos + 16 + 2;
                float f = ypos + result.height;
                Objects.requireNonNull(this.fontRenderer);
                context.m_280056_(this.fontRenderer, displayString, n, (int)(f + 9.0f / 2.0f + (float)(numberPos == RenderPos.over ? 10 : 0)), color, true);
            }
            result.height += 16;
        }
        if (result.width != 0) {
            result.width += 20;
        }
        return result;
    }

    public int getTrinketSlotCount(Player player) {
        return CuriosApi.getPlayerSlots((Player)player).size();
    }

    public static List<ItemStack> getAllCuriosItems(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.getCurios().forEach((id, stacksHandler) -> {
            for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                ItemStack stack = stacksHandler.getStacks().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                items.add(stack);
            }
        }));
        return items;
    }

    static {
        haveTrinketsApi = false;
        haveTRCore = false;
    }

    private static class RenderSize {
        int width;
        int height;

        RenderSize(int w, int h) {
            this.width = w;
            this.height = h;
        }
    }

    private static enum RenderPos {
        left,
        over,
        right;

    }
}

