/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.sound;

import de.guntram.mcmod.durabilityviewer.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public class ItemBreakingWarner {
    private int lastDurability = 1000;
    private ItemStack lastStack = null;
    private static SoundEvent sound;

    public ItemBreakingWarner() {
        if (sound == null) {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"durabilityviewer", (String)"tool_breaking");
            sound = SoundEvent.m_262824_((ResourceLocation)location);
        }
    }

    public boolean checkBreaks(ItemStack stack) {
        this.lastStack = stack;
        if (stack == null || !stack.m_41763_()) {
            return false;
        }
        int newDurability = stack.m_41776_() - stack.m_41773_();
        if (newDurability < this.lastDurability && newDurability < Config.soundBelowDurability && newDurability * 100 / Config.soundBelowPercent < stack.m_41776_()) {
            this.lastDurability = newDurability;
            return true;
        }
        this.lastDurability = newDurability;
        return false;
    }

    public static void playWarningSound() {
        Minecraft.m_91087_().f_91074_.m_5496_(sound, 100.0f, 100.0f);
    }
}

